/**
 * Copyright aobyrne ( http://wonderfl.net/user/aobyrne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8UsH
 */

// forked from twotree's flash on 2010-5-27
package
{
    import Box2D.Collision.b2AABB;
    import Box2D.Common.Math.b2Vec2;
    import Box2D.Dynamics.b2Body;
    import Box2D.Dynamics.b2DebugDraw;
    import Box2D.Dynamics.b2World;
    import Box2D.Dynamics.Joints.b2RevoluteJointDef;
    import com.actionsnippet.qbox.QuickBox2D;
    import com.actionsnippet.qbox.QuickObject;
    import com.bit101.components.PushButton;
    import flash.display.MovieClip;
    import flash.events.Event;
 
    [SWF(backgroundColor="0x414647")]
    public class QuickBox2DInitializeWorld extends MovieClip
    {
        private var world:b2World;
        private var scale:Number = 30;
        private var quickBox2D:QuickBox2D;
 
        public function QuickBox2DInitializeWorld()
        {
            var useQuickBox2D:Boolean = true;
            if (!useQuickBox2D) 
            {
                
                var worldAABB:b2AABB = new b2AABB();
                worldAABB.lowerBound.Set(-100, -100);
                worldAABB.upperBound.Set(stage.stageWidth + 100, stage.stageHeight + 100);
     
                var gravity:b2Vec2 = new b2Vec2(0, 5);
                world = new b2World(worldAABB, gravity, true);
     
                var draw:b2DebugDraw = new b2DebugDraw();
                draw.m_sprite = this;
                draw.m_drawScale = scale;
                draw.m_drawFlags = b2DebugDraw.e_shapeBit | b2DebugDraw.e_jointBit;
                world.SetDebugDraw(draw);
            }
            else
            {
                quickBox2D = new QuickBox2D(this, { debug:true } );
                quickBox2D.mouseDrag();
                quickBox2D.gravity = new b2Vec2;
                //quickBox2D.grid();
                world = quickBox2D.w;
            }
            Shape.world = world;
            Shape.scale = scale;
            Shape.create( { shape:Shape.RECT, x:0, y:465, width:465, height:1 } );
 
            var bodyB:b2Body = Shape.create( { shape:Shape.RECT, x:3*scale, y:3*scale, y:3*scale, width:2*scale, height:1*scale, density:0, restitution:0.6,angle:0.000001 } );
            var bodyA:b2Body = Shape.create( { shape:Shape.RECT, x:6*scale, y:3*scale, width:2*scale, height:1*scale, density:10, restitution:0.8 ,groupIndex:-1,angle:0.000001} );
            var bodyC:b2Body = Shape.create( { shape:Shape.RECT, x:3*scale, y:3*scale, y:3*scale, width:2*scale, height:1*scale, density:0, restitution:0.6 , angle:2} );
            var bodyD:b2Body = Shape.create( { shape:Shape.RECT, x:6*scale, y:3*scale, width:2*scale, height:1*scale, density:10, restitution:0.8 ,groupIndex:-1} );
 
            createJoint(bodyC,bodyD);    
            createJoint(bodyB,bodyA);    
            if (useQuickBox2D) 
            {
                /*/
                quickBox2D.start();
                /*/
                new PushButton(this, 0, 0, "step", onStep);
                new PushButton(this, 110, 0, "start", onStart);
                //*/
            }
            else
            {
                addEventListener(Event.ENTER_FRAME, onEnterFrame);
            }
            
            var a:QuickObject = quickBox2D.addBox( { x:3, y:3, y:3, width:2, height:1, density:0, angle:0. } );
            var b:QuickObject = quickBox2D.addBox( { x:6, y:3, y:3, width:2, height:1, density:10, angle:0., groupIndex: -1 } );
            //quickBox2D.addJoint( { type:QuickBox2D.REVOLUTE, 'a':a.body, 'b':b.body, x1:a.body.GetWorldCenter().x + 0.5, y1:a.body.GetWorldCenter().y,lowerAngle:-10/ 180*Math.PI,upperAngle : 50 / 180*Math.PI,enableLimit :true } )
            quickBox2D.addJoint( { type:QuickBox2D.REVOLUTE, 'a':a.body, 'b':b.body,vecA:new b2Vec2(a.body.GetWorldCenter().x + 0.5, a.body.GetWorldCenter().y),lowerAngle:-10/ 180*Math.PI,upperAngle : 50 / 180*Math.PI,enableLimit :true } )
            
        }
        
        private function onStart(e:Event):void 
        {
            quickBox2D.start();
        }
        
        private function onStep(e:Event):void 
        {
            
            onEnterFrame(e);
        }
        
        private function createJoint(first:b2Body,second:b2Body):void 
        {
            var joint:b2RevoluteJointDef = new b2RevoluteJointDef();
            //joint.Initialize(bodyA, bodyB, new b2Vec2(bodyA.GetWorldCenter().x, bodyA.GetWorldCenter().y));
            joint.Initialize(first, second, new b2Vec2(first.GetWorldCenter().x+0.5, first.GetWorldCenter().y));
            joint.lowerAngle = -10 / (180/Math.PI);
            joint.upperAngle = 50 / (180/Math.PI);
            joint.enableLimit = true;
            joint.motorSpeed = 4;
            joint.userData = { skin:"none" };
            //joint.collideConnected
            trace( "joint.collideConnected : " + joint.collideConnected );
            world.CreateJoint(joint);
        
        }
        
        
        private function onEnterFrame(event:Event):void 
        {
            world.Step(1 / 60, 10);
        }
    }
}
 
import Box2D.Collision.Shapes.b2CircleDef;
import Box2D.Collision.Shapes.b2PolygonDef;
import Box2D.Collision.Shapes.b2ShapeDef;
import Box2D.Common.Math.b2Vec2;
import Box2D.Dynamics.b2Body;
import Box2D.Dynamics.b2BodyDef;
import Box2D.Dynamics.b2World;
 
class Shape
{
    public static const CIRCLE:int = 0;
    public static const RECT:int = 1;
 
    public static var world:b2World;
    public static var scale:Number;
 
    public static function addVec2(body:b2Body, x:Number, y:Number):void
    {
        body.SetXForm(new b2Vec2(body.GetPosition().x + x / scale, body.GetPosition().y + y / scale), body.GetAngle());
    }
 
    public static function setVec2(body:b2Body, x:Number, y:Number):void
    {
        body.SetXForm(new b2Vec2(x / scale, y / scale), body.GetAngle());
    }
 
    public static function addAngle(body:b2Body, rotate:Number):void
    {
        body.SetXForm(body.GetPosition(), body.GetAngle() + rotate * Math.PI / 180);
    }
 
    public static function setAngle(body:b2Body, rotate:Number):void
    {
        body.SetXForm(body.GetPosition(), rotate * Math.PI / 180);
    }
 
    public static function create(params:Object):b2Body
    {
        var def:b2BodyDef = new b2BodyDef();
        if (params.angle) def.angle = params.angle * Math.PI / 180;
        
        var shape:b2ShapeDef;
        if (params.shape == Shape.RECT)
        {
            //def.position.Set((params.x + params.width / 2) / scale, (params.y + params.height / 2) / scale);
            def.position.Set(params.x / scale, params.y / scale);
            def.angle = params.angle?params.angle:0;
            shape = new b2PolygonDef();
            b2PolygonDef(shape).SetAsBox(params.width / 2 / scale, params.height / 2 / scale);
        }
        else if (params.shape == Shape.CIRCLE)
        {
            def.position.Set(params.x / scale, params.y / scale);
            shape = new b2CircleDef();
            b2CircleDef(shape).radius = params.radius / scale;
        }
 
        shape.filter.groupIndex = params.groupIndex?params.groupIndex:shape.filter.groupIndex;
        shape.density = params.density;
        shape.restitution = params.restitution;
        
 
        var body:b2Body = world.CreateBody(def);
        //body.group
        body.CreateShape(shape);
 
        if (shape.density > 0) body.SetMassFromShapes();
 
        return body;
    }
}

