/**
 * Copyright rettuce ( http://wonderfl.net/user/rettuce )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8UBm
 */

package 
{
    import flash.display.MovieClip;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;

    // library
    import caurina.transitions.Tweener;

    [SWF(width = 465, height = 465, backgroundColor = 0x000000, frameRate = 60)]
    /**
     * ...
     * @author rettuce
     */
    public class DocumentClass extends Sprite
    {
        private var _kanri:Boolean = true;  ///////////////////////// 深度管理スイッチ        

        private var ROTATE0:String = "rotate0";
        private var ROTATE45:String  = "rotate45";
        private var ROTATE90:String  = "rotate90";
        private var ROTATE135:String = "rotate135";
        private var ROTATE180:String = "rotate180";
        private var ROTATE225:String = "rotate225";
        private var ROTATE270:String = "rotate270";
        private var ROTATE315:String = "rotate315";        

        private var _cube:MovieClip;
        private var _cnt:int = 0;        

        private var _col:Number = 0xFFFFFF;
        private var _alp:Number = 1;        

        private var _wid:Number = 150;
        private var _hei:Number = 150;
        private var _dep:Number = 150;
        
        public function DocumentClass()
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);        
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);         
            cubeInit();
        }
        
        private function cubeInit()
        {
            _cube = new Cube( _col, _alp);
            _cube.createBox( _wid, _hei, _dep );
            _cube.x = stage.stageWidth / 2;
            _cube.y = stage.stageHeight / 2;
            addChild(_cube);            
            
            stage.addEventListener(MouseEvent.CLICK, change );
            addEventListener(Event.ENTER_FRAME, animation);
            
           if(_kanri){
                addEventListener( ROTATE0 , rotateHandler );
            }
        }
        
        private function rotateHandler(e:Event)
        {
            switch( e.type ) {
                case "rotate0":
                    removeEventListener(ROTATE0, rotateHandler );
                    addEventListener( ROTATE45 , rotateHandler );
                    break;
                    
                case "rotate45":
                    removeEventListener(ROTATE45, rotateHandler );
                    addEventListener( ROTATE90 , rotateHandler );
                    break;
                    
                case "rotate90":
                    removeEventListener(ROTATE90, rotateHandler );
                    addEventListener( ROTATE135 , rotateHandler );
                    break;
                    
                case "rotate135":
                    removeEventListener(ROTATE135, rotateHandler );
                    addEventListener( ROTATE180 , rotateHandler );
                    break;
                    
                case "rotate180":
                    removeEventListener(ROTATE180, rotateHandler );
                    addEventListener( ROTATE225 , rotateHandler );
                    break;
                    
                case "rotate225":
                    removeEventListener(ROTATE225, rotateHandler );
                    addEventListener( ROTATE270 , rotateHandler );
                    break;
                    
                case "rotate270":
                    removeEventListener(ROTATE270, rotateHandler );
                    addEventListener( ROTATE315 , rotateHandler );
                    break;
                    
                case "rotate315":
                    removeEventListener(ROTATE315, rotateHandler );
                    addEventListener( ROTATE0 , rotateHandler );
                    break;
            }
            
            depthChange(Math.floor(keisu));
        }
        
        
        private function change(e:MouseEvent)
        {
            _cube.open();
        }
        
        private function depthChange( num:Number )
        {
            var cnt:int = Math.floor( num / 45 );    // 0, 1, 2, 3, 4, 5, 6, 7
            trace( cnt )
            switch( cnt ) {
                case 0:
                    _cube.setIndexTop( 1 );
                    _cube.setIndexTop( 2 );
                    break;
                case 1:
                    _cube.setIndexTop( 1 );
                    break;
                case 2:
                    _cube.setIndexTop( 0 );
                    _cube.setIndexTop( 1 );
                    break;
                case 3:
                    _cube.setIndexTop( 0 );
                    break;
                case 4:
                    _cube.setIndexTop( 3 );
                    _cube.setIndexTop( 0 );
                    break;
                case 5:
                    _cube.setIndexTop( 3 );
                    break;
                case 6:
                    _cube.setIndexTop( 2 );
                    _cube.setIndexTop( 3 );
                    break;
                case 7:
                    _cube.setIndexTop( 2 );
                    break;       
            }
        }
        
        private var plusY:Number = 0.2;        
        private var keisu:Number = 0;
        private function animation(e:Event):void
        {
            _cube.rotationY += plusY;
            keisu = _cube.rotationY;
            
            if ( keisu <= 45 ) {
                dispatchEvent( new Event( ROTATE0 ) );
            } else if ( 45  < keisu && keisu <= 90 ) {
                dispatchEvent( new Event( ROTATE45 ) );
            } else if ( 90  < keisu && keisu <= 135 ) {
                dispatchEvent( new Event( ROTATE90 ) );
            } else if ( 135  < keisu && keisu <= 180 ) {
                dispatchEvent( new Event( ROTATE135 ) );
            } else if ( 180 < keisu && keisu <= 225 ) {
                dispatchEvent( new Event( ROTATE180 ) );
            } else if ( 225 < keisu && keisu <= 270 ) {
                dispatchEvent( new Event( ROTATE225 ) );
            } else if ( 270 < keisu && keisu <= 315 ) {
                dispatchEvent( new Event( ROTATE270 ) );
            } else if ( 315 < keisu && keisu <= 360 ) {
                dispatchEvent( new Event( ROTATE315 ) );
            } else if ( 360 < keisu ) {
                _cube.rotationY = 0;
            }
        }        
    }
}


import flash.display.MovieClip;
import flash.display.Sprite;
import flash.display.Graphics;
import flash.display.Bitmap;
import flash.display.BitmapData;

// library
import caurina.transitions.Tweener;
/*
 *         _cube = new Cube( 0xFFFFFF, 0.3 ); // color, alpha
 *         _cube.createBox( 200, 200, 300 );    // width, height, depth
 *         addChild(_cube); 
 */
class Cube extends MovieClip
{    

    private var _col:Number;
    private var _alp:Number;    
    public var planeArr:Array = [];
    
    function Cube( col:Number = 0xFF0000, alp:Number = 0.3 )
    {
        _col = col;
        _alp = alp;        
    }
    
    public function createBox( wid:Number, hei:Number, dep:Number  ):void
    {
        for (var i = 0; i < 6; i++ ) {
            var s = new Sprite();
            var g = s.graphics;
            
            g.lineStyle (1, _col, 1);    // 線のスタイル指定
            g.beginFill (_col*Math.random(), _alp);    // 面のスタイル設定
            
            if ( i == 0 || i == 2 ) {
                g.drawRect  (0, 0 , wid , hei);
            }else if ( i == 1 || i == 3 ) {
                g.drawRect  (0, 0 , dep , hei);
            }else if ( i == 4 || i == 5 ) {
                g.drawRect  (0, 0 , wid , dep);
            }
            planeArr.push(s);
            this.addChild(s);
        }
            
        planeArr[0].x = -wid/2;
        planeArr[0].y = -hei/2;
        planeArr[0].z =   dep/2;

        planeArr[1].x =  wid/2;
        planeArr[1].y = -hei/2;
        planeArr[1].z = -dep/2;
        planeArr[1].rotationY = -90;

        planeArr[2].x = -wid/2;
        planeArr[2].y = -hei/2;
        planeArr[2].z = -dep/2;

        planeArr[3].x = -wid/2;
        planeArr[3].y = -hei/2;
        planeArr[3].z = -dep/2;
        planeArr[3].rotationY = -90;

        planeArr[4].x = -wid/2;
        planeArr[4].y = -hei/2;
        planeArr[4].z =  dep/2;
        planeArr[4].rotationX = -90;

        planeArr[5].x = -wid/2;
        planeArr[5].y =  hei/2;
        planeArr[5].z = -dep/2;
        planeArr[5].rotationX = 90;
    }
        
    public function setIndexTop( num:int )
    {
        setChildIndex( planeArr[num], planeArr.length - 1 );
    }
    public function open()
    {
        Tweener.addTween( planeArr[4] ,{ rotationX:-180, time:1,  onComplete:function() {
            Tweener.addTween( planeArr[4], { rotationX:-90, time:1 } );
        }} );
    }  
}
