/**
 * Copyright jloa ( http://wonderfl.net/user/jloa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8Sto
 */

package
{
    import flash.display.MovieClip;
    import flash.display.Graphics;
    import flash.display.Shape;
    import flash.display.JointStyle;
    import flash.display.CapsStyle;
    import flash.display.LineScaleMode;
    import flash.events.Event;

    [SWF(width="400", height="400", frameRate="50")]
    public class MitterBug extends MovieClip
    {
        private var inc:Boolean = true;
        private var b:int = 1;
        private var jointStyles:Array = [JointStyle.BEVEL, JointStyle.ROUND, JointStyle.MITER];    // MITTER's buggy
        
        /**
         * There's this bug when fp redraws a rotated graphic when JoinStyle.MITER is used with LineScaleMode.NONE
         */
        public function MitterBug()
        {
            if(stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }

        private function init(event:Event = null):void
        {
            var n:int = jointStyles.length;
            for(var i:int = 0; i < n; ++i) addChild(new Shape());
            addEventListener(Event.ENTER_FRAME, onEnterFrameHandler);
        }

        private function redrawRect(g:Graphics, b:int, j:String, w:int, h:int):void
        {
            g.clear();
            g.lineStyle(b, 0, 1, true, LineScaleMode.NONE, CapsStyle.NONE, j);
            g.beginFill(0xff0000, 1);
            g.drawRect(0, 0, w, h);
            g.endFill();
        }

        private function onEnterFrameHandler(event:Event):void
        {
            if(b == 50)  inc = false;    // increase 'til 50
            if(b == 0)   inc = true;     // decrease 'til 0

            if(inc) b++;
            else    b--;

            var n:int = jointStyles.length;

            for(var i:int = 0; i < n; ++i)
            {
                var s:Shape = getChildAt(i) as Shape;
                s.rotation++;
                s.x = 200;
                s.y = 70 + i*120;
                redrawRect(s.graphics, b, jointStyles[i], 40, 40);
            }
        }
    }
}
