/**
 * Copyright hi.kurosawa ( http://wonderfl.net/user/hi.kurosawa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8RsJ
 */

package {
    //------------------------------------------
    //怪しい微生物ではありません！
    // URL:http://programmingatelier.net/
    //------------------------------------------
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.utils.setTimeout;
    import flash.display.StageScaleMode; 
    import flash.display.StageAlign;
    
    public class microorganism extends Sprite {
        public var arrItiData:Array = new Array(
            {a:-0.06,af:false,b:0.73,bf:true,x:0.24743056422813997,y:0.1535164738292011,d:0.00038868725737412595},
            {a:0.01,af:false,b:0.8,bf:true,x:0.13823131919203485,y:0.2457280356946625,d:0.005318045446589325},
            {a:-0.06,af:false,b:0.72,bf:true,x:0.12538519924098673,y:-0.03877419354838705,d:0.01897533206831119},
            {a:-0.06,af:false,b:0.74,bf:true,x:-0.24984615384615383,y:0.009692307692307722,d:0.0724852071005917},
            {a:-0.05,af:false,b:0.72,bf:true,x:0.12835523117953296,y:0.05723976245164542,d:0.0007416668575815191},
            {a:0.31,af:false,b:0.49,bf:true,x:0.0346297820454199,y:-0.19050114311842703,d:0.029873494894071026},
            {a:0.31, af:false, b:0.49, bf:true, x:0.2791865765088906, y:0.885066310487798, d:0.05453988925063306 },
            {a:0.32,af:false,b:0.52,bf:true,x:0.49411852123142785,y:0.5889131085062956,d:0.009345305568150117},
            {a:0.32,af:false,b:0.52,bf:true,x:0.04594642857142856,y:0.1405625,d:0.055803571428571425},
            {a:0.3,af:false,b:0.51,bf:true,x:0.18550646666181858,y:0.12441085679973798,d:0.007773077048298202},
            {a:0.31,af:false,b:0.51,bf:true,x:0.18057645267831027,y:0.15211565170280358,d:0.001762602505283039},
            {a:0.4,af:false,b:0.2,bf:true,x:0.15545926263086024,y:-0.054990782885753285,d:0.004733016613563952},
            {a:0.38,af:false,b:0.37,bf:true,x:0.37515814988191354,y:0.498146499170328,d:0.000003109251339921738},
            {a:0.31,af:false,b:0.51,bf:true,x:-0.0047960512497374486,y:0.07667506826296998,d:0.00567229512737855},
            {a:0.31,af:false,b:0.49,bf:true,x:0.25961065197428834,y:0.5879485766758494,d:0.03895706375045219},
            {a:0.31,af:false,b:0.51,bf:true,x:0.33461858251940896,y:0.3532794056265131,d:0.01180517083347036},
            {a:0.32,af:false,b:0.5,bf:true,x:0.19727272727272727,y:0.12194405594405594,d:0.049950049950049945},
            {a:0.3,af:false,b:0.5,bf:true,x:-0.15281359548849255,y:-0.1940954461548883,d:0.04116167175660138},
            {a:0.31,af:false,b:0.5,bf:true,x:0.20638302699704142,y:0.004556329511834323,d:0.021874999999999995},
            {a:0.33,af:false,b:0.53,bf:true,x:-0.3011075860935316,y:-0.8774595216569407,d:0.06616257088846882},
            {a:0.35,af:false,b:0.53,bf:true,x:0.08217391304347824,y:0.2142608695652174,d:0.06616257088846882},
            {a:-0.03,af:false,b:0.84,bf:true,x:0.24194657375145176,y:0.26060859465737507,d:0.05602240896358543},
            {a:-0.02,af:false,b:0.78,bf:true,x:0.5109947933884297,y:0.7715402314049585,d:0.030398196844477834},
            {a:-0.05,af:false,b:0.73,bf:true,x:0.5620403102122932,y:0.7615742342487783,d:0.012347867219926374},
            {a:-0.07,af:false,b:0.73,bf:true,x:-0.2229230769230769,y:-0.154,d:0.010769230769230767},
            {a:-0.05,af:false,b:0.73,bf:true,x:0.3165861344537814,y:0.12464135654261704,d:0.02670185721347363},
            {a:-0.06,af:false,b:0.73,bf:true,x:0.7892378152960002,y:0.5149279027200001,d:2.5599999999999996e-7},
            {a:-0.02,af:false,b:0.8,bf:true,x:0.09857039384336803,y:-0.1520543232231779,d:0.04979628791308285},
            {a:-0.01,af:false,b:0.81,bf:true,x:0.24934141136645105,y:0.22338571324348777,d:0.00021591338285282632},
            {a:-0.02,af:false,b:0.77,bf:true,x:0.10951192150372525,y:-0.036861312692595245,d:0.012891581442941386},
            {a:-0.02,af:false,b:0.81,bf:true,x:0.5156831929106106,y:0.7861180222214764,d:0.051693464469134975},
            {a:-0.01,af:false,b:0.81,bf:true,x:0.21181920903954798,y:0.2243954802259887,d:0.06084311169056931},
            {a:0.01,af:false,b:0.81,bf:true,x:0.1214183041884502,y:0.26446715942551524,d:0.009254251547382969},
            {a:-0.05,af:false,b:0.73,bf:true,x:0.14003961516694963,y:0.1898279569892473,d:0.01523660267293544},
            {a:-0.06,af:false,b:0.73,bf:true,x:0.20615851052631576,y:-0.7675438473684211,d:0.0009947368421052629}
        );
        //ジュリア集合の描画エリア
        private var bdMandelbrot:BitmapData;
        public var arrColor:Array;    //グラデーションカラー
        public var uintHassan:uint;    //発散しない時のカラー
        private var numA:Number;
        private var numB:Number;
        private var bolA:Boolean;
        private var bolB:Boolean;
        
        private var intBMw:Number;    //描画サイズ
        private var intBMh:Number;
        private var iloop:int;        //描画状態(0～39)
        private var iTyp:int;        //画像の切り替え時のエフェクト
        private    var xMin:Number;    //ジュリア集合の左上の座標値
        private    var yMin:Number;
        private    var Step:Number;    //ジュリア集合の1ピクセルの値
        //private    var intItiData:int;
        private const intKurikaesi:Number = 256;    //最大繰り返し数
        
        public function microorganism():void {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            //下の2行を加えるとHTMLで定義したサイズで表示
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align =StageAlign.TOP_LEFT;
            intBMw = stage.stageWidth;    //描画サイズ取得
            intBMh = stage.stageHeight;
            //描画エリアの作成
            bdMandelbrot = new BitmapData(intBMw, intBMh, false, 0xffffff);
            var bm:Bitmap = new Bitmap(bdMandelbrot);
            stage.addChild(bm);
            bm.x = (intBMw - stage.width) / 2;
            bm.y = (intBMh - stage.height) / 2;
            fncSerColor();    //グラデーションカラー
            //intItiData=0;
            fncDispSt();        //描画開始
        }
        //描画開始
        private function fncDispSt():void {
            iloop = 0;        //描画位置クリア
            
            //それなりの画像が出来る位置テーブルの選択
            var intItiData:int=getIntRand(0, arrItiData.length-1);
            
            numA= arrItiData[intItiData].a;
            numB= arrItiData[intItiData].b;
            bolA= arrItiData[intItiData].af;
            bolB= arrItiData[intItiData].bf;
            
            var d:Number =  arrItiData[intItiData].d;
            //ジュリア集合の1ピクセルの値
            if (intBMh > intBMw) {
                Step = d*2 / intBMh;
            } else {
                Step = d*2 / intBMw;
            }
            //ジュリア集合上の開始位置を決める
            xMin =  arrItiData[intItiData].x - Step*intBMw/2  ;// + getNumRand(0,  d);
            yMin =  arrItiData[intItiData].y - Step*intBMh/2  ;// + getNumRand(0,  d);
            //Step = getNumRand(Step / 1.3, Step*1.2 );
            //画像の切り替え時のエフェクトを指定
            iTyp = getIntRand(0, 5);
            //繰り返しイベントにジュリア集合の描画追加
            this.addEventListener(Event.ENTER_FRAME, fncMandelbroDisp);
            //intItiData++;
            //if (intItiData >= arrItiData.length) { intItiData = 0;}
        }
        //ジュリア集合の描画(1/40分描画、40回繰り返し）
        private function fncMandelbroDisp(e:*):void {
            var bolEnd:Boolean = false
            var bmItiY:int;
            var bmItiX:int;
            var a:Number;
            var b:Number;
            var xx:int;
            var yy:int;
            //描画時エフェクトする。
            switch (iTyp) {
            case 0 :
                for (bmItiY = iloop; bmItiY < intBMh; bmItiY+=40) {
                    b = yMin + bmItiY * Step;
                    for (bmItiX = 0; bmItiX < intBMw; bmItiX++) {
                        a = xMin + bmItiX * Step;
                        bdMandelbrot.setPixel(bmItiX, bmItiY, fncGetColor(a, -b));
                    }
                }
                break;
            case 1 :
                for (bmItiY = 0; bmItiY < intBMh; bmItiY++) {
                    b = yMin + bmItiY * Step;
                    for (bmItiX = iloop; bmItiX < intBMw; bmItiX+=40) {
                        a = xMin + bmItiX * Step;
                        bdMandelbrot.setPixel(bmItiX, bmItiY, fncGetColor(a, -b));
                    }
                }
                break;
            case 2 :
                for (bmItiY = iloop; bmItiY < intBMh; bmItiY+=40) {
                    for (bmItiX = 0; bmItiX < intBMw; bmItiX++) {
                        yy = bmItiY + bmItiX;
                        yy = yy % intBMh;
                        b = yMin + yy * Step;
                        a = xMin + bmItiX * Step;
                        bdMandelbrot.setPixel(bmItiX, yy, fncGetColor(a, -b));
                    }
                }
                break;
            case 3 :
                for (bmItiY = iloop; bmItiY < intBMh; bmItiY+=40) {
                    for (bmItiX = 0; bmItiX < intBMw; bmItiX++) {
                        yy = bmItiY +intBMw- bmItiX;
                        yy = yy % intBMh;
                        b = yMin + yy * Step;
                        a = xMin + bmItiX * Step;
                        bdMandelbrot.setPixel(bmItiX, yy, fncGetColor(a, -b));
                    }
                }
                break;
            case 4 :
                for (bmItiY = iloop; bmItiY < intBMh; bmItiY+=40) {
                    for (bmItiX = 0; bmItiX < intBMw; bmItiX++) {
                        yy = bmItiY;
                        if ((bmItiX % 60) < 30) { yy += 30; }
                        if (yy >= intBMh) { yy -= intBMh; }
                        b = yMin + yy * Step;
                        a = xMin + bmItiX * Step;
                        bdMandelbrot.setPixel(bmItiX, yy, fncGetColor(a, -b));
                    }
                }
                break;
            case 5 :
                for (bmItiY = 0; bmItiY < intBMh; bmItiY++) {
                    b = yMin + bmItiY * Step;
                    for (bmItiX = iloop; bmItiX < intBMw; bmItiX+=40) {
                        xx = bmItiX;
                        if ((bmItiY % 60) < 30) { xx += 30; }
                        if (xx >= intBMw) { xx -= intBMw; }
                        a = xMin + xx * Step;
                        bdMandelbrot.setPixel(xx, bmItiY, fncGetColor(a, -b));
                    }
                }
                break;
            }
            if (iloop >= 39) { bolEnd = true; }
            iloop++;            
            
            if(bolEnd == true) {
                this.removeEventListener(Event.ENTER_FRAME,fncMandelbroDisp);
                var setIDName:Number = setTimeout(fncDispSt, 3000);    //3秒後に実行
            }
        }
        //ジュリア集合の1点でのカラー
        private function fncGetColor(a:Number, b:Number):uint {
            var uiCol:uint = uintHassan;    //発散しないときのカラー
            var x:Number=a;
            var y:Number=b;
            var i:int = 0;
            for(i=0;i<=intKurikaesi;i++){    //最大繰り返し数繰り返し
                var x2:Number=x*x;
                var y2:Number=y*y;
                var zx:Number=x2-y2+numA;
                var zy:Number = 2 * x * y + numB;
                x = zx;
                y = zy;
                if (bolA == true) {
                    x = Math.abs(zx);
                }
                if (bolB == true) {
                    y = Math.abs(zy);
                }
                if (x2 + y2 >= 4) {
                    var id:int = i % arrColor.length;
                    uiCol= arrColor[id];
                    break;
                }
            }
            return uiCol;
        }
        //グラデーションカラー取得
        private function fncSerColor():void {
            var arrCl0:Array=[0,0,0];
            var arrCl1:Array=[255,255,255];
            var icflg:uint = 0;
            uintHassan = 0x000000;    //発散しない時のカラー
            
            arrColor = new Array();
            var icoln:int = 32;    
            var i:int;
            var ir:uint;
            var ig:uint;
            var ib:uint;
            for(i = 0; i < icoln; i++) {    //グラデーションカラー作成
                ir = arrCl0[0] + (arrCl1[0] - arrCl0[0]) * i / icoln;
                ig = arrCl0[1] + (arrCl1[1] - arrCl0[1]) * i / icoln;
                ib = arrCl0[2] + (arrCl1[2] - arrCl0[2]) * i / icoln;
                arrColor.push(ir * 256 * 256 + ig * 256 + ib);
            }
            for(i = 1; i < icoln-1; i++) {    //グラデーションカラー作成
                ir = arrCl0[0] + (arrCl1[0] - arrCl0[0]) * (icoln-i) / icoln;
                ig = arrCl0[1] + (arrCl1[1] - arrCl0[1]) * (icoln-i) / icoln;
                ib = arrCl0[2] + (arrCl1[2] - arrCl0[2]) * (icoln-i) / icoln;
                arrColor.push(ir * 256 * 256 + ig * 256 + ib);
            }
        }
        //乱数
        private function getIntRand(intMin:int, intMax:int):int {
                return intMin + Math.floor(Math.random() * (intMax + 1 - intMin));
        }
        private function getNumRand(numMin:Number, numMax:Number):Number {
                return numMin + Math.random() * (numMax  - numMin);
        }
    }
}