/**
 * Copyright grgrdvrt ( http://wonderfl.net/user/grgrdvrt )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8Rct
 */

package {
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.geom.Point;
    /*
    * see http://i.imgur.com/CNy9J.jpg
    */
    public class BatmanEquation extends Sprite {
        public function BatmanEquation() {
            // write as3 code here..
            var bd:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0xffffffff);
            addChild(new Bitmap(bd));
            
            
            var minX:Number = -7.5;
            var maxX:Number = 7.5;
            var minY:Number = -3.5;
            var maxY:Number = 3.5;
            
            var offset:Point = new Point( -minX, -minY);
            var scale:Number = 30;
            
            var stepX:Number = 0.01;
            var stepY:Number = stepX;
            var v:Number = batman(minX, minY);
            var isIn:Boolean = false;
            for (var j:Number = minY; j < maxY; j += stepY) 
            {
                for (var i:Number = minX; i < maxX; i += stepX) 
                {
                    var value:Number = batman(i, j);
                    if (value == 0 || v * value <= 0)
                    {
                        isIn = !isIn;
                        v = value;
                    }
                    if(isIn)bd.setPixel32(scale * (i + offset.x), scale * ( -j + offset.y), 0xff000000);    
                }
            }
        }
        
        
        private const const1:Number = 3 * Math.sqrt(33);
        private const const2:Number = 6 * Math.sqrt(10) / 7;
        
        private function batman(x:Number, y:Number):Number
        {
            var absX:Number = Math.abs(x);
            var a:Number, b:Number, c:Number, d:Number, e:Number, f:Number;
            
            if ((y + const1 / 7) <= 0) a = 1;
            else if (absX <= 3) a = -1;
            else a = Math.pow(x / 7, 2) * Math.sqrt(Math.abs(absX - 3) / (absX - 3)) + Math.pow(y / 3, 2) * Math.sqrt(Math.abs(y + const1 / 7) / (y + const1 / 7)) - 1;
            if (absX > 4) b = -1;
            else
            {
                b = Math.abs(x / 2) - ((const1 - 7) / 112) * x * x - 3 + Math.sqrt(1 - Math.pow(Math.abs(absX - 2) - 1, 2)) - y;
                if (y < -2.47) b *= -1;
            }
            c = 9 * Math.sqrt(Math.abs((absX - 1) * (absX - .75)) / ((1 - absX) * (absX - 0.75))) - 8 * absX - y;
            d = 3 * absX + .75 * Math.sqrt(Math.abs((absX - .75) * (absX - .5)) / ((.75 - absX) * (absX - .5))) - y;
            e = 2.25 * Math.sqrt(Math.abs((x - .5) * (x + .5)) / ((.5 - x) * (.5 + x))) - y;
            f = const2 + (1.5 - .5 * absX) * Math.sqrt(Math.abs(absX - 1) / (absX - 1)) - 0.5 * const2 * Math.sqrt(4 - Math.pow(absX - 1, 2)) - y;
            
            var value:Number = 1;
            if (!isNaN(a)) value *= a;
            if (!isNaN(b)) value *= b;
            if (!isNaN(c)) value *= c;
            if (!isNaN(d)) value *= d;
            if (!isNaN(e)) value *= e;
            if (!isNaN(f)) value *= f;
            
            return value;
        }
    }
}