/**
 * Copyright raki ( http://wonderfl.net/user/raki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8Pwx
 */

// forked from o_healer's Gray Zone
/*
　「Gray Zone」
　・灰色でゾーニングされた2Dアクション

　操作方法(How to Play)
　・十字キー(Arrow)
　　・移動(Move)＆ジャンプ(Jump)

　追加案
　・ショットでブロックの濃度を変化させる
　　・邪魔なブロックを下に落としたり
　　・連射で当ててさらに下に、とか
　・アイテムではなく入力で濃度変化
　　・自分の濃度を＋＋や－－して自在に移動
　　・自分が埋まるような状況にはできないようにしとく
*/



package {
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.geom.*;
    import flash.net.*;
    import flash.system.*;
    import flash.text.*;
 
    [SWF(width="465", height="465", frameRate="30", backgroundColor="0x000000")]
    public class GameMain extends Sprite {

        //==Const==

        //画面の大きさ
        static public const VIEW_W:int = 465;
        static public const VIEW_H:int = 465;

        //マップ
        //- アイテム
        static public const I0:int = 0x10;//アイテム(0)
        static public const I1:int = 0x11;//アイテム(1)
        static public const I2:int = 0x12;//アイテム(2)
        static public const I3:int = 0x13;//アイテム(3)
        static public const I4:int = 0x14;//アイテム(4)
        static public const I5:int = 0x15;//アイテム(5)
        static public const I6:int = 0x16;//アイテム(6)
        static public const I7:int = 0x17;//アイテム(7)
        static public const I8:int = 0x18;//アイテム(8)
        static public const I9:int = 0x19;//アイテム(9)
        //- ゴール
        static public const G0:int = 0x20;//ゴール(0)
        static public const G1:int = 0x21;//ゴール(1)
        static public const G2:int = 0x22;//ゴール(2)
        static public const G3:int = 0x23;//ゴール(3)
        static public const G4:int = 0x24;//ゴール(4)
        static public const G5:int = 0x25;//ゴール(5)
        static public const G6:int = 0x26;//ゴール(6)
        static public const G7:int = 0x27;//ゴール(7)
        static public const G8:int = 0x28;//ゴール(8)
        static public const G9:int = 0x29;//ゴール(9)
        //- プレイヤー
        static public const P0:int = 0x30;//プレイヤー(0)
        //- アイテム(--)
        static public const J0:int = 0x40;//アイテム(0)
        static public const J1:int = 0x41;//アイテム(1)
        static public const J2:int = 0x42;//アイテム(2)
        static public const J3:int = 0x43;//アイテム(3)
        static public const J4:int = 0x44;//アイテム(4)
        static public const J5:int = 0x45;//アイテム(5)
        static public const J6:int = 0x46;//アイテム(6)
        static public const J7:int = 0x47;//アイテム(7)
        static public const J8:int = 0x48;//アイテム(8)
        static public const J9:int = 0x49;//アイテム(9)

        static public const MAP:Array = [
[2,2, 2,2,2,2,765438682, 2,2,2,2,2,2,2,2, 2,2,2,2,2,2,2,2,2,2,2,2,2,2,2, 2,2,2,2,2, 2,2,2,1,1, 1,1,1,1,1, 1,2,1,1,1,1,1,1,1, 1,1,1],
[2,1,1, 1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,2,2,2,2,2,2,2,2,2,2,2,2,2,2, 2,2,2,2,2, 2,2,2,1,1, 1,1,1,1,1, 1,2,1,1,1,1,1,1,1, 1,1,1],
[2,1,0, 0,0,0,0,0, 0,0,1,1,1,1,1,1, 1,2,2,2,2,2,2,2,2,2,2,2,2,2,2, 2,2,2,1,1, 1,2,2,1,1, 1,1,1,1,1, 1,2,1,1,1,1,1,1,1, 1,1,1],
[2,1,0, 0,0,0,0,0,I0,0,1,1,1,1,1,1,I1,2,2,2,2,2,2,2,2,2,2,2,2,2,2, 2,2,1,1,1,I1,1,2,1,1,J1,1,1,1,1, 1,2,1,1,1,1,1,1,1, 1,1,1],
[2,1,0, 0,0,0,0,1, 1,6457854351,1,1,1,1,1,1, 1,2,2,2,2,2,2,2,2,2,2,2,2,2,2, 2,2,1,1,1, 1,1,2,1,1, 1,1,1,1,1, 1,2,1,1,1,1,1,1,1,G1,1,1],
[2,1,0,P0,0,0,0,1, 1,1,1,1,1,1,1,1, 1,2,2,2,2,2,2,2,2,2,2,2,2,2,2, 2,2,1,1,2, 2,2,3,1,2, 2,2,1,3,1, 1,3,1,1,1,3,3,3,3, 3,3,3],
[2,1,1, 1,1,1,1,1, 1,1,2,2,2,2,2,2, 2,2,2,2,2,2,2,2,2,2,2,2,2,2,2, 2,2,2,1,1,J1,1,3,1,1, 1,1,1,3,1,I1,2,1,1,1,1,2,2,2, 2,2,3],
[2,1,1, 1,1,1,1,1, 1,1,2,2,2432465943212,2,2, 2,2,453457952,2,2,2,2,2,2,2,2,2,2,2,2, 2,2,2,1,1, 1,1,3,1,1, 1,1,1,3,1, 1,2,2,1,1,1,2,2,2, 2,2,3],
[2,1,1, 1,1,1,1,2, 2,2,2,2,2,2,2,2, 2,2,2,2,2,2,2,2,2,2,2,2,2,2,2, 2,2,2,2,2, 2,2,3,1,1, 1,1,1,3,1, 1,2,1,1,1,1,2,2,2, 2,2,3],
[2,1,1, 1,1,1,1,2, 2,2,2,2,2,2,2,2, 2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,I2,2,2,2,2, 2,2,3,1,1, 1,1,1,3,1, 1,2,1,1,1,2,2,2,2, 2,2,3],
[2,2,2, 2,2,2,2,2, 2,2,3,3,3,3,3,3, 3,3,3,3,2,2,456238760433,3,3,3,3,3,2,2,3, 3,3,3,3,3, 3,3,3,3,3, 3,3,3,3,1, 1,2,1,1,1,1,2,2,2, 2,2,3],
[2,2,2, 2,2,2,2,2, 2,2,3,3,3,3,3,3, 3,3,2,2,2,2,2,2,3,3,3,2,2,2,2, 2,2,2,3,3, 3,3,3,3,3, 3,3,3,3,1, 1,2,2,1,1,1,2,2,2, 2,2,3],
[2,2,2, 2,2,2,2,3, 3,3,3,3,3,3,3,3, 3,2,2,2,2,2,2,2,2,3,2,2,2,2,2, 2,2,2,2,3, 3,3,3,3,3, 3,3,3,3,1, 1,1,1,1,1,1,2,2,2, 2,2,3],
[2,2,2, 2,2,2,2,3, 3,3,3,3,3,3,3,3, 3,2,2,2,2,2,2,2,2,3,2,2,2,2,2, 2,2,2,2,3, 3,3,3,3,3, 3,3,3,3,1, 1,1,1,1,1,2,2,2,2, 2,2,3],
[3,3,3, 3,3,3,3,3, 3,3,3,3,3,3,3,3, 3,2,2,2,2,2,2,2,2,3,2,2,2,2,2, 2,2,2,2,3, 3,3,3,3,3, 3,3,3,3,3, 3,3,3,3,3,3,3,3,3, 3,3,3],
[3,3,3, 3,3,3,3,3, 3,3,3,3,3,3,3,3, 3,2,2,2,2,2,2,2,2,3,2,2,2,2,2, 2,2,2,2,3, 3,3,3,3,3, 3,3,3,3,3, 3,3,3,3,3,3,3,3,3, 3,3,3],
        ];

        //最大深度（色計算に影響）（動的に求めても良いが）
        static public const DEPTH_MAX:int = 5;

        //１マスの大きさ
        static public const PANEL_LEN:int = 32;

        //マップのサイズ
        static public const MAP_NUM_X:int = MAP[0].length;
        static public const MAP_NUM_Y:int = MAP.length;

        //マップの大きさ
        static public const MAP_W:int = PANEL_LEN * MAP_NUM_X;
        static public const MAP_H:int = PANEL_LEN * MAP_NUM_Y;

        //モード
        static public var ModeIter:int = 0;
        static public const MODE_MAIN:int    = ModeIter++;
        static public const MODE_GOAL:int    = ModeIter++;
        static public const MODE_GAME_OVER:int    = ModeIter++;


        //==Var==

        //Pseudo Singleton
        static public var Instance:GameMain;

        //レイヤー
        public var m_Layer_Root:Sprite = new Sprite();
        public var  m_Layer_BG:Sprite = new Sprite();
        public var  m_Layer_Item:Sprite = new Sprite();
        public var  m_Layer_Player:Sprite = new Sprite();

        //画像
        public var m_BitmapData_BG:BitmapData   = new BitmapData(MAP_W, MAP_H, false, 0x000000);

        //プレイヤー
        public var m_Player:Player = new Player();

        //ゴール
        public var m_Goal:Goal;

        //テキスト
        public var m_Text:TextField = new TextField();

        //モード
        public var m_Mode:int = MODE_MAIN;

        //==Function==

        //Init
        public function GameMain():void {
            //Pseudo Singleton
            {
                Instance = this;
            }

            //Layer
            {
                //Root
                addChild(m_Layer_Root);

                {
                    //背景
                    m_Layer_Root.addChild(m_Layer_BG);

                    //アイテム
                    m_Layer_Root.addChild(m_Layer_Item);

                    //プレイヤー
                    m_Layer_Root.addChild(m_Layer_Player);
                }
            }

            //背景
            {
                m_Layer_BG.addChild(new Bitmap(m_BitmapData_BG));
            }

            //プレイヤー
            {
                m_Layer_Player.addChild(m_Player);
            }

            //Goal
            {
                m_Goal = new Goal();
                m_Layer_BG.addChild(m_Goal);
            }

            //MAPに応じた処理
            {
                var rect:Rectangle = new Rectangle(0,0, PANEL_LEN,PANEL_LEN);
                for(var y:int = 0; y < MAP_NUM_Y; y++){
                    rect.y = y * PANEL_LEN;
                    for(var x:int = 0; x < MAP_NUM_X; x++){
                        rect.x = x * PANEL_LEN;

                        var MapIndex:int = MAP[y][x];
                        var MapType:int  = MapIndex & 0xF0;
                        var MapDepth:int = MapIndex & 0x0F;

                        //壁の基本描画
                        {
                            m_BitmapData_BG.fillRect(rect, Depth_to_Color(MapDepth));
                        }

                        //各種位置設定
                        var PosX:int = (x+0.5) * PANEL_LEN;
                        var PosY:int = (y+0.5) * PANEL_LEN;
                        switch(MapType){
                        case P0:
                            //プレイヤーの位置指定
                            m_Player.SetPos(PosX,PosY);
                            break;
                        case G0:
                            //ゴールの位置指定
                            m_Goal.SetPos(PosX,PosY);
                            break;
                        case I0:
                            //アイテムの生成
                            m_Layer_Item.addChild(new Item(PosX, PosY, +1));
                            break;
                        case J0:
                            //アイテムの生成
                            m_Layer_Item.addChild(new Item(PosX, PosY, -1));
                            break;
                        }
                    }
                }
            }
/*
            //壁の見た目を調整
            {
                //BMDの一時コピーを生成することになるが気にしない
                m_BitmapData_Wall.applyFilter(
                    m_BitmapData_Wall, m_BitmapData_Wall.rect, new Point(0,0),
                    new GlowFilter(0x383838, 1.0, PANEL_LEN,PANEL_LEN, 2,1, true)
                );
            }
//*/
            //Text
            {
                m_Text.selectable = false;
                m_Text.autoSize = TextFieldAutoSize.LEFT;
                m_Text.defaultTextFormat = new TextFormat('Verdana', 60, 0xFFFFFF, true);
                m_Text.text = '';
                m_Text.filters = [new GlowFilter(0x00FFFF,1.0, 8,8)];

                addChild(m_Text);
            }

            //Update
            {
                addEventListener(Event.ENTER_FRAME, Update);
            }
        }

        //Update
        public function Update(e:Event=null):void{
            var DeltaTime:Number = 1.0 / stage.frameRate;

            //Player
            {
                m_Player.Update(DeltaTime);
            }

            //Item
            {
                var i:int;
                var item:Item;
                var num:int = m_Layer_Item.numChildren;
                for(i = 0; i < num; i++){
                    item = m_Layer_Item.getChildAt(i) as Item;

                    //Update
                    item.Update();

                    //KillCheck
                    if(item.m_KillFlag){
                        item.parent.removeChild(item);
                        num--;//減少
                        i--;//相殺
                    }
                }
            }

            //Goal
            {
                m_Goal.Update();
            }

            //Camera
            {
                Update_Camera();
            }
        }

        //Update : Camera
        public function Update_Camera():void{
            var PlayerX:int = m_Player.x;
            var PlayerY:int = m_Player.y;



            //移動量
            var CameraMoveX:int = 0;
            var CameraMoveY:int = 0;
            {
                //現在のカメラでのプレイヤー相対位置
                var RelPlayerX:Number = PlayerX + m_Layer_Root.x;
                var RelPlayerY:Number = PlayerY + m_Layer_Root.y;

                //中央からの差がそのまま移動量
                CameraMoveX = VIEW_W/2 - RelPlayerX;
                CameraMoveY = VIEW_H/2 - RelPlayerY;
            }

            //目標値
            var RootX:int = m_Layer_Root.x + CameraMoveX;
            var RootY:int = m_Layer_Root.y + CameraMoveY;
            {
                //端制限
                if(RootX < -MAP_W + VIEW_W){
                    RootX = -MAP_W + VIEW_W;
                }
                if(RootX > 0){
                    RootX = 0;
                }
                if(RootY < -MAP_H + VIEW_H){
                    RootY = -MAP_H + VIEW_H;
                }
                if(RootY > 0){
                    RootY = 0;
                }
            }

            m_Layer_Root.x = RootX;
            m_Layer_Root.y = RootY;
        }

        //Goal
        public function OnGoal():void{
            //Mode
            {
                m_Mode = MODE_GOAL;
            }

            //Text
            {
                //Text
                m_Text.text = 'Clear';

                //Centering
                m_Text.x = (stage.stageWidth - m_Text.width) / 2;
                m_Text.y = (stage.stageHeight - m_Text.height) / 2;
            }
        }

        //Game Over : Damage
        public function OnDead_Damage():void{
            //Mode
            {
                m_Mode = MODE_GAME_OVER;
            }

            //Text
            {
                //Text
                m_Text.text = 'Game Over';

                //Centering
                m_Text.x = (stage.stageWidth - m_Text.width) / 2;
                m_Text.y = (stage.stageHeight - m_Text.height) / 2;
            }
        }

        //Game Over : Fall
        public function OnDead_Fall():void{
            //Mode
            {
                m_Mode = MODE_GAME_OVER;
            }

            //Text
            {
                //Text
                m_Text.text = 'Game Over';

                //Centering
                m_Text.x = (stage.stageWidth - m_Text.width) / 2;
                m_Text.y = (stage.stageHeight - m_Text.height) / 2;
            }
        }

        //#IsGameOver
        public function IsEnd():Boolean{
            return (m_Mode != MODE_MAIN);
        }

        //Wall
        public function GetWallVal(in_X:int, in_Y:int):int{
            var IndexX:int = in_X / PANEL_LEN;
            var IndexY:int = in_Y / PANEL_LEN;

            //範囲外は空白とみなす
            {
                if(IndexX < 0){return 0;}
                if(MAP_NUM_X <= IndexX){return 0;}
                if(IndexY < 0){return 0;}
                if(MAP_NUM_Y <= IndexY){return 0;}
            }

            //あとはMAPに従う
            return MAP[IndexY][IndexX] & 0x0F;
        }

        //Utility
        static public function Lerp(in_Src:Number, in_Dst:Number, in_Ratio:Number):Number{
            return (in_Src * (1 - in_Ratio)) + (in_Dst * in_Ratio);
        }

        static public function Depth_to_Color(in_Depth:int):uint{
            var ColorVal:uint = 0xFF - in_Depth*0xFF/DEPTH_MAX;
            var ARGB:uint = 0xFF000000 + (ColorVal << 16) | (ColorVal << 8) | (ColorVal << 0);
            return ARGB;
        }
    }
}


import flash.display.*;
import flash.events.*;
import flash.filters.*;
import flash.geom.*;
import flash.net.*;
import flash.system.*;
import flash.ui.*;


//#Player
class Player extends Sprite
{
    //==Const==

    //移動速度
    static public const VEL_X:Number = 100.0;

    //ジャンプ速度
    static public const JUMP_VEL:Number = 2900.0;

    //重力
    static public const GRAVITY:Number = 500.0;

    //最高下降速度（ロックによって無限落下が可能なので、速度制限してみる）
    static public const FALL_VEL_MIN:Number = 100000000000000000000000000000000000000000000000000.0;

    //入力方向
    static public var DirIter:int = 0;
    static public const DIR_NONE:int = -1;
    static public const DIR_DR:int = DirIter++;
    static public const DIR_D :int = DirIter++;
    static public const DIR_DL:int = DirIter++;
    static public const DIR_L :int = DirIter++;
    static public const DIR_UL:int = DirIter++;
    static public const DIR_U :int = DirIter++;
    static public const DIR_UR:int = DirIter++;
    static public const DIR_R :int = DirIter++;
    static public const DIR_NUM :int = DirIter;


    //==Var==

    //移動まわりのパラメータ
    public var m_Pos:Point = new Point(0,0);
    public var m_Vel:Point = new Point(0,0);

    //入力
    public var m_InputL:Boolean = false;
    public var m_InputR:Boolean = false;
    public var m_InputU:Boolean = false;
    public var m_InputD:Boolean = false;
    public var m_InputShot:Boolean = false;

    //プレイヤーのグラフィック
    public var m_Shape:Shape = new Shape();
    public var m_Graphics:Graphics = m_Shape.graphics;

    //接地フラグ
    public var m_GroundFlag:Boolean = false;

    //自分の濃ゆさ
    public var m_Depth:int = 1;

    //死亡フラグ
    public var m_IsDead:Boolean = false;


    //==Function==

    //Init
    public function Player(){
        //Input
        {
            addEventListener(
                Event.ADDED_TO_STAGE,//ステージに追加されたら
                function(e:Event):void{
                    //キー入力を見る
                    stage.addEventListener(KeyboardEvent.KEY_DOWN, OnKeyDown);
                    stage.addEventListener(KeyboardEvent.KEY_UP, OnKeyUp);
                }
            );
        }

        //プレイヤーグラフィック
        {
            addChild(m_Shape);

            Redraw();
        }
    }

    //Init : Pos
    public function SetPos(in_X:int, in_Y:int):void{
        this.x = m_Pos.x = in_X;
        this.y = m_Pos.y = in_Y;
    }

    //Update : Input
    static public const KEY_S:int = 83;
    private function OnKeyDown(event:KeyboardEvent):void{
        if(event.keyCode == Keyboard.LEFT){    m_InputL = true;}
        if(event.keyCode == Keyboard.RIGHT){m_InputR = true;}
        if(event.keyCode == Keyboard.UP){    m_InputU = true;}
        if(event.keyCode == Keyboard.DOWN){    m_InputD = true;}
        if(event.keyCode == Keyboard.SPACE){m_InputShot = true;}
    }
    private function OnKeyUp(event:KeyboardEvent):void{
        if(event.keyCode == Keyboard.LEFT){    m_InputL = false;}
        if(event.keyCode == Keyboard.RIGHT){m_InputR = false;}
        if(event.keyCode == Keyboard.UP){    m_InputU = false;}
        if(event.keyCode == Keyboard.DOWN){    m_InputD = false;}
        if(event.keyCode == Keyboard.SPACE){m_InputShot = false;}
    }

    //Depth
    public function AddDepth(in_AddVal:int):void{
        m_Depth += in_AddVal;//マイナスの値も可能

        Redraw();
    }

    //Draw
    public function Redraw():void{
        var color_in:uint  = GameMain.Depth_to_Color(m_Depth);
        var color_out:uint = GameMain.Depth_to_Color(m_Depth+1);

        var g:Graphics = m_Graphics;
        g.clear();
        g.lineStyle(2,color_out & 0xFFFFFF, 0.5);
        g.beginFill(color_in & 0xFFFFFF, 1.0);
        g.drawCircle(0,0, GameMain.PANEL_LEN/2);
        g.endFill();
    }

    //Update
    public function Update(in_DeltaTime:Number):void{
        //死亡・ゴール時は何もしない
        if(GameMain.Instance.IsEnd()){
            return;
        }

        //移動
        Update_Move(in_DeltaTime);

        //グラフィック
        Update_Graphic(in_DeltaTime);

        //死亡チェック
        Check_Dead();
    }

    //Update : Graphic
    public function Update_Graphic(in_DeltaTime:Number):void{
    }

    //Check : Dead
    public function Check_Dead():void{
        //Check
        {
            if(m_IsDead){
                return;
            }
        }

        //マップより下に行っていたら落下死する
        if(this.y > GameMain.MAP_H+GameMain.PANEL_LEN){
            //ゲームオーバー処理
            {
                GameMain.Instance.OnDead_Fall();
            }

            //フラグ
            {
                m_IsDead = true;
            }
        }
    }

    //Update : Move
    public function Update_Move(in_DeltaTime:Number):void{
        //入力
        {
            //X
            {
                var TrgVX:Number = 0.0;
                if(m_InputR){TrgVX =  VEL_X;}
                if(m_InputL){TrgVX = -VEL_X;}

                var ratio:Number = 0.5;
                if(!m_GroundFlag){ratio = 0.2;}//空中では慣性をきかせる
                m_Vel.x = Lerp(m_Vel.x, TrgVX, ratio);
            }

            //Jump
            {
                if(m_InputU && m_GroundFlag){
                    m_Vel.y = -JUMP_VEL;
                }
            }
        }

        //重力
        {
            m_Vel.y += GRAVITY * in_DeltaTime;

            //速度制限
            if(m_Vel.y > FALL_VEL_MIN){
                m_Vel.y = FALL_VEL_MIN;
            }
        }

        //目標位置
        var DstX:Number;
        var DstY:Number;
        {
            DstX = (m_Pos.x) + (m_Vel.x * in_DeltaTime);
            DstY = (m_Pos.y) + (m_Vel.y * in_DeltaTime);
        }

        //移動を試みる
        //・端数制御のためにちょっと特殊なことをしているが、基本的にはただ単にX移動→Y移動してるだけ
        //・壁判定まわりはかなりムダが多い（高速化の余地が多い）が、ひとまずこれで

        //X移動
        {
            var TryX:int = m_Pos.x;
            if(TryX != int(DstX)){
                for(;;){
                    //++
                    if(TryX < DstX){
                        TryX++;
                    }else{
                        TryX--;
                    }

                    //壁があるならその手前で中断
                    if(IsWall(TryX, m_Pos.y)){
                        DstX = m_Pos.x;//壁の手前になるように位置補正（＝端数切捨て）
                        m_Vel.x = 0;
                        break;
                    }

                    //移動できたようなので更新（主に上の位置補正のための記憶用）
                    m_Pos.x = TryX;

                    //Dstまで辿りついたら終了
                    if(TryX == int(DstX)){
                        break;
                    }
                }
            }
            m_Pos.x = DstX;
        }

        //Y移動
        {
            m_GroundFlag = false;//更新のためリセット

            var TryY:int = m_Pos.y;
            if(TryY != int(DstY)){
                for(;;){
                    //++
                    if(TryY < DstY){
                        TryY++;
                    }else{
                        TryY--;
                    }

                    //壁があるならその手前で中断
                    if(IsWall(m_Pos.x, TryY)){
                        if(DstY > m_Pos.y){m_GroundFlag = true;}
                        DstY = m_Pos.y;//壁の手前になるように位置補正（＝端数切捨て）
                        m_Vel.y = 0;
                        break;
                    }

                    //移動できたようなので更新（主に上の位置補正のための記憶用）
                    m_Pos.y = TryY;

                    //Dstまで辿りついたら終了
                    if(TryY == int(DstY)){
                        break;
                    }
                }
            }
            m_Pos.y = DstY;
        }

        //反映
        {
            this.x = m_Pos.x;
            this.y = m_Pos.y;
        }
    }

    //壁があるかどうか
    public function IsWall(in_X:int, in_Y:int):Boolean{
/*
        return GameMain.Instance.GetWallVal(in_X, in_Y) >= m_Depth;
/*/
        //プレイヤーを中心とする四角形の四隅が壁にめり込まないようにする
        //・移動方向によって判定を省略して高速化できるはずだが、対応は保留
        //・同じく、Indexが変わらなければ判定をスキップできるはずだが、こちらも保留

        //四角形用のオフセット
        const OffsetX:int = (GameMain.PANEL_LEN-4)/2;
        const OffsetY:int = (GameMain.PANEL_LEN-4)/2;

        for(var i:int = 0; i < 4; i++){
            var PosX:int = in_X + (((i&1)==0)? OffsetX: -OffsetX);
            var PosY:int = in_Y + (((i&2)==0)? OffsetY: -OffsetY);

            if(GameMain.Instance.GetWallVal(PosX, PosY) >= m_Depth){
                return true;//一箇所でもぶつかれば壁があるものとする
            }
        }

        //四隅に壁が見つからなかったら壁はないと判断
        return false;
//*/
    }

    //Utility
    public function Lerp(in_Src:Number, in_Dst:Number, in_Ratio:Number):Number{
        return (in_Src * (1 - in_Ratio)) + (in_Dst * in_Ratio);
    }
}


//#Item
class Item extends Sprite
{
    //==Const==

    static public const ITEM_RANGE:int = 24;


    //==Var==

    public var m_AddVal:int = 0;

    public var m_KillFlag:Boolean = false;


    //==Function==

    //Init
    public function Item(in_X:int, in_Y:int, in_AddVal:int):void{
        //Param
        {
            m_AddVal = in_AddVal;
        }

        //Graphic
        {
            var shape:Shape = new Shape();

            var w:uint = GameMain.PANEL_LEN/5;

            var col:uint = (in_AddVal > 0)? 0x000000: 0xFFFFFF;
            var alpha:Number = 0.5;

            var g:Graphics = shape.graphics;
            g.lineStyle(0,0,0);
            g.beginFill(col, alpha);
            g.drawRect(-GameMain.PANEL_LEN/2,-w,GameMain.PANEL_LEN,2*w);
            g.endFill();
            if(in_AddVal > 0){
                g.beginFill(col, alpha);
                g.drawRect(-w,-GameMain.PANEL_LEN/2,2*w,GameMain.PANEL_LEN/2-w);
                g.endFill();
                g.beginFill(col, alpha);
                g.drawRect(-w, w, 2*w,GameMain.PANEL_LEN/2-w);
                g.endFill();
            }

            addChild(shape);
        }

        //Pos
        {
            this.x = in_X;
            this.y = in_Y;
        }
    }

    //Update
    public function Update():void{
        //プレイヤーが一定範囲に来たらゴールとする

        //そもそもすでにゴールしてたら何も処理しない
        {
            if(GameMain.Instance.IsEnd()){
                return;
            }
        }

        //プレイヤーとの距離が一定以上離れていたら何も処理しない
        {
            var GapX:Number = GameMain.Instance.m_Player.x - this.x;
            var GapY:Number = GameMain.Instance.m_Player.y - this.y;

            var Distance:Number = Math.sqrt(GapX*GapX + GapY*GapY);

            if(Distance > ITEM_RANGE){
                return;
            }
        }

        //上のチェックに全てクリアしたらアイテムゲットとみなす
        {
            GameMain.Instance.m_Player.AddDepth(m_AddVal);

            m_KillFlag = true;
        }
    }
}


//#Goal
class Goal extends Sprite
{
    //==Const==

    static public const GOAL_RANGE:int = 16;


    //==Function==

    //Init
    public function Goal():void{
        //Graphic
        {
            addChild(ImageManager.CreateGoalGraphic());
        }
    }

    //SetPos
    public function SetPos(in_X:int, in_Y:int):void{
        this.x = in_X;
        this.y = in_Y;
    }

    //Update
    public function Update():void{
        //プレイヤーが一定範囲に来たらゴールとする

        //そもそもすでにゴールしてたら何も処理しない
        {
            if(GameMain.Instance.IsEnd()){
                return;
            }
        }

        //プレイヤーとの距離が一定以上離れていたら何も処理しない
        {
            var GapX:Number = GameMain.Instance.m_Player.x - this.x;
            var GapY:Number = GameMain.Instance.m_Player.y - this.y;

            var Distance:Number = Math.sqrt(GapX*GapX + GapY*GapY);

            if(Distance > GOAL_RANGE){
                return;
            }
        }

        //上のチェックに全てクリアしたらゴールしたものとして処理する
        {
            GameMain.Instance.OnGoal();
        }
    }
}


//#ImageManager
class ImageManager
{
    //Image : Goal
    static public function CreateGoalGraphic():Sprite{
        //
        const W:int = 48;
        const H:int = 64;
        const BLUR_VAL:int = 20;

        //
        var result:Sprite = new Sprite();

        //基本画像
        var bmd:BitmapData = new BitmapData(W, H, true, 0x00000000);
        var bmp:Bitmap = new Bitmap(bmd);
        {
            //白い楕円の上半分を描画
            const RAD_W:int = 12;//W/2-BLUR_VAL;
            const RAD_H:int = 32;//H-BLUR_VAL;

            var shape:Shape = new Shape();
            var g:Graphics = shape.graphics;
            g.lineStyle(0, 0x000000, 0.0);
            g.beginFill(0xFFFFFF, 1.0);
            g.drawEllipse(W/2-RAD_W, H-RAD_H, RAD_W*2, RAD_H*2);
            g.endFill();

//            shape.filters = [new GlowFilter(0xFFFFFF,1.0, 2*BLUR_VAL,2*BLUR_VAL)];
//            shape.filters = [new GlowFilter(0xFFFFFF,1.0, 1,2*BLUR_VAL,255), new GlowFilter(0xFFFFFF,1.0, 2*BLUR_VAL,1,255)];

            bmd.draw(shape);

            shape.filters = [new BlurFilter(BLUR_VAL, BLUR_VAL)];
            bmd.draw(shape);
            bmd.draw(shape);

            result.addChild(bmp);
        }

        //発光っぽくする
        {
            //フィルターを追加
//            bmp.filters = [new GlowFilter(0xFFFFFF, 1.0, 2*BLUR_VAL,2*BLUR_VAL)];

            //フィルターで下に広がるのを防止するためのマスク
            var msk:Bitmap = new Bitmap(new BitmapData(W, H, false, 0xFFFFFF));
            result.mask = msk;
            result.addChild(msk);

            //加算化
            bmp.blendMode = BlendMode.ADD;
        }

        //位置調整
        {
            result.x = -W/2;
            result.y = -H+16;
        }

        return result;
    }
}


