/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * GNU General Public License, v3 ( http://www.gnu.org/licenses/quick-guide-gplv3.html )
 * Downloaded from: http://wonderfl.net/c/8PdO
 */

package 
{
    import flash.display.Sprite;
    import flash.display.Graphics;
    import flash.events.TimerEvent;
    import flash.events.MouseEvent;
    import flash.utils.Timer;
    import flash.geom.Point;
 
    public class FlashTest extends Sprite 
    {        
        private var g:Graphics;
        private var timer:Timer;
        private var f:Fiber;        
        private var mx:Number;
        private var my:Number;

        
        public function FlashTest() 
        {            
            g   =  this.graphics;            
            f   =  new Fiber( 100,40 );    //( 200,10 );            
            mx  =  stage.stageWidth * .5; 
            my  =  stage.stageHeight * .5;
            
            timer = new Timer(20);
            timer.addEventListener(TimerEvent.TIMER, te);
            timer.start();
            
            stage.addEventListener(MouseEvent.MOUSE_MOVE, me);
        }
        
        
        private function me( e:MouseEvent ):void
        {
            mx = e.stageX;
            my = e.stageY;
            
            f.x = mx;
            f.y = my;
        }
        
        
        private function te(e:TimerEvent):void
        {
            g.clear();
            
            f.applyForce(new Point(0, 2));
            f.calibrate();
            
            g.lineStyle(10, 0x838383);
            g.moveTo(f.x, f.y);
            for each(var p:Point in f.pointListWithoutZero){
                g.lineTo(p.x, p.y);
            }
        }
    }
}



import flash.geom.Point;    
class Fiber 
    {
        private const C:Number = 1;
        
        private var p:Vector.<Point>;
        private var v:Vector.<Point>;
        private var len:Number;
        
        /**
        * ファイバ
        * @param    length    ファイバの長さ
        * @param    segment    区分点の数
        */
        public function Fiber(length:Number, segment:int=8):void 
        {
            super();
            
            p = new Vector.<Point>();
            v = new Vector.<Point>();
            len = length/segment;
            
            for (var i:int = 0; i <= segment; i++) 
            {
                p.push(new Point(0, len * i));
                v.push(new Point());
            }
        }
        
        /**
        * 力(Vector)をあわせる。
        * @param    force    vector
        */
        public function applyForce(force:Point):void
        {
            for (var i:int = 1; i < v.length; i++) 
            {
                v[i] = v[i].add(force);
                p[i] = p[i].add(v[i]);
            }
        }
        
        /**
        * ファイバを調整する。
        * @param    step    step
        */
        public function calibrate(step:int=20):void
        {
            var i:int, j:int;
            for (j = 0; j < step; j++)
            {
                for (i = 1; i < p.length; i++) 
                {
                    var p1:Point = p[i - 1];
                    var p2:Point = p[i];
                    
                    var del:Point = p2.subtract(p1);
                    var err:Number = del.length - len;
                    
                    if (i != 1)
                    {
                        //del.normalize(err * c / 2);
                        del.normalize(err * C * .5);
                        p[i] = p2.subtract(del);
                        p[i - 1] = p1.add(del);
                        
                        v[i] = v[i].subtract(del);
                        v[i-1] = v[i-1].add(del);
                    }
                    else
                    {
                        del.normalize(err * C);
                        p[i] = p2.subtract(del);
                        v[i] = v[i].subtract(del);
                    }
                }
            }
        }
        
        /**
        * getPoint
        */
        public function get pointList():Vector.<Point>
        {
            return p;
        }
        /**
        * getPoint
        */
        public function get pointListWithoutZero():Vector.<Point>
        {
            return p.slice(1);
        }
        
        public function get x():Number { return p[0].x }
        public function get y():Number { return p[0].y }
        public function set x(value:Number):void { p[0].x=value }
        public function set y(value:Number):void { p[0].y=value }
    }