/**
 * Copyright yonatan ( http://wonderfl.net/user/yonatan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8PYS
 */

// forked from bradsedito's Realistic Water / Sea / Ocean

package {
    import flash.geom.*;
    import flash.display.*;
    import flash.utils.*;
    import net.hires.debug.Stats;
    import com.bit101.components.*;
    
    [SWF(backgroundColor="0xFFFFFF", frameRate="100")]
    
    public class Cloud extends Sprite {
        private var arr:Array = [ new Point(0,0), new Point(0,0), new Point(0,0)]
        private var sea:BitmapData = new BitmapData( 465,265,true );

        private var o1:BitmapData = new BitmapData( 465,265,true,0 );
        private var o2:BitmapData = new BitmapData( 465,265,true,0 );
        private var o3:BitmapData = new BitmapData( 465,265,true,0 );
        private var octaves:Array;
        private var fake:CheckBox;
        
        function Cloud() {
            addChild( new Bitmap(sea) ).y = 200;
            addEventListener( "enterFrame", onFrame);

            o1.perlinNoise(256, 64,1,0,true,false,8,false);
            o2.perlinNoise(128, 32,1,1,true,false,8,false);
            o3.perlinNoise(64,  16,1,2,true,false,8,false);
            octaves = [o1, o2, o3];
            for(var i:int = 0; i < octaves.length; i++) 
                octaves[i].colorTransform(octaves[i].rect, new ColorTransform(1/Math.pow(2,i), 1/Math.pow(2,i), 1/Math.pow(2,i), 1/Math.pow(2,i)));

            stage.addChild(new Stats);
            fake = new CheckBox(stage, 100, 50, "Use fake perlinNoise");
            fake.scaleX = fake.scaleY = 2;
            fake.selected = true;
        }
        
        private var blend:String = "add";
        private function add(dst:BitmapData, src:BitmapData, offsetX:int):void {
            offsetX %= dst.width;
            var mtx:Matrix = new Matrix;
            mtx.tx = offsetX;
            dst.draw(src, mtx, null, blend);
            mtx.tx = offsetX - dst.width;
            dst.draw(src, mtx, null, blend);
        }
        
        private function onFrame(e:*):void{
            sea.fillRect(sea.rect, 0x00000000);
            for(var i:int=0;i<3;i++) {
                arr[i].x = -0.1*(1+i)*getTimer();
                if(fake.selected) add(sea, octaves[i], -arr[i].x);//*(1+i)/3);
            }
                
            if(!fake.selected) sea.perlinNoise(256,64,3,0,true,false,8,false,arr);
        }
    }
}