/**
 * Copyright s8t1h12akj ( http://wonderfl.net/user/s8t1h12akj )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8OEw
 */

// forked from nondelion's forked from: Snow
// forked from Saqoosha's Snow
package {
    
        /*
         * 練習
         */
    
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.geom.Point;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.text.TextFieldAutoSize;
    import flash.utils.Dictionary;

    [SWF(width=465, height=465, backgroundColor=0x0, frameRate=120)]

    public class TextTransition extends Sprite
    {
        private var bd:BitmapData;
        private var canvas:BitmapData;
        private var particles:Dictionary;
        private var bdp:Point;
        
        public function TextTransition()
        {
            canvas = new BitmapData(465, 465, false, 0x0);
            addChild( new Bitmap( canvas ) );
            
            var tf:TextField = new TextField();
            tf.defaultTextFormat = new TextFormat('Helvetica', 48, 0xffffff, true);
            tf.autoSize = TextFieldAutoSize.LEFT;
            tf.text = 'ネズミ経：Akijii';
            
            bd = new BitmapData(tf.width, tf.height, false, 0x0);
            bd.draw(tf);
            bdp = new Point( Math.floor( (465 - tf.width) / 2 ), Math.floor( (465 - tf.height) / 2 ) );
            
            particles = new Dictionary();
            
            for (var i:int=0; i < tf.width; i++) {
                for (var j:int=0; j < tf.height; j++) {
                    var color:uint = bd.getPixel(i, j);
                    if ( color != 0x0 ) {
                        var p:Particle = new Particle();
                        p.x = i + bdp.x;
                        p.y = j + bdp.y;
                        p.cx = Math.random() * 465;
                        p.cy = Math.random() * 465;
                        p.vx = 16;
                        p.vy = 20;
                        p.color = color;
                        particles[p] = true;
                    }
                }
            }
            
            addEventListener( Event.ENTER_FRAME, update );
            stage.addEventListener( MouseEvent.CLICK, clickHandler );
        }
        
        private function clickHandler(e:MouseEvent):void
        {
            canvas.lock();
            canvas.fillRect(canvas.rect, 0x0);
            for (var key:* in particles) {
                var p:Particle = Particle(key);
                p.cx = Math.random() * 465;
                p.cy = Math.random() * 465;
                canvas.setPixel(p.cx, p.cy, p.color);
            }
            canvas.unlock();
        }
        
        private function update(e:Event):void
        {
            canvas.lock();
            canvas.fillRect(canvas.rect, 0x0);
            
            for (var key:* in particles) {
                var p:Particle = Particle(key);
                p.cx += (p.x - p.cx )/p.vx;
                p.cy += (p.y - p.cy )/p.vy;
                if ( Math.abs( p.cx - p.x ) <= 1 && Math.abs( p.cy - p.y) <= 1) {
                    p.cx = p.x;
                    p.cy = p.y;
                    //delete particles[p];
                }
                canvas.setPixel(p.cx, p.cy, p.color);
            }
            canvas.unlock();
        }    
    }
}

        class Particle
    {
        public var color:int;
        public var x:Number;
        public var y:Number;
        public var cx:Number;
        public var cy:Number;
        public var vx:Number;
        public var vy:Number;
        
        public function Particle()
        {
            color = 0xffffff;
            x = 0;
            y = 0;
            cx = 0;
            cy = 0;
            vx = 0;
            vy = 0;
        }
    }
