/**
 * Copyright zahir ( http://wonderfl.net/user/zahir )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8N11
 */

package
{
    import flash.display.Graphics;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Matrix3D;
    import flash.geom.Utils3D;
    import flash.geom.Vector3D;
    import flash.text.TextField;
    
    import net.hires.debug.Stats;
    
    public class Triangles_tes3 extends Sprite
    {
        private const v:Vector.<Vector.<Number>> = new <Vector.<Number>>[
            new <Number>[-10.0000, 10.0000, 10.0000],
            new <Number>[-10.0000, -10.0000, 10.0000],
            new <Number>[10.0000, 10.0000, 10.0000],
            new <Number>[10.0000, -10.0000, 10.0000],
            
            new <Number>[10.0000, 10.0000, -10.0000],
            new <Number>[10.0000, -10.0000, -10.0000],
            new <Number>[-10.0000, 10.0000, -10.0000],
            new <Number>[-10.0000, -10.0000, -10.0000]
        ];
        
        private var cube:Vector.<Number>;
        
        private var vertices:Vector.<Number>;
        private var uvts:Vector.<Number>;
        
        private var pv:Vector.<Number>;
        private var transVertex:Vector.<Number>;
        
        private var t:TextField;
        private var g:Graphics;
        private var rot:Number = 0;
        
        public function Triangles_tes3()
        {
            super();
            var s:Shape = addChild( new Shape() ) as Shape;
            s.x = s.y = 465>>1;
            g = s.graphics;
            
            addChild( (t = new TextField()) );
            t.width = 100;
            t.x = stage.stageWidth - t.width;
            
            addChild( new Stats() );
            
            // init
            
            cube = createCube();
            
            vertices = new <Number>[];
            uvts = new <Number>[];
            
            
            // creation vertices
            var cl:int = 15; // 10 -> 6000poly 15 -> 20250poly
            var margin:int = 20;
            var m:Matrix3D = new Matrix3D();
            for( var i:int = 0; i<cl; i++)
            {
                for( var j:int = 0; j<cl; j++)
                {
                    for( var k:int = 0; k<cl; k++)
                    {
                        m.identity();
                        m.appendScale( 0.5, 0.5, 0.5);
                        m.appendTranslation( k * margin, j * margin, i * margin);
                        appendCube( m );
                    }
                }
            }
            
            
            
            t.appendText( "poly :: " +  vertices.length/18);
            
            pv = new Vector.<Number>( vertices.length, true );
            
            addEventListener(Event.ENTER_FRAME, function(e:Event):void{ render(); });
            
            render();
        }
        
        private function render():void
        {
            var m:Matrix3D = new Matrix3D();
            
            m.appendRotation( rot, Vector3D.X_AXIS );
            m.appendRotation( rot++, Vector3D.Y_AXIS );
            Utils3D.projectVectors( m, vertices, pv, uvts);
            
            g.clear();
            
            g.beginFill( 0x00cc00, 1);
            g.drawTriangles( pv , null, null, "negative");
            g.endFill();
        }
        
        public function appendCube( matrix:Matrix3D ):void
        {
            if(!transVertex) transVertex = new Vector.<Number>( cube.length );
            matrix.transformVectors( cube, transVertex );
            vertices = vertices.concat( transVertex );
        }
        
        public function createCube():Vector.<Number>
        {
            if(cube) return cube;
            var vertices:Vector.<Number> = new <Number>[];
            vertices = vertices.concat( v[2], v[3], v[1] );
            vertices = vertices.concat( v[2], v[1], v[0] );
            
            vertices = vertices.concat( v[4], v[5], v[3] );
            vertices = vertices.concat( v[4], v[3], v[2] );
            
            vertices = vertices.concat( v[6], v[7], v[5] );
            vertices = vertices.concat( v[6], v[5], v[4] );
            
            vertices = vertices.concat( v[0], v[1], v[7] );
            vertices = vertices.concat( v[0], v[7], v[6] );
            
            vertices = vertices.concat( v[4], v[2], v[0] );
            vertices = vertices.concat( v[4], v[0], v[6] );
            
            vertices = vertices.concat( v[3], v[5], v[7] );
            vertices = vertices.concat( v[3], v[7], v[1] );
            return vertices;
        }
    }
}