/**
 * Copyright bkzen ( http://wonderfl.net/user/bkzen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8N0b
 */

package  
{
    import flash.display.Graphics;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    
    /**
     * Cubic Interpolation
     * キュービック補完のテスト
     * @author jc at bk-zen.com
     */
    [SWF (backgroundColor = "0xFFFFFF", frameRate = "30", width = "465", height = "465")]
    public class Test108 extends Sprite 
    {
        private const partitions: uint = 30;
        private var graph: Sprite;
        private var points: Array;
        private var nowPoint: int;
        private var counter: int;
        
        public function Test108() 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e: Event = null): void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            //
            
            var w: int = stage.stageWidth  - 100;
            var h: int = stage.stageHeight - 100;
            addChild(graph = new Sprite());
            graph.x = stage.stageWidth - w;
            graph.y = h;
            var g: Graphics = graph.graphics;
            g.lineStyle(0, 0);
            g.moveTo( 0, -h);
            g.lineTo( 0,  h);
            g.moveTo(-w,  0);
            g.lineTo( w,  0);
            
            points = [];
            var i: int, n: int = 10;
            for (i = 0; i < n; i++) 
            {
                points[i] = graph.addChild(createPoint(Math.random(), w, h / 3, i / n, w >> 2));
            }
            g.lineStyle(1, 0x333333);
            g.moveTo(points[nowPoint].x, points[nowPoint].y);
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function loop(e: Event): void 
        {
            var n: int = points.length;
            var t: int = n - 1;
            if (counter < partitions)
            {
                var g: Graphics = graph.graphics;
                var p0: Shape = points[nowPoint - 1 >= 0 ? nowPoint - 1 : 0];
                var p1: Shape = points[nowPoint                            ];
                var p2: Shape = points[nowPoint + 1 <  n ? nowPoint + 1 : t];
                var p3: Shape = points[nowPoint + 2 <  n ? nowPoint + 2 : t];
                var tx: Number = counter / partitions;
                g.lineTo(p1.x + (p2.x - p1.x) * tx, cubic( p0.y, p1.y, p2.y, p3.y, tx));
                counter++;
            }
            else 
            {
                if (++nowPoint == t)
                    removeEventListener(Event.ENTER_FRAME, loop);
                else
                    counter = 0;
            }
            
        }
        
        private function createPoint(random: Number, w: int, h: int, n: Number, dy: Number = 0): Shape
        {
            var p: Shape = new Shape();
            p.graphics.beginFill(0xFF0000);
            p.graphics.drawCircle(0, 0, 5);
            p.x = w * n;
            p.y = - h * random - dy;
            return p;
        }
        
        private function cubic(v0: Number, v1: Number, v2: Number, v3: Number, x: Number): Number
        {
            var p: Number = (v3 - v2) - (v0 - v1);
            var q: Number = (v0 - v1) - p;
            var r: Number = v2 - v0;
            var s: Number = v1;
            return p * x * x * x + q * x * x + r * x + s;
        }
    }
}
