/**
 * Copyright deform ( http://wonderfl.net/user/deform )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8M4P
 */

// Click stage to reset

package {
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.utils.ByteArray;
    import flash.events.Event;
    import flash.display.Bitmap;
    import flash.display.BitmapDataChannel;
    import flash.geom.Point;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.filters.DisplacementMapFilter;
    import flash.events.MouseEvent;
    public class FlashTest extends Sprite {
    		private static var WIDTH:Number = 465;
    		private static var HEIGHT:Number = 465;
    		private var canvas:BitmapData;
    		private var effect:BitmapData;
    		private var noise:BitmapData;
    		private var particles:Array;
    		private var points:Array;
    		private var cTrs:ColorTransform;
    	
        public function FlashTest() {
            // write as3 code here..
     		var tfmt:TextFormat, tf:TextField, fxBmp:Bitmap, colors:Array, ba:ByteArray;
     		tfmt = new TextFormat();
     		tfmt.color = 0xff0000;
     		tfmt.size = 60;
     		tf = new TextField();
     		tf.defaultTextFormat = tfmt;
     		tf.wordWrap = true;
     		tf.width = WIDTH;
     		tf.height = HEIGHT;
     		tf.mouseEnabled = false;
     		tf.text="Lorem ipsum dolor sit amet,consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.";
     		addChild(tf);
     		
     		particles = [];
     		colors = [];
     		points = [];
     		
     		cTrs = new ColorTransform(1, 1, 1, 0.999999);
     		
     		noise = new BitmapData(WIDTH, HEIGHT);
     		noise.perlinNoise(2, 5, 1, 1, true, true, 5);
     		
     		canvas = new BitmapData(WIDTH, HEIGHT, true, 0x00ffffff);
     		effect = new BitmapData(canvas.width, canvas.height);
     		fxBmp = new Bitmap(effect);
     		fxBmp.blendMode = "multiply";
     		canvas.lock();
     		canvas.draw(tf);
     		for(var i:int=0; i<canvas.width/3; i++)
     		{
     			for(var j:int=0; j<canvas.height/3; j++)
     			{
		     		colors.push(canvas.getPixel32(i*3, j*3));
		     		points.push(new Point(i*3, j*3));
     				particles.push(new Particle());
     			}
     		}
     		for(i=0; i<particles.length; i++)
     		{
     			particles[i].x = points[i].x;
     			particles[i].y = points[i].y;
     			particles[i].vx = Math.random()*4;
     			particles[i].vy = Math.random()*1;
     			particles[i].color = colors[i];
     		}
     		canvas.unlock();
     		addChild(new Bitmap(canvas)) as Bitmap;
     		addChild(fxBmp);
     		
     		addEventListener(Event.ENTER_FRAME, _onUpdate);
     		stage.addEventListener(MouseEvent.MOUSE_UP, _onClicked);
        }
        
        private function _onClicked(e:MouseEvent):void
        {
     		for(var i:int=0; i<particles.length; i++)
     		{
     			particles[i].x = points[i].x;
     			particles[i].y = points[i].y;
     			particles[i].vx = Math.random()*4;
     			particles[i].vy = Math.random()*2;
     		}
        }
        
        private function _onUpdate(e:Event):void
        {
     		canvas.lock();
     		canvas.copyPixels(canvas, canvas.rect, new Point(0,0));
        		for(var i:int=0; i<particles.length; i++)
        		{
        			// particles[i].x += particles[i].vx;
        			particles[i].vy++;
        			if(particles[i].vy > 50) particles[i].vy = 50;
        			particles[i].y += particles[i].vy/30;
        			canvas.setPixel32(particles[i].x, particles[i].y, particles[i].color);
        		}
     		canvas.applyFilter(canvas,
     			canvas.rect,
     			new Point(0,0),
     			new DisplacementMapFilter(noise, new Point(0,0), 1, 1, 5, 5)
     		);
     		canvas.unlock();
     		effect.lock();
     		effect.draw(canvas);
     		effect.colorTransform(effect.rect, cTrs);
     		effect.applyFilter(effect, effect.rect, new Point(0,0), new BlurFilter(2,2));
     		effect.applyFilter(effect,
     			effect.rect,
     			new Point(0,0),
     			new DisplacementMapFilter(noise, new Point(0,0), 1, 1, 3, 3)
     		);
     		effect.unlock();
        }
    }
}

class Particle {
	public var color:uint=0;
	public var x:int;
	public var y:int;
	public var vx:int;
	public var vy:int;
}