/**
 * Copyright ser1zw ( http://wonderfl.net/user/ser1zw )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8L53
 */

/*
どう書く？org 文字列で＋を表示する(http://ja.doukaku.org/291/)
テキストフィールドに文字を入力してstartを押すと、
その文字列で＋を表示します
*/
package {
  import flash.display.Sprite;
  import flash.text.TextField;
  import flash.text.TextFieldType;
  import flash.text.TextFieldAutoSize;
  import flash.events.MouseEvent;
  import org.libspark.betweenas3.BetweenAS3;
  import org.libspark.betweenas3.tweens.ITween;
  import org.libspark.betweenas3.easing.Cubic;
  import org.libspark.betweenas3.events.TweenEvent;

  [SWF(backgroundColor="#ffffff")]
  public class Doukaku291 extends Sprite {
    private var inputArea:TextField;
    private var button:TextField;
    private var chars:Vector.<TextField>;

    private const DIRECTIONS:Array = [
      { x : 1, y : 0 },
      { x : 0, y : 1 },
      { x : 1, y : 0 },
      { x : 0, y : 1 },
      { x : -1, y : 0 },
      { x : 0, y : 1 },
      { x : -1, y : 0 },
      { x : 0, y : -1 },
      { x : -1, y : 0 },
      { x : 0, y : -1 },
      { x : 1, y : 0 },
      { x : 0, y : -1 }
    ];

    public function Doukaku291() {
      inputArea = new TextField();
      inputArea.border = true;
      inputArea.multiline = false;
      inputArea.type = TextFieldType.INPUT;
      inputArea.width = 150;
      inputArea.height = inputArea.textHeight + 5;
      inputArea.x = 20;
      inputArea.y = 10;
      stage.addChild(inputArea);
      
      button = new TextField();
      button.text = "start";
      button.border = true;
      button.background = true;
      button.backgroundColor = 0xffccaa;
      button.autoSize = TextFieldAutoSize.CENTER;
      button.height = inputArea.textHeight + 5;
      button.x = inputArea.x + inputArea.width + 10;
      button.y = inputArea.y;
      stage.addChild(button);

      chars = new Vector.<TextField>();
      button.addEventListener(MouseEvent.CLICK, function(e:MouseEvent):void {
          drawString(inputArea.text,
            stage.stageWidth / 2, inputArea.y + inputArea.height + 10);
        });
    }

    private function drawString(str:String, posX:int, posY:int):void {
      var i:int, c:String;
      var tmp:TextField;
      var strArray:Array = str.split("");
      var tween:ITween;
      var tweens:Array = new Array();

      for (i = 0; i < chars.length; i++) {
        stage.removeChild(chars[i]);
      }
      chars = new Vector.<TextField>();

      for (i = 0; i < 12; i++) {
        for each (c in strArray) {
          tmp = new TextField();
          tmp.text = c;
          tmp.height = tmp.textHeight;
          tmp.width = tmp.textWidth;
          tmp.autoSize = TextFieldAutoSize.CENTER;
          chars.push(tmp);
        }
      }

      chars[0].x = posX;
      chars[0].y = posY;
      stage.addChild(chars[0]);
      for (i = 1; i < chars.length; i++) {
        chars[i].visible = false;
        stage.addChild(chars[i]);
        chars[i].x = chars[i - 1].x + chars[i - 1].width * DIRECTIONS[int((i - 1) / strArray.length)].x;
        chars[i].y = chars[i - 1].y + chars[i - 1].height * DIRECTIONS[int((i - 1) / strArray.length)].y;

        tween = BetweenAS3.tween(chars[i],
          { x : chars[i].x, y : chars[i].y },
          { x : chars[i - 1].x, y : chars[i - 1].y },
          0.1, Cubic.easeOut);

        tween.addEventListener(TweenEvent.UPDATE, function(e:TweenEvent):void {
            e.target.target.visible = true
          });
        tweens.push(tween);
      }

      BetweenAS3.serialTweens(tweens).play();
    }
  }
}

