/**
 * Copyright ladeng6666 ( http://wonderfl.net/user/ladeng6666 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8KyXn
 */

package
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import nape.geom.Vec2;
    import nape.phys.Body;
    import nape.phys.BodyType;
    import nape.shape.Polygon;
    import nape.space.Space;
    import nape.util.ShapeDebug;    

    [SWF(frameRate="60", width=550, height=400, backgroundColor="0xCCCCCC")]

    public class T1_CreateBox extends Sprite

    {

        private var space:Space;

        private var debug:ShapeDebug;

        

        public function T1_CreateBox()

        {

            //1.create the space world

            var gravity:Vec2=new Vec2(0,500);

            space=new Space(gravity);

            

            //2.create debugshape

            debug=new ShapeDebug(550,400,0x0000ff);

            addChild(debug.display);

            

            //3.create bodybox

            createWrapWall();

            createBox(100, 100, 30, 30, BodyType.DYNAMIC);

            //4.add event listeners

            addEventListener(Event.ENTER_FRAME,loop);

            stage.addEventListener(MouseEvent.CLICK,mouseEventHanlder);

        }

        

        protected function mouseEventHanlder(event:MouseEvent):void

        {

            createBox(mouseX, mouseY, 30, 30, BodyType.DYNAMIC);

        }

        private function createWrapWall():void

        {

            createBox(stage.stageWidth/2, 0, stage.stageWidth, 10, BodyType.STATIC);

            createBox(stage.stageWidth/2, stage.stageHeight, stage.stageWidth, 10, BodyType.STATIC);

            createBox(0, stage.stageHeight/2, 10, stage.stageHeight, BodyType.STATIC);

            createBox(stage.stageWidth, stage.stageHeight/2, 10,stage.stageWidth, BodyType.STATIC);

        }

        private function createBox(posX:Number,posY:Number,width:Number,height:Number,type:BodyType):Body{

            var box:Body=new Body(type,new Vec2(posX,posY));

            var shape:Polygon= new Polygon(Polygon.box(width,height));

            box.shapes.push(shape);

            box.space=space;

            

            return box;

        }

        private function loop(event:Event):void

        {

            space.step(1/60);

            debug.clear();

            debug.draw(space);

            debug.flush();

        }

    }

}