/**
 * Copyright yanbaka ( http://wonderfl.net/user/yanbaka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8K27
 */

package
{
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.events.TimerEvent;
	import flash.geom.ColorTransform;
	import flash.utils.Timer;
	
	public class NumberSearch extends Sprite
	{
		private static const T_COLOR:uint = 0x57390F;
		private static const O_COLOR:uint = 0xFF390F;
		private static const MAX:Number = 25;
		private static const LIMIT:Number = 30;
		private static const BAR_WIDTH:Number = 196;
		private var _mainArea:Sprite;
		private var _cover:Sprite;
		private var _gameOver:TT;
		private var _numbers:Array = [];
		private var _boxs:Array = [];
		private var _n:TT;
		private var _p:TT;
		private var _progress:Sprite;
		private var _hit:int;
		private var _cnt:int;
		private var _timer:Timer;
		private var _isPlay:Boolean;
		
		public function NumberSearch()
		{
			_main();
			_numbering();
			_button();
			_next();
			_time();
			_gameOver = new TT(60, O_COLOR);
			_gameOver.visible = false;
			addChild(_gameOver);
			
			_timer = new Timer(1000);
		}
		
		private function _reset():void
		{
			_stop();
			_numbering();
			_progress.width = BAR_WIDTH;
			var trans:ColorTransform = new ColorTransform();
			trans.color = T_COLOR;
			_progress.transform.colorTransform = trans;
			_cnt = 0;
			_hit = 0;
			_gameOver.visible = false;
			_n.text = String(_cnt);
		}
		
		private function _clear():void
		{
			_reset();
			_p.text = "start";
			_gameOver.visible = true;
			_cover.visible = true;
			_isPlay = false;
		}
		
		private function _start():void
		{
			_timer.addEventListener(TimerEvent.TIMER, _onTimer);
			_timer.start();
		}
		
		private function _stop():void
		{
			_timer.reset();
			_timer.removeEventListener(TimerEvent.TIMER, _onTimer);
		}
		
		private function _onTimer(e:TimerEvent):void
		{
			_cnt++;
			var p:Number = _cnt/LIMIT;
			_progress.width = BAR_WIDTH - p*BAR_WIDTH;
			var c:uint;
			c = (p >= 0.8) ? O_COLOR : T_COLOR;
			var trans:ColorTransform = new ColorTransform();
			trans.color = c;
			_progress.transform.colorTransform = trans;
			
			if(p >= 1)
			{
				_gameOver.text = "GAMEOVER";
				_gameOver.x = (400 - _gameOver.width)*0.5;
				_gameOver.y = (460 - _gameOver.height)*0.5;
				_clear();
			}
		}
		
		private function _numbering():void
		{
			var i:int = MAX;
			while(i--)
			{
				_numbers[i] = i;
			}
			_shuffle(_numbers);
			
			for(i=0; i<MAX; i++)
			{
				_boxs[i].setNum(_numbers[i]);
			}
		}
		
		private function _main():void
		{
			_mainArea = new Sprite();
			_mainArea.x = 5;
			_mainArea.y = 60;
			_cover = new Sprite();
			_cover.x = 5;
			_cover.y = 60;
			_cover.graphics.beginFill(0xFF0000, 0.0);
			_cover.graphics.drawRect(0, 0, 400, 400);
			_cover.graphics.endFill();
			addChild(_mainArea);
			addChild(_cover);
			var n:int;
			for(var i:int=0; i<400; i+=80)
			{
				for(var ii:int=0; ii<400; ii+= 80)
				{
					var box:Box = new Box();
					box.addEventListener(MouseEvent.CLICK, function(e:MouseEvent):void
					{
						var num:int = int(e.currentTarget.num);
						if(_hit == num)
						{
							_hit ++;
							_n.text = String(_hit);
							if(_hit == MAX)
							{
								_gameOver.text = "CLEAR!!";
								_gameOver.x = (400 - _gameOver.width)*0.5;
								_gameOver.y = (460 - _gameOver.height)*0.5;
								_clear();
							}
						}
					});
					box.x = i;
					box.y = ii;
					_mainArea.addChild(box);
					_boxs.push(box);
					n++;
				}
			}
		}
		
		private function _button():void
		{
			var button:Sprite = new Sprite();
			button.buttonMode = true;
			button.addEventListener(MouseEvent.CLICK, function(e:MouseEvent):void
			{
				if(_isPlay)
				{
					_p.text = "start";
					_reset();
				}
				else
				{
					_p.text = "reset";
					_gameOver.visible = false;
					_start();
				}
				_cover.visible = !_cover.visible;
				_isPlay = !_isPlay;
			});
			button.graphics.lineStyle(1, O_COLOR);
			button.graphics.beginFill(0xFFFFFF);
			button.graphics.drawRect(0, 0, 50, 20);
			button.graphics.endFill();
			button.x = 410;
			button.y = 60;
			_p = new TT(12, O_COLOR);
			_p.text = "start";
			button.addChild(_p);
			addChild(button);
		}
		
		private function _next():void
		{
			var n:TT = new TT(14, T_COLOR);
			n.text = "next→";
			n.x = 300;
			n.y = 20;
			addChild(n);
			
			_n = new TT(40, T_COLOR);
			_n.x = 350;
			_n.text = String(_cnt);
			addChild(_n);
		}
		
		private function _time():void
		{
			var t:TT = new TT(14, T_COLOR);
			t.text = "timer→";
			t.x = 10;
			t.y = 20;
			addChild(t);
			var bar:Sprite = new Sprite();
			bar.graphics.lineStyle(1, T_COLOR);
			bar.graphics.drawRect(0, 0, 200, 20);
			bar.graphics.endFill();
			bar.x = 70;
			bar.y = 20;
			addChild(bar);
			_progress = new Sprite();
			_progress.graphics.lineStyle(1, T_COLOR);
			_progress.graphics.beginFill(T_COLOR);
			_progress.graphics.drawRect(0, 0, 196, 16);
			_progress.graphics.endFill();
			_progress.x = 2;
			_progress.y = 2;
			bar.addChild(_progress);
		}
		
		private function _shuffle(values:Array):void
		{
			var n:int = values.length;
			var i:int = n;
			while (i--)
			{
				var j:int = Math.floor(Math.random()*n);
				var t:* = values[i];
				values[i] = values[j];
				values[j] = t;
			}
	    }
	}
}
	import flash.display.Sprite;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.text.TextFieldAutoSize;
	import flash.events.MouseEvent;
	import flash.geom.ColorTransform;
	

class Box extends Sprite
{
	private static const T_COLOR:uint = 0x57390F;
	private static const O_COLOR:uint = 0xFF390F;
	private var _inside:Sprite;
	private var _tf:TT;
	private var _num:int;
	
	public function Box()
	{
		this.buttonMode = true;
		this.addEventListener(MouseEvent.MOUSE_OVER, _onMouseOver);
		this.addEventListener(MouseEvent.MOUSE_OUT, _onMouseOut);
		
		this.graphics.beginFill(0xFFFFFF);
		this.graphics.drawRect(0, 0, 80, 80);
		this.graphics.endFill();
		_inside = new Sprite();
		_inside.graphics.beginFill(T_COLOR);
		_inside.graphics.drawRect(2, 2, 76, 76);
		_inside.graphics.endFill();
		addChild(_inside);
		_tf = new TT(30, 0xFFFFFF);
		addChild(_tf);
	}
	
	private function _onMouseOver(e:MouseEvent):void
	{
		_setColor(O_COLOR);
	}
	
	private function _onMouseOut(e:MouseEvent):void
	{
		_setColor(T_COLOR)
	}
	
	public function setNum(num:int):void
	{
		_num = num;
		_tf.text = String(num);
		_tf.x = (this.width - _tf.width)*0.5;
		_tf.y = (this.height - _tf.height)*0.5;
	}
	
	private function _setColor(color:uint):void
	{
		var trans:ColorTransform = new ColorTransform();
		trans.color = color;
		_inside.transform.colorTransform = trans;
	}
	
	public function get num():int { return _num; }
}

class TT extends TextField
{
	public function TT(size:Number, color:uint)
	{
		var format:TextFormat = new TextFormat();
		format.font = "Verdana";
		format.size = size;
		format.color = color;
		this.defaultTextFormat = format;
		this.mouseEnabled = false;
		this.autoSize = TextFieldAutoSize.LEFT;
	}
}