/**
 * Copyright soundkitchen ( http://wonderfl.net/user/soundkitchen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8J2d
 */

// forked from clockmaker's Loaderからクラス参照を取得する方法
// forked from ProjectNya's ひよこちゃんで学ぶwonderfl
////////////////////////////////////////////////////////////////////////////////
// ひよこちゃんで学ぶwonderfl
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1203
////////////////////////////////////////////////////////////////////////////////
package {
    import flash.display.*;
    import flash.events.*;
    import flash.net.*;
    import flash.system.*;

    public class Main extends Sprite {

        public static const NUM_PIYOS:uint = 30;
        private var loader:Loader;
        private var piyos:Vector.<MovieClip>;

        private static var chickPath:String = "http://www.project-nya.jp/images/flash/chick.swf";

        public function Main() {
            loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, _onComplete);
            loader.load(new URLRequest(chickPath), new LoaderContext(true));
        }

        private function _onComplete(e:Event):void {

            piyos = new Vector.<MovieClip>(NUM_PIYOS, true);

            // Loader から Class 参照を得る
            var content:MovieClip = loader.contentLoaderInfo.content as MovieClip;
            var Piyo:Class = MovieClip(content).constructor;

            // クラス参照から複製
            for(var i:int = 0; i<NUM_PIYOS; i++){
                var piyo:MovieClip = new Piyo();
                piyo.x = Math.random() * stage.stageWidth;
                piyo.y = Math.random() * stage.stageHeight;
                piyo.vx = Math.random() * 6 - 3;
                piyo.vy = Math.random() * 6 - 3;
                addChild(piyo);
                piyos[i] = piyo;
            }

            addEventListener(Event.ENTER_FRAME, _onEnterFrame);
        }

        private function _onEnterFrame(e:Event):void
        {
            var sw:Number = stage.stageWidth;
            var sh:Number = stage.stageHeight;

            for each (var piyo:MovieClip in piyos) {
                piyo.x += piyo.vx;
                piyo.y += piyo.vy;
                if (piyo.x <= 0) {
                    piyo.vx *= -1;
                    piyo.x = 0;
                }
                else if (piyo.x >= sw) {
                    piyo.vx *= -1;
                    piyo.x = sw;
                }
                if (piyo.y <= 0) {
                    piyo.vy *= -1;
                    piyo.y = 0;
                }
                else if (piyo.y >= sh) {
                    piyo.vy *= -1;
                    piyo.y = sh;
                }
            }
        }
    }
}
