/**
 * Copyright motioneditor ( http://wonderfl.net/user/motioneditor )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8InU
 */

// forked from mattodesign's くちゃくちゃの時計
package {
	import flash.display.MovieClip;
	import flash.display.Sprite;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.utils.Timer;
	import flash.events.TimerEvent;
	import flash.text.TextFormat;
	[SWF(width = "465", height = "465", frameRate = "60", backgroundColor = "#FFFFFF")]
	public class Clock extends MovieClip {
		private var base: Sprite;
		private var timer: Timer;
		
		private var TimeFieldSymbol:Sprite;
		private var time:TextField;
		private var timeTF:Array/*TextField*/;
		private var timeFM:TextFormat;
		
		private var hourTF: Array/*Sprite*/;
		private var minuteTF: Array/*Sprite*/;
		private var secondTF: Array/*Sprite*/;
		
		private var hourX: Array, hourY: Array, hourSize: Array;
		private var minuteX: Array, minuteY: Array, minuteSize: Array;
		private var secondX: Array, secondY: Array, secondSize: Array;
		
		function Clock() {
			//時間の表示
			hourTF = new Array();
			hourX = new Array();
			hourY = new Array();
			hourSize = new Array();
			timeTF = new Array();
			timeFM = new TextFormat();
			timeFM.size = 30;
			timeFM.font = "Arial";
			for (var i:Number = 0; i < 24; i++) {
				TimeFieldSymbol = new Sprite();
				time = new TextField();
				time.autoSize = TextFieldAutoSize.LEFT;
				hourTF.push(TimeFieldSymbol);
				timeTF.push(time);
				
				addChild(hourTF[hourTF.length - 1]);
				hourTF[hourTF.length - 1].addChild(timeTF[timeTF.length - 1]);
				
				if(i < 10)  timeTF[timeTF.length-1].text = "0"+i;
				else  timeTF[timeTF.length - 1].text = i;
				
				timeTF[timeTF.length - 1].x = -timeTF[timeTF.length - 1].textWidth / 2;
				timeTF[timeTF.length - 1].y = -timeTF[timeTF.length - 1].textHeight / 2;
				
				hourX.push(Math.random() * stage.stageWidth);
				hourY.push(Math.random() * stage.stageWidth);
				hourSize.push(Math.random() * 5);
			}
			//分
			minuteTF = new Array();
			minuteX = new Array();
			minuteY = new Array();
			minuteSize = new Array();
			for (i = 0; i < 60; i++) {
				TimeFieldSymbol = new Sprite();
				time = new TextField();
				time.autoSize = TextFieldAutoSize.LEFT;
				minuteTF.push(TimeFieldSymbol);
				timeTF.push(time);
				
				addChild(minuteTF[minuteTF.length - 1]);
				minuteTF[minuteTF.length - 1].addChild(timeTF[timeTF.length-1]);
				
				if(i < 10)  timeTF[timeTF.length-1].text = "0"+i;
				else  timeTF[timeTF.length-1].text = i;
				
				timeTF[timeTF.length - 1].x = -timeTF[timeTF.length - 1].textWidth / 2;
				timeTF[timeTF.length - 1].y = -timeTF[timeTF.length - 1].textHeight / 2;
				
				minuteX.push(Math.random() * stage.stageWidth);
				minuteY.push(Math.random() * stage.stageWidth);
				minuteSize.push(Math.random() * 5);
			}
			//秒
			secondTF = new Array();
			secondX = new Array();
			secondY = new Array();
			secondSize = new Array();
			for (i = 0; i < 60; i++) {
				TimeFieldSymbol = new Sprite();
				time = new TextField();
				time.autoSize = TextFieldAutoSize.LEFT;
				secondTF.push(TimeFieldSymbol);
				timeTF.push(time);
				
				addChild(secondTF[secondTF.length - 1]);
				secondTF[secondTF.length - 1].addChild(timeTF[timeTF.length-1]);
				
				if(i < 10)  timeTF[timeTF.length-1].text = "0"+i;
				else  timeTF[timeTF.length - 1].text = i;
				
				timeTF[timeTF.length - 1].x = -timeTF[timeTF.length - 1].textWidth / 2;
				timeTF[timeTF.length - 1].y = -timeTF[timeTF.length - 1].textHeight / 2;
				
				secondX.push(Math.random() * stage.stageWidth);
				secondY.push(Math.random() * stage.stageWidth);
				secondSize.push(Math.random() * 5);
			}
			timer = new Timer(33);
			timer.addEventListener(TimerEvent.TIMER, loop);
			timer.start();
		}
		
		public function loop(event:TimerEvent):void{
			var date:Date = new Date();
			
			var hours:Number = date.getHours();
			for (var i:Number = 0; i < 24; i++) {
				if (i == hours) {
					hourTF[i].x = stage.stageWidth / 2-20 ;
					hourTF[i].y = stage.stageHeight / 2 -150;
					hourTF[i].scaleX = 20;
					hourTF[i].scaleY = 20;
				}else{
					hourTF[i].x += (hourX[i]-hourTF[i].x)/2;
					hourTF[i].y += (hourY[i]-hourTF[i].y)/2;
					hourTF[i].scaleX += (hourSize[i]-hourTF[i].scaleX)/2;
					hourTF[i].scaleY += (hourSize[i] - hourTF[i].scaleY) / 2;
				}
			}
			
			var minutes:Number = date.getMinutes();
			for (i = 0; i < 60; i++) {
				if (i == minutes) {
					minuteTF[i].x = stage.stageWidth / 2-20 ;
					minuteTF[i].y = stage.stageHeight / 2 + 100;
					minuteTF[i].scaleX = 20;
					minuteTF[i].scaleY = 20;
				}else{
					minuteTF[i].x += (minuteX[i]-minuteTF[i].x)/2;
					minuteTF[i].y += (minuteY[i]-minuteTF[i].y)/2;
					minuteTF[i].scaleX += (minuteSize[i]-minuteTF[i].scaleX)/2;
					minuteTF[i].scaleY += (minuteSize[i]-minuteTF[i].scaleY)/2;
				}
			}
			
			var seconds:Number = date.getSeconds();
			for (i = 0; i < 60; i++) {
				if (i == seconds) {
					secondTF[i].x += (stage.stageWidth / 2 - secondTF[i].x) / 6-20;
					secondTF[i].y += (stage.stageHeight / 2 - secondTF[i].y) / 6-10;
					secondTF[i].scaleX += 3;
					secondTF[i].scaleY += 3;
				}else{
					secondTF[i].x += (secondX[i]-secondTF[i].x)/2;
					secondTF[i].y += (secondY[i]-secondTF[i].y)/2;
					secondTF[i].scaleX += (secondSize[i]-secondTF[i].scaleX)/2;
					secondTF[i].scaleY += (secondSize[i]-secondTF[i].scaleY)/2;
				}
			}
		}
	}
	}
