/**
 * Copyright dizgid ( http://wonderfl.net/user/dizgid )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8IV3
 */

// forked from dizgid's Pv3d Test
/**
_createViewPortLayer = true;
_interactive = true;
_anime = true
*/
package  
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	import net.hires.debug.Stats;
	import org.papervision3d.events.InteractiveScene3DEvent;
	import org.papervision3d.materials.MovieMaterial;
	import org.papervision3d.materials.utils.MaterialsList;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.objects.primitives.Cube;
	import org.papervision3d.view.BasicView;
	
	[SWF(backgroundColor="#ffffff", frameRate=60)]
	public class Pv3dTest extends BasicView
	{
		private var field:DisplayObject3D;
		private var _createViewPortLayer:Boolean = true;
		private var _interactive:Boolean = true;
		private var _anime:Boolean = true;
		
		public function Pv3dTest() 
		{
			field = new DisplayObject3D();
			field.name = "field";
			scene.addChild(field);
			
			viewport.interactive = _interactive;
			
			camera.z = -480;
			camera.useClipping = true;
			camera.useCulling = true;
			
			_createRandomCubes();
			
			this.startRendering();
			this.addEventListener(Event.ENTER_FRAME, update);
			this.addChild(new Stats());
		}
		
		private function update(e:Event):void 
		{
			field.rotationY += 0.3;
		}
		
		private function _createRandomCubes():void
		{
			var objs:Array = [];
			var size:Number = 60;
			var alpha:Number = 1.0;
			
			var p:Number = 2.75;
			var num:int = 4;
			
			var offset:Number = -(size * p * (num - 1)) / 2;
			
			var colors:Array = [];
			for (var n:int = 0; n < 6; n++) {
				colors.push(0xffffff * Math.random());
			}
			for (var i:int = 0; i < num; i++) {
				for (var j:int = 0; j < num; j++) {
					for (var k:int = 0; k < num; k++) {
						
						var f0_:Sprite = new TestTexture();
						var f1_:Sprite = new TestTexture();
						var f2_:Sprite = new TestTexture();
						var f3_:Sprite = new TestTexture();
						var f4_:Sprite = new TestTexture();
						var f5_:Sprite = new TestTexture();
						
						var isAnime:Boolean = _anime;
						var interactive:Boolean = _interactive;
						var f0Mat:MovieMaterial = new MovieMaterial(f0_, false, isAnime);
						var f1Mat:MovieMaterial = new MovieMaterial(f1_, false, isAnime);
						var f2Mat:MovieMaterial = new MovieMaterial(f2_, false, isAnime);
						var f3Mat:MovieMaterial = new MovieMaterial(f3_, false, isAnime);
						var f4Mat:MovieMaterial = new MovieMaterial(f4_, false, isAnime);
						var f5Mat:MovieMaterial = new MovieMaterial(f5_, false, isAnime);
						f0Mat.interactive = interactive;
						f1Mat.interactive = interactive;
						f2Mat.interactive = interactive;
						f3Mat.interactive = interactive;
						f4Mat.interactive = interactive;
						f5Mat.interactive = interactive;
						
						var matList:MaterialsList = new MaterialsList();
						matList.addMaterial(f0Mat ,"front");
						matList.addMaterial(f1Mat ,"back");
						matList.addMaterial(f2Mat ,"left");
						matList.addMaterial(f3Mat ,"right");
						matList.addMaterial(f4Mat ,"top");
						matList.addMaterial(f5Mat ,"bottom");
						
						var cube:Cube = new Cube(matList, f0_.width, f0_.width, f0_.width, 2, 2, 2);
						if(_createViewPortLayer){
							cube.container = cube.createViewportLayer(viewport);
						}
						if(_interactive){
							cube.addEventListener(InteractiveScene3DEvent.OBJECT_PRESS, _rollOverHandler);
						}
						cube.x = i * size * p + offset;
						cube.y = j * size * p + offset;
						cube.z = k * size * p + offset;
						
						_startCubeAnime(cube);
						
						field.addChild(cube);
						
						objs.push(cube);
					}
				}
			}
		}
		
		private function _rollOverHandler(e:InteractiveScene3DEvent):void 
		{
			Cube(e.target).container.filters = [new BlurFilter(12, 12)];
		}
			
		
		private function _startCubeAnime(cube_:Cube):void
		{
			this.addEventListener(Event.ENTER_FRAME, function():void { cube_.rotationX += 1.5; cube_.rotationY += 1.0;} );
		}
	}

}

//
	import flash.display.Graphics;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	
	import caurina.transitions.properties.ColorShortcuts;
	import caurina.transitions.Tweener;
	/**
	 * ...
	 * @author inoook
	 */
	internal class TestTexture extends Sprite
	{
		public function TestTexture(str:String = "") 
		{			
			ColorShortcuts.init();
			
			var g:Graphics = this.graphics;
			var size:Number = 50;
			g.beginFill(Math.random()*0xffffff);
			g.drawRect(-size/2, -size/2, size, size);
			g.endFill();
			
			g.beginFill(Math.random()*0xffffff);
			g.drawCircle(0,0, size*0.4);
			g.endFill();
			
			this.addEventListener(MouseEvent.ROLL_OVER, _mouseOverHandler);
			this.addEventListener(MouseEvent.ROLL_OUT, _mouseOutHandler);
			
			this.addEventListener(MouseEvent.CLICK, _mouseClickHandler);
		}
		
		private function _mouseClickHandler(e:MouseEvent):void 
		{
			Tweener.addTween(this, { 
				_color:0xff0000,
				time:1, 
				transition:"linear",
				onComplete:function():void {
					
				}
			} );
		}
		
		private function _mouseOverHandler(e:MouseEvent):void 
		{
			//this.alpha = 0.3;
			Tweener.addTween(this, { 
				_color:0x00ff00,
				time:0.5, 
				transition:"linear",
				onComplete:function():void {
					
				}
			} );
		}
		
		private function _mouseOutHandler(e:MouseEvent):void 
		{
			//this.alpha = 1.0;
			Tweener.addTween(this, { 
				_color:null,
				time:0.5, 
				transition:"linear",
				onComplete:function():void {
					
				}
			} );
		}
		
	}