/**
 * Copyright Albert ( http://wonderfl.net/user/Albert )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8ILF
 */

// forked from Albert's forked from: flash on 2010-3-17
// forked from Albert's flash on 2010-3-17
package {
  import flash.display.Sprite;
  import flash.events.*;
  import flash.ui.*;
  import flash.text.*;
  import sandy.core.Scene3D;
  import sandy.core.data.*;
  import sandy.core.scenegraph.*;
  import sandy.materials.*;
  import sandy.materials.attributes.*;
  import sandy.primitive.*;
    public class FlashTest extends Sprite {
       private var scene:Scene3D;
        private var camera:Camera3D;
        private var myCone:Cone;
        private var myHedra:Hedra;
        private var myText:TextField = new TextField();
        private var needRemove:Boolean = false;
        private var boxes: Array=[[1,1,1,0,0,0],
                                     [1,1,1,0,0,0],
                                     [0,0,1,1,0,1],
                                     [0,0,0,1,1,1]];
        public function FlashTest() {
          camera = new Camera3D( 300, 300 );
          camera.x = 100;
          camera.y = 100;
          camera.z = -300;
          camera.lookAt(0,0,0);
          
          myText.width = 200;
          myText.x = 20;
          myText.y = 20;
          
          var root:Group = createScene();
          
          scene = new Scene3D( "scene", this, camera, root );
          
          addEventListener( Event.ENTER_FRAME, enterFrameHandler );
        }
        
        private function createScene():Group {
          var g:Group = new Group();
          
          myCone = new Cone("theObj1",50, 100);
          myHedra = new Hedra( "theObj2", 80, 60, 60 );
          
          myCone.x = -160;
          myCone.z = 150;
          myCone.y -= 50;
          myHedra.x = 50;
          myHedra.y -= 50;
          
          myCone.container.buttonMode = true;
          myHedra.container.buttonMode = true;
          
          var materialAttr:MaterialAttributes = new MaterialAttributes( 
                                  new LineAttributes( 0.5, 0x2111BB, 0.4 ),
                                  new LightAttributes( true, 0.1)
                                );
          
          var material:Material = new ColorMaterial( 0xFFCC33, 1, materialAttr );
          material.lightingEnable = true;
          var app:Appearance = new Appearance( material );
          myCone.appearance = app;
          myHedra.appearance = app;
          
          myCone.container.addEventListener(MouseEvent.CLICK, clickHandler);
          myCone.container.addEventListener(MouseEvent.MOUSE_OUT, outHandler);
          myHedra.container.addEventListener(MouseEvent.MOUSE_OVER, overHandler);
          myHedra.container.addEventListener(MouseEvent.MOUSE_OUT, outHandler);
        
          g.addChild(myCone);
          g.addChild(myHedra);
          
          return g;
        }
        
        private function enterFrameHandler( event : Event ) : void {
          myHedra.pan +=4;
          myCone.pan +=4;
          scene.render();
        }
        
        private function clickHandler(event:MouseEvent):void {
          myText.text = "You have hit the Cone";
          this.addChild(myText);
          needRemove = true;
        }
        
        private function overHandler(event:MouseEvent):void {
          myText.text = "Your mouse is over the Hedra";
          myText.x = 20;
          myText.y = 20;
          this.addChild(myText);
          needRemove = true;
        }
        
        private function outHandler(event:MouseEvent):void {
          if (needRemove) {
            this.removeChild(myText);
            needRemove = false;
          }
        }
    }
}
