/**
 * Copyright Alex.Stenezky ( http://wonderfl.net/user/Alex.Stenezky )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8Hpc
 */

// forked from Alex.Stenezky's forked from: flash on 2011-9-22
// forked from gameegg's wonderfl particle
package {
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    import flash.events.MouseEvent;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.text.TextField;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.Sprite;
    public class WonderflParticle extends Sprite {
        
        private var space:Sprite;
        private var bit:Bitmap;
        private var bitd:BitmapData;
        private var bf:BlurFilter;
        private var ctf:ColorTransform;
        private var textbox:TextField;
        private var dotVector:Vector.<Dot>;
        private var mouseDown:Boolean;
        
        public function WonderflParticle() {
            graphics.beginFill(0x0);
            graphics.drawRect(0,0,465,465);
            
            space = new Sprite();
            //addChild(space);
            
            textbox = new TextField();
            textbox.x = 110;
            textbox.y = 465/2 - textbox.height/2;
            
            textbox.scaleX = 5;
            textbox.scaleY = 5;
            
            bitd = new BitmapData(465,465,false,0x000000);
            bit = new Bitmap(bitd);
            addChild(bit);
            
            textbox.textColor = 0xffffff;
            textbox.text = "Рунетия"
            bitd.draw(textbox,textbox.transform.matrix);
            textbox.x = 290;
            textbox.textColor = 0xaa0000;
            textbox.text = "fl"
            bitd.draw(textbox,textbox.transform.matrix);
            
            
            bf = new BlurFilter(16,16,3);
            ctf = new ColorTransform(1,1,1,0.5);
            mouseDown = false;
            
            dotVector = new Vector.<Dot>();
            
            for(var i:int = 0; i<465; ++i) {
                for(var j:int = 0; j<465; ++j) {
                    var color:Number = bitd.getPixel(j,i);
                    if(color != 0x0){
                        var dot:Dot = new Dot(j,i,j,i,color);
                        dotVector.push(dot);
                    }

                }

            }
            
            
            stage.addEventListener("mouseDown",md);
            stage.addEventListener("mouseUp",mu);
            addEventListener("enterFrame",ef);
            

        }
        
        private function ef(e:Event):void {
            
            //space.graphics.clear();
            bitd.colorTransform(bitd.rect,ctf);
            for(var k:int = 0; k < dotVector.length; ++k) {
                var tmpdot:Dot = dotVector[k];
                if(mouseDown){
                    //tmpdot.x += (mouseX - tmpdot.x)/10;
                    //tmpdot.y += (mouseY - tmpdot.y)/10;
                    var r:Number = pit(tmpdot.x,tmpdot.y,mouseX,mouseY);
                    var th:Number = Math.atan2(mouseY-tmpdot.y,mouseX-tmpdot.x);
                    if(r>25){
                    tmpdot.x += Math.cos(th+1.2)*50/r//(mouseX - tmpdot.x)/100;
                    tmpdot.y += Math.sin(th+1.2)*50/r//(mouseY - tmpdot.y)/100;
                    }
                    else {
                    tmpdot.x += Math.cos(th+1.2)*2
                    tmpdot.y += Math.sin(th+1.2)*2
                    }

                }
                else {
                    //tmpdot.sx += (tmpdot.ox - tmpdot.x)/100;
                    //tmpdot.sy += (tmpdot.oy - tmpdot.y)/100;
                    tmpdot.x += (tmpdot.ox - tmpdot.x)/10;
                    tmpdot.y += (tmpdot.oy - tmpdot.y)/10;
                }
                tmpdot.update();
                //space.graphics.beginFill(tmpdot.color);
                //space.graphics.drawCircle(tmpdot.x,tmpdot.y,1);
                bitd.setPixel(tmpdot.x,tmpdot.y,tmpdot.color);
            }
            
            //graphics.clear();
            //bitd.draw(space,space.transform.matrix);
            
        }
        
        private function pit(a:Number,b:Number,c:Number,d:Number):Number{
            return Math.sqrt((a-c)*(a-c)+(b-d)*(b-d));
        }

        
        private function md(e:MouseEvent):void {
            mouseDown = true;
            for(var k:int = 0; k < dotVector.length; ++k) {
                var tmpdot:Dot = dotVector[k];
                tmpdot.sx =0;
                tmpdot.sy =0;
            }
        }
        
        private function mu(e:MouseEvent):void {
            mouseDown = false;
        }


    }
}

internal class Dot {
    public var px:Number = 0;
    public var py:Number = 0;
    public var x:Number = 0;
    public var y:Number = 0;
    public var ox:Number = 0;
    public var oy:Number = 0;
    public var sx:Number = 0;
    public var sy:Number = 0;
    public var color:Number = 0;
    
    public function Dot(ix:Number,iy:Number,iox:Number,ioy:Number,icolor:Number) {
        px = x = ix;
        py = y = iy;
        ox = iox;
        oy = ioy;
        color = icolor;
    }
    
    public function update():void {
        px = x;
        py = y;
        x += sx;
        y += sy;
        
        sx *= 0.95
        sy *= 0.95
    }

}







