/**
 * Copyright spanvega ( http://wonderfl.net/user/spanvega )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8Hhc2
 */

package
{
    import flash.geom.*;
    import flash.media.*;
    import flash.display.*;
    import flash.events.Event;
    import flash.net.URLRequest;
    import flash.utils.setTimeout;

    /* @author SPANVEGA // CHRISTIAN */

    public class K extends Sprite
    {
        private var c : ColorTransform = new ColorTransform (1, 1, 1, 0.5);

        private var m : Matrix3D = new Matrix3D (),
                    v : Vector.<Number>, p : Vector.<Number>;

        private var w : uint = 465, h : uint = 465,
                    cx : Number = w >> 1, cy : Number = h >> 1,
                    b : BitmapData = new BitmapData (w, h, true, 0);

        private var n : int = 90000,

                    scale : int = 70,

                    _a : Number = -1.1,
                    _b : Number = -2.4,
                    _c : Number =  0.5,
                    _d : Number =  1.0;

        private var playing : Boolean = false,
                    channel : SoundChannel,
                    sound : Sound;
        
        private var smoothLeft  : Smoothsteps = new Smoothsteps (5),
                    smoothRight : Smoothsteps = new Smoothsteps (5);

        // https://developers.soundcloud.com/docs/api/reference
        private var CLIENT_ID : String = 'c644fa92a0e751bad397bdd5b8e35ae5',
                     TRACK_ID : Number = 185881845;

        public function K () { addEventListener (Event.ADDED_TO_STAGE, init); }
        
        private function init (e : Event) : void
        {
            removeEventListener (Event.ADDED_TO_STAGE, init);

            with (stage) { scaleMode = 'noScale'; frameRate = 60; color = 0; }

            graphics.beginFill (0, 1);
            graphics.drawRect  (0, 0, w, h);

            addChild (new Bitmap (b));

            //

            m.prependTranslation (cx, cy, 0);

            v = new Vector.<Number>(n, true);
            p = new Vector.<Number>(n, true);

            plot ();

            //

            sound = new Sound ();
            sound.load (new URLRequest ('https://api.soundcloud.com/tracks/' + TRACK_ID + '/stream?client_id=' + CLIENT_ID));
            
            setTimeout (start, 3000);

            addEventListener (Event.ENTER_FRAME, render);
        }

        private function start () : void
        {
            channel = sound.play (0, int.MAX_VALUE);

            playing = true;
        }

        private function render (e : Event = null) : void
        {
            if (playing)
            {
                _c =  smoothLeft.push (channel.leftPeak  * 2);
                _d = smoothRight.push (channel.rightPeak * 2);

                plot ();
            }

            //

            m.prependRotation (1, Vector3D.X_AXIS);
            m.prependRotation (1, Vector3D.Y_AXIS);

            m.transformVectors (v, p);

            //

            b.lock();
            b.colorTransform (b.rect, c);

            var d : Number, j : Number, k : Number;

            for (var i : int = 0; i < n; i += 3)
            {
                j = cx - p [i]; k = cy - p [i+1];

                d = Math.sqrt (j * j + k * k);

                if (d > 0xFF) d = 0xFF;

                b.setPixel32 (p [i], p [i+1], 0xFF << 24 | 0xFF << 16 | (0xFF - d)  << 8);
            }

            b.unlock();
        }

        // http://softology.com.au/tutorials/attractors2d/tutorial.htm

        private function plot () : void
        {
            var _x : Number = 1, _y : Number = 1, _z : Number;
            var nx : Number,     ny : Number,     nz : Number;

            for (var i : int = 0; i < n; i += 3)
            {
                nx = Math.sin (_y * _b) + _c * Math.sin (_x * _b);
                ny = Math.sin (_x * _a) + _d * Math.sin (_y * _a);
                nz = _x * _y;

                v [i]     = (_x = nx) * scale;
                v [i + 1] = (_y = ny) * scale;
                v [i + 2] = (_z = nz) * scale;
            }
        }
    }
}

class Smoothsteps
{
    public var previous : Number, current : Number = 0;

    private var values : Vector.<Number>;

    private var iterator : int = 0;

    private var steps : int;


    public function Smoothsteps (steps : int) : void
    {
        values = new Vector.<Number> (steps, true);

        this.steps = steps;
    }

    public function push (value : Number) : Number
    {
        values [iterator++ % steps] = value;

        var sum : Number = 0,

            tmp : int = iterator < steps ? iterator : steps;

        for (var i : int = 0; i < tmp; i++)
        {
            sum += values [i];
        }

        previous = current;

        current = sum / tmp;

        return current;
    }
}