/**
 * Copyright ohisama ( http://wonderfl.net/user/ohisama )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8H4w
 */

// forked from clockmaker's 爆発するワンコ(チェックメイト)
// forked from soundkitchen's パァン！ (soundkichenさんのcodeをfolk)
package
{
    import flash.display.*;
    import flash.events.*;
    import flash.net.*;
    import flash.system.*;
    import flash.text.*;
    import flash.filters.*;
    import flash.geom.*;
    import flash.utils.*;
    import jp.progression.commands.lists.SerialList;
    import jp.progression.commands.net.LoadSWF;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.easing.*;
    import org.libspark.betweenas3.tweens.ITween;
    //[SWF(width=465, height=465, frameRate=30, backgroundColor=0x0f0f0f)]
    public class Amateur extends Sprite
    {
        public static var GRAPHICS_URL : String = "http://swf.wonderfl.net/static/assets/checkmate05/wancoAmateur.swf"; 
        public var stayMotion : MovieClip;
        //public var jumpMotion : MovieClip;
        //public var highJumpMotion : MovieClip;
        //public var walkMotion : MovieClip;
        //public var runMotion : MovieClip;
        //public var squatMotion : MovieClip;
        //public var questionMotion : MovieClip;
        //public var exclamationMotion : MovieClip;
        //public var heartMotion : MovieClip;
        //public var poutMotion : MovieClip;
        //public var starMotion : MovieClip;
        //public var singMotion : MovieClip;
        //public var sleepMotion : MovieClip;
        //public var wakeMotion : MovieClip;
        private static var P_ZERO : Point = new Point();
        private static var F_BLUR : BlurFilter = new BlurFilter(4, 4, BitmapFilterQuality.LOW);
        private var _film : BitmapData;
        private var _timer : Timer;
        private var _activeParticles : Vector.<Particle>;
        private var _inactiveParticles : Vector.<Particle>;
        public function Amateur()
        {
            Wonderfl.capture_delay(4);
            new SerialList(null, 
                new LoadSWF(new URLRequest(GRAPHICS_URL)), function() : void 
                {
                    var loader : Loader = Loader(this.latestData );
                    var domain : ApplicationDomain = loader.contentLoaderInfo.applicationDomain;
                    stayMotion = new (domain.getDefinition("StayMotion") as Class);
                },
                onLoadSWF
            ).execute();
        }
        protected function onLoadSWF() : void 
        {
            graphics.beginFill(0)
            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            var i : uint, fmt : TextFormat, bm : Bitmap;
            _activeParticles = new Vector.<Particle>();
            _inactiveParticles = new Vector.<Particle>();
            //for (i = 0; i < 1; i++) _inactiveParticles.push(new Particle());
            _film = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0);
            bm = new Bitmap(_film);
            addChild(bm);
            _timer = new Timer(0);
            _timer.addEventListener(TimerEvent.TIMER, timerHandler);
            _timer.start();
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }
        private function enterFrameHandler(evt : Event) : void
        {
            var i : uint, p : Particle;
            _film.lock();
            _film.applyFilter(_film, _film.rect, P_ZERO, F_BLUR);
            for (i = 0; i < _activeParticles.length; i++)
            {
                p = _activeParticles[i];
                p.x += p.vx;
                p.y += p.vy;
                p.life--;
                _film.setPixel32(p.x, p.y, p.color);
                if (!p.life)
                {
                    _activeParticles.splice(i, 1);
                    _inactiveParticles.push(p);
                    i--;
                }
            }
            _film.unlock();
        }
        private function timerHandler(evt : TimerEvent) : void
        {
            _timer.delay = (900 + Math.random() * 950) >> 0;
            var sp : Sprite, bm : Bitmap, bmd : BitmapData, t : ITween;
            var m : Matrix = new Matrix();
            m.translate(stayMotion.width / 2, stayMotion.height);
            bmd = new BitmapData(stayMotion.width, stayMotion.height, true, 0);
            bmd.draw(stayMotion, m);
            bm = new Bitmap(bmd);
            bm.smoothing = true;
            bm.x -= bm.width >> 1;
            bm.y -= bm.height >> 1;
            sp = new Sprite();
            sp.addChild(bm);
            sp.x = (Math.random() * stage.stageWidth) >> 0;
            sp.y = (Math.random() * stage.stageHeight) >> 0;
            sp.scaleX = 0;
            sp.scaleY = 0;
            sp.rotation = (Math.random() * 360) >> 0;
            //addChild(sp);
            t = BetweenAS3.serial(BetweenAS3.to(sp, 
                {
                    scaleX : 2,
                    scaleY : 2,
                    rotation : 0
                }, 3, Expo.easeIn),
                BetweenAS3.removeFromParent(sp)
            );
            t.onComplete = tweenComplete;
            t.onCompleteParams = [sp, bm, bmd];
            t.play();
        }
        private function tweenComplete(sp : Sprite, bm : Bitmap, bmd : BitmapData) : void
        {
            var i : uint, j : uint, c : uint, cx : Number, cy : Number, angle : Number, strength : Number, p : Particle;
            cx = sp.x + bm.x;
            cy = sp.y + bm.y;
            for (i = 0; i < bmd.width; i++)
            {
                for (j = 0; j < bmd.height; j++)
                {
                    c = bmd.getPixel32(i, j) + 100;
                    if (!c) continue;
                    p = _inactiveParticles.length ? _inactiveParticles.shift() : new Particle();
                    angle = Math.random() * Math.PI * 2;
                    strength = Math.random() * 20;
                    p.vx = Math.cos(angle) * strength;
                    p.vy = Math.sin(angle) * strength;
                    p.x = cx + i;
                    p.y = cy + j;
                    p.color = c;
                    p.life = 10;
                    _activeParticles.push(p);
                }
            }
            bmd.dispose();
            var flash : Sprite = new Sprite()
            flash.graphics.beginFill(0xFFFFFF)
            flash.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight)
            flash.blendMode = BlendMode.OVERLAY
            flash.alpha = 0
            BetweenAS3.serial(BetweenAS3.addChild(flash, this),
                BetweenAS3.tween(flash, {alpha : 0}, {alpha : 1}, 0.3, Sine.easeIn),
                BetweenAS3.removeFromParent(flash)
            ).play()
        }
    }
}
class Particle
{
    public var vx : Number;
    public var vy : Number;
    public var x : Number;
    public var y : Number;
    public var color : uint;
    public var life : uint;
}
