/**
 * Copyright takahashitakashi ( http://wonderfl.net/user/takahashitakashi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8GJR
 */

// forked from shohei909's TweenLiteはどのくらい速いのか？10000パーティクル実験
//tweenするならtweenLiteが軽いと聞いたのでどのくらい軽いか実験
//20000パーティクルくらいなら、普通に動かせた。

package {
    import flash.display.Sprite;
    import net.hires.debug.Stats;
    [SWF(backgroundColor=0x0, width=465, height=456, frameRate=30)]
    public class FlashTest extends Sprite {
        public function FlashTest() {
            addChild( new PixelMap(465,465) );
            addChild( new Stats() )
        }
    }
}
import flash.events.Event;
import flash.events.*;
import flash.filters.BitmapFilter;
import flash.filters.BlurFilter;
import flash.geom.Point;
import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.utils.Timer;

//tweenLiteをインポート
import gs.*;
import gs.easing.*;

class PixelMap extends Bitmap{
    private var black:BitmapData;
    private var size:int = 10000;
    private var pixels:Vector.<Pixel> = new Vector.<Pixel>();
    private var filter:BitmapFilter = new BlurFilter();
    
    private var base:BitmapData;
    private var baseSize:int = 50;
    private const easeType:Array = [Bounce.easeOut,Back.easeOut,Circ.easeInOut]
    
    function PixelMap(width:int,height:int):void{
        black = new BitmapData(width, height, false, 0x000000);
        base = new BitmapData(baseSize,baseSize);
        super( new BitmapData(width,height,false,0x000000) );
        for(var i:int=0;i<size;i++){
            new Pixel(pixels,width*Math.random(), height*Math.random(),0xD50000*Math.random());
        }
        
        this.addEventListener("addedToStage",init);
        pixels.fixed = true; 
    }
    private function init(e:Event):void {
        var _timer:Timer = new Timer(5000);
        _timer.start();
        onTimer();
        _timer.addEventListener(TimerEvent.TIMER, onTimer);
        stage.addEventListener(MouseEvent.MOUSE_DOWN, onDown);
        this.addEventListener("enterFrame",onFrame);
    }
    
    private function onFrame(e:Event):void { drow(); }

    private function onDown(e:Event=null):void {    
        for each( var pixel:Pixel in pixels ){
            TweenLite.to(pixel, 1, { x:mouseX, y:mouseY, color:0x00DD00, delay:Math.random() ,ease:Back.easeIn } );
        }
    }    
    
    private function onTimer(e:Event = null):void {
        var w:uint = width; var h:uint = height;
        base.perlinNoise(10,10,1,Math.random()*100,true,false);
        var ease:Function = easeType[int(easeType.length*Math.random())]
        for each( var pixel:Pixel in pixels ) {
            do {
                var rx:Number = Math.random();
                var ry:Number = Math.random();
                var ok:Boolean = (base.getPixel(rx*baseSize,ry*baseSize)*Math.random() > 0x100000)
            }while (ok)
            rx *= w;
            ry *= h;
            TweenLite.to(pixel, 1, { x:rx, color:Math.random()*0x1000000, delay:Math.random() ,y:ry, ease:ease } );
        }
    }    
    private function drow():void{
        var b:BitmapData = bitmapData;
        b.lock();
        b.merge(black, b.rect, new Point(), 2, 2, 8, 255);
        b.applyFilter(b,b.rect, new Point(), filter);
        for each( var pixel:Pixel in pixels ){
            pixel.draw( b );
        }
        b.unlock();
    }
}



class Pixel extends Object{
    public var x:uint, y:uint;
    private var parent:Vector.<Pixel> = new Vector.<Pixel>();
    public var color:uint;
    
    public function Pixel(target:Vector.<Pixel>,x:int,y:int,color:uint){
        parent = target;
        parent.push( this );
        this.x = x; this.y = y;
        this.color=color;
    }
    public function draw( data:BitmapData ):void{ data.setPixel(x,y,color); }
}
