/**
 * Copyright mousepancyo ( http://wonderfl.net/user/mousepancyo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8FOU
 */

package
{
    import com.bit101.components.*;
    
    import flash.display.Sprite;
    import flash.events.IOErrorEvent;
    import flash.events.MouseEvent;
    import flash.net.Socket;
    
    [SWF(width = "465", height = "465", backgroundColor = "0xCFCFCF", frameRate = "30")]
    
    public class ARDroneTest extends Sprite
    {
        
        public var bt_takeoff:PushButton;
        public var bt_landing:PushButton;
        public var bt_rotateR:PushButton;
        public var bt_rotateL:PushButton;
        
        public var bt_moveRight:PushButton;
        public var bt_moveLeft:PushButton;
        public var bt_moveFront:PushButton;
        public var bt_moveBack:PushButton;
        public var bt_moveStop:PushButton;
        
        public var bt_cameraChange:PushButton;
        
        private var _camMode:int;
        
        private var _sock:Socket;
        
        
        public function ARDroneTest()
        {
            setup();
        }
        
        // -------------- Setup ----------------------------------------------- /
        private function setup():void
        {
            // add Button
            bt_takeoff = new PushButton( this, stage.stageWidth * .5 - 50, 20, "TAKEOFF", onClick );
            bt_landing = new PushButton( this, stage.stageWidth * .5 - 50, stage.stageHeight - 40, "LANDING", onClick );
            
            bt_rotateR = new PushButton( this, bt_landing.x + 120, bt_landing.y, "ROTATION RIGHT", onClick );
            bt_rotateL = new PushButton( this, bt_landing.x - 120, bt_landing.y, "ROTATION LEFT", onClick );
            
            bt_moveStop = new PushButton( this, bt_takeoff.x, stage.stageHeight * .5 - 10, "MOVE STOP", onClick );
            bt_moveFront = new PushButton( this, bt_takeoff.x, bt_moveStop.y - 30, "MOVE FRONT", onClick );
            bt_moveBack = new PushButton( this, bt_takeoff.x, bt_moveStop.y + 30, "MOVE BACK", onClick );
            bt_moveRight = new PushButton( this, bt_takeoff.x + 110, bt_moveStop.y, "MOVE RIGHT", onClick );
            bt_moveLeft = new PushButton( this, bt_takeoff.x - 110, bt_moveStop.y, "MOVE LEFT", onClick );
            
            bt_cameraChange = new PushButton( this, stage.stageWidth * .5 - 50, bt_landing.y - 30, "CAMERA CHANGE", onClick );
            
            // init CamMode
            _camMode = 0;
            
            // Socket
            _sock = new Socket();
            _sock.connect("localhost", 5204);
            _sock.addEventListener( IOErrorEvent.IO_ERROR, onConnectError ); // Error Handling.
            
            function onConnectError( e:IOErrorEvent ):void
            {
                trace( e );
            }
            
        }
        
        
        // -------------- MouseHandler ----------------------------------------------- /
        private function onClick( e:MouseEvent ):void
        {la
            var bt:PushButton = e.currentTarget as PushButton;
            
            //sendData( "test" );
            
            trace(bt);
            
            switch( bt )
            {
                case bt_takeoff:
                    sendData( "takeoff" );
                    break;
                case bt_landing:
                    sendData( "landing" );
                    break;
                case bt_rotateR:
                    break;
                case bt_rotateL:
                    break;
                case bt_moveStop:
                    break;
                case bt_moveFront:
                    break;
                case bt_moveBack:
                    break;
                case bt_moveRight:
                    break;
                case bt_moveLeft:
                    break;
                case bt_cameraChange:
                    sendData( cameraMode() );
                    break;
                default :
                    break;
            }
        }
        
        
        // ------------- camara change ---------------------------------------------------- /
        private function cameraMode():String
        {
            var str:String;
            
            switch( _camMode )
            {
                case 0:
                    str = "camF";
                    break;
                case 1:
                    str = "camFB";
                    break;
                case 2:
                    str = "camB";
                    break;
                case 3:
                    str = "camBF";
                    break;
                default:
                    break;
            }
            
            if(_camMode > 3)
            {
                _camMode = 0;
            }
            else
            {
                _camMode ++;
            }
            
            return str;
        }
        
        
        // ------------- Socket Sender ---------------------------------------------------- /
        private function sendData( data:String ):void
        {
            try
            {
                // Wrighte
                _sock.writeUTFBytes( data );
                //　Send
                _sock.flush();
            } 
            catch(e:Error) 
            {
                trace( e );    
            }
        }
    }
}