/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8FOK5
 */

package {
    import flash.text.TextField;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            // write as3 code here..
        
            deb = new TextField();
            deb.width = 465;
            deb.height = 465;
            deb.mouseEnabled = false;
            addChild(deb);
        
            
            var i:int;
            var num:int;
            var a:xPoint;
            
            vecPnt = new Vector.<xPoint>;
            
            
            for (i = 0; i < 64; i++)
            {
                a = new xPoint();
                a.cx = Math.random() * 465;
                a.cy = Math.random() * 465;
                vecPnt.push(a);
                
            }//nexti
            
            vecNode = new Vector.<xNode>;
            var m:xNode;
            
            m = new xNode();
            m.cx = 200;
            m.cy = 200;
            m.cang = 0;
            m.size = 32;
            m.rad = 64;
            m.depth = 0;
    
            vecNode.push(m);
            
            
            m = new xNode();
            m.cx = 10;
            m.cy = 0;
            m.cang = 0.4;
            m.tx = 0;
            m.ty = 0;
            m.tang = 0;
            m.size = 20;
            m.rad = 64;
            m.depth = 1;
            m.parent = vecNode[0];
   
            vecNode.push(m);
            
            m = new xNode();
            m.cx = 0;
            m.cy = 10;
            m.cang = 0;
            m.rad =64;
            m.depth = 2;
            m.parent = vecNode[1];
          
              vecNode.push(m);
            
            
            vecNode.sort(compNode);
            
            deb.text = "";
            
            num = vecNode.length;
            for (i = 0; i < num; i++)
            {
                m = vecNode[i];
                deb.appendText("\n m depth " + m.depth);
                if (m.parent == null)
                {
                  m.tx = m.cx;
                  m.ty = m.cy;
                  m.tang = m.cang;
                  setNode(m);
                  continue;  
                }
                moveNode(m, m.parent);
                setNode(m);
            }//nexti
            
            
            stage.addEventListener(Event.ENTER_FRAME, onEnter);
        }//ctor
        
        public var deb:TextField;
        
        
        
        public var vecPnt:Vector.<xPoint>;
        public var vecNode:Vector.<xNode>;
        
        public function compNode(a:xNode, b:xNode):Number
        {
             if (a.depth < b.depth) { return -1;}
             if (a.depth == b.depth) { return 0; }
             return 1;    
        }//compnode
        
        public function setNode(m:xNode):void
        {
            var ax:Number;
            var ay:Number;
            var bx:Number;
            var by:Number;
            var a:xPoint;
            var num:int;
            var i:int;
            var d:Number;
            
            ax = m.tx;
            ay = m.ty;
            bx = m.tx + Math.cos(m.tang) * m.size;
            by = m.ty + Math.sin(m.tang) * m.size;
            
            num = vecPnt.length;
            
            d = m.rad * m.rad;
            
            for (i = 0; i < num; i++)
            {
                a = vecPnt[i];
                if (getDist(a.cx, a.cy, ax, ay, bx, by) > d) { continue; }
                a.node = m;
            }//nexti
            
            
        }//setnode
        
        
        public function getDist(px:Number, py:Number, x0:Number, y0:Number, x1:Number, y1:Number):Number
        {
            var kx:Number;
            var ky:Number;
            var dx:Number;
            var dy:Number;
            var t:Number;
            
            t = getClosePoint(px, py, x0, y0, x1, y1);
            
            kx = x0 + (x1 - x0)*t;
            ky = y0 + (y1 - y0)*t;
            
            dx = px - kx;
            dy = py - ky;
            
            return (dx*dx + dy*dy);
            
        }//getdist
        
        
        public function getClosePoint(px:Number, py:Number, x0:Number, y0:Number, x1:Number, y1:Number):Number
        {
        
            var t:Number;
            var jx:Number; var jy:Number;
            var hx:Number; var hy:Number;
            var ab:Number; var ak:Number;
            
            jx = px - x0;
            jy = py - y0;
            hx = x1 - x0;
            hy = y1 - y0;
            
            ab = hx*hx + hy*hy;
            ak = jx*hx + jy*hy;
            
            t = ak / ab;
            
            if (t < 0) { t = 0;}
            if (t > 1) { t = 1;}
        
        return t;
        }//getclose
                
                
                
       public function moveNode(a:xNode, p:xNode):void
       {
            var rx:Number;
            var ry:Number;
            var an:Number;
            
            an = p.tang;
            
            rx = a.cx * Math.cos(an) - a.cy * Math.sin(an);
            ry = a.cx * Math.sin(an) + a.cy * Math.cos(an);
            
            a.tx = p.tx + rx;
            a.ty = p.ty + ry;
            a.tang = a.cang + p.tang;  
           
       }//movenode         
        
        
        
        
        public function onEnter(e:Event):void
        {
            var i:int;
            var num:int;
            var a:xPoint;
            var m:xNode;
            
            var kx:Number;
            var ky:Number;
            var ka:Number;     
                 
            
            graphics.clear();
            graphics.lineStyle(2, 0);
            
            m = vecNode[0];
            m.cx += 1;
            m.cang += 0.02;
            
            
            num = vecNode.length;
            for (i = 0; i < num; i++)
            {
                m = vecNode[i];
                if (m.parent == null)
                {
                   m.tx = m.cx;
                   m.ty = m.cy;
                   m.tang = m.cang;
                  continue;  
                }
                moveNode(m, m.parent);
            }//nexti
            
            
            num = vecPnt.length;
            
            for (i = 0; i < num; i++)
            {
                a = vecPnt[i];
                
                if (a.node == null)
                {
                graphics.drawCircle(a.cx, a.cy, 4);
                }
                else
                {
                  graphics.beginFill(0, 1);
                   graphics.drawCircle(a.cx, a.cy, 4);
                  graphics.endFill();   
                }
          
                  if (a.node == null) { continue;}
                  
                m = a.node;
                kx = m.tx - m.cx;
                ky = m.ty - m.cy;
                ka = m.tang - m.cang;      
                
                var rx:Number;
                var ry:Number;
                var jx:Number;
                var jy:Number;
                var tx:Number;
                var ty:Number;
                
                jx = a.cx - m.cx;
                jy = a.cy - m.cy;
                
                tx = jx * Math.cos(ka) - jy*Math.sin(ka) + kx;
                ty = jx * Math.sin(ka) + jy*Math.cos(ka) + ky;

                tx += m.cx;
                ty += m.cy;
                
                  graphics.beginFill(0xFF0000, 0.5);
                   graphics.drawCircle(tx, ty, 4);
                  graphics.endFill();   
                                  
                
            }//nexti
            
            
            num = vecNode.length;
            for (i = 0; i < num; i++)
            {
                 m = vecNode[i];
                 
                 graphics.moveTo(m.cx, m.cy);
                 
                 kx = Math.cos(m.cang);
                 ky = Math.sin(m.cang);
                 
                 graphics.lineTo(m.cx+kx*m.size, m.cy+ky*m.size);
                 
                 
                 graphics.moveTo(m.tx, m.ty);
                 kx = Math.cos(m.tang);
                 ky = Math.sin(m.tang);
                 graphics.lineTo(m.tx+kx*m.size, m.ty+ky*m.size);
                 
                
            }//nexti
            
            
        }//onenter
        
        
    }//classend
}

internal class xNode
{
    public var cx:Number = 0;
    public var cy:Number = 0;
    public var cang:Number = 0;
    
    public var tx:Number =0;
    public var ty:Number =0;
    public var tang:Number = 0;
    
    public var rad:Number = 8;
    public var size:Number = 16;
    
    public var depth:int = 0;
    public var parent:xNode = null;
    
    
}//xnode


internal class xPoint
{
    public var cx:Number = 0;
    public var cy:Number = 0;
    public var node:xNode = null;
    
    public function xPoint(x:Number=0, y:Number=0) { cx = x; cy =y; }
    
}//xpoint