/**
 * Copyright Kay ( http://wonderfl.net/user/Kay )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8FJp
 */

/*
 * 深度テスト
 * 視点からの距離でソートしてるつもり。。。
 * 全部を一度にソートしないで２つのグルーブにわけてソートしたのがミソ
 * Group1:床、壁、天井の大きな板と“人がいるシーン”
 * Group2:シーン内の人とテーブル
 *-----------------------------------------
 * 若干ですが誤った表示になってしまいます。
 */


package {
	import flash.display.*;
	import flash.events.*;
	import flash.filters.BlurFilter;
	import flash.geom.*;

	[SWF(frameRate="30",width="465",height="465")]
	public class Main extends Sprite {
		private const SW:Number=stage.stageHeight;
		private const SH:Number=stage.stageWidth;
		public var pp:PerspectiveProjection;
		public var room:Sprite;
		public var wrap:Sprite;
		public var objs:Array;
		public var wall:Sprite;
		public var scene:Sprite;

		public function Main() {
			pp=transform.perspectiveProjection;
			pp.projectionCenter=new Point(SW/2,SH/2);
			pp.fieldOfView=45;

			room = new Sprite();
			addChild(room);
			room.x=SW/2;
			room.y=SH/2;

			var floor:Sprite = new Sprite();
			floor.graphics.beginFill(0x66ff99);
			floor.graphics.drawRect(-200, -200, 400, 400);
			floor.graphics.drawCircle(0, 0, 50);
			floor.graphics.endFill();
			floor.z=0;
			floor.y=100;
			floor.rotationX=90;
			room.addChild(floor);

			var roof:Sprite = new Sprite();
			roof.graphics.beginFill(0x99ccff);
			roof.graphics.drawRect(-200, -200, 400, 400);
			roof.graphics.drawCircle(0, 0, 140);
			roof.graphics.drawCircle(0, 0, 120);
			roof.graphics.endFill();
			roof.z=0;
			roof.y=-100;
			roof.rotationX=90;
			room.addChild(roof);
			
			wall = new Sprite();
			var vs:Vector.<Number> = new Vector.<Number>();
			var ind:Vector.<int> = new Vector.<int>();
			vs.push(-200,-100, 200,-100, 200,100, -200,100);
			ind.push(0,1,2, 2,3,0);
			wall.graphics.beginFill(0x7777ff);
			wall.graphics.drawRect(-200, -100, 400, 200);
			wall.graphics.drawRect(-95, -80, 90, 120);
			wall.graphics.drawRect(5, -80, 90, 120);
			wall.graphics.endFill();
			wall.z=200;
			room.addChild(wall);
			
			scene = new Sprite();
			scene.z = 0;
			room.addChild(scene);

			var man1:Man = new Man(0xcc0000);
			man1.z = -80;
			man1.y = -50;
			scene.addChild(man1);

			var man2:Man = new Man(0x0000cc);
			man2.x = -80;
			man2.y = -50;
			man2.rotationY = 90;
			scene.addChild(man2);

			var man3:Man = new Man(0xffff00);
			man3.z = 80;
			man3.y = -50;
			scene.addChild(man3);

			var man4:Man = new Man(0x00cc00);
			man4.x = 80;
			man4.y = -50;
			man4.rotationY = 90;
			scene.addChild(man4);

			var table:Sprite = new Sprite();
			table.graphics.beginFill(0x000000);
			table.graphics.drawCircle(0, 0, 50);
			table.graphics.endFill();
			table.z=0;
			table.y=60;
			table.rotationX=90;
			scene.addChild(table);
			
			addEventListener(Event.ENTER_FRAME, xEyePoint);
		}
		public function xEyePoint(e:Event):void {
			pp.projectionCenter=new Point(SW/2,mouseY);
			var eyePoint:Vector3D = new Vector3D(SW/2, mouseY, -pp.focalLength);
			
			room.rotationY += (mouseX / SW * 480 - room.rotationY) * 0.1;

			var arr:Array=[];
			for (var i:int=0; i<room.numChildren; i++) {
				var elm:Sprite=room.getChildAt(i) as Sprite;
				var v3:Vector3D=elm.transform.getRelativeMatrix3D(root).position;
				var dist:Number = Vector3D.distance(v3,eyePoint);
				arr.push( { elm:elm, dist:dist } );
			}
			arr.sortOn("dist", Array.NUMERIC | Array.DESCENDING);
			for (i=0; i<arr.length; i++) {
				elm=arr[i].elm as Sprite;
				room.setChildIndex(elm, i);
			}
			
			var sArr:Array=[];
			for (i=0; i<scene.numChildren; i++) {
				elm=scene.getChildAt(i) as Sprite;
				v3=elm.transform.getRelativeMatrix3D(root).position;
				dist = Vector3D.distance(v3,eyePoint);
				sArr.push( { elm:elm, dist:dist } );
			}
			sArr.sortOn("dist", Array.NUMERIC | Array.DESCENDING);
			for (i=0; i<sArr.length; i++) {
				elm=sArr[i].elm as Sprite;
				scene.setChildIndex(elm, i);
			}
		}

	}
}

import flash.display.*;
class Man extends Sprite {
	public function Man(color:int=0):void  {
		graphics.beginFill(color);
		graphics.drawCircle(0, 15, 15);
		graphics.drawRect(-20, 30, 40, 120);
		graphics.endFill();
	}
}
