/**
 * Copyright fakestar0826 ( http://wonderfl.net/user/fakestar0826 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8F8t
 */

// forked from ProjectNya's SeparationRGB (5)
////////////////////////////////////////////////////////////////////////////////
// SeparationRGB (5)
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.display.Loader;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BitmapDataChannel;
    import flash.display.BlendMode;
    import flash.events.Event;
    import flash.net.URLRequest;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.system.LoaderContext;

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var loader:Loader;
        private var content:Bitmap;
        private var bitmap:Bitmap;
        private var bitmapData:BitmapData;
        private static var basePath:String = "http://assets.wonderfl.net/images/related_images/";
        private static var photoPath:String = "b/b9/b903/b903a19502c9c61a3eac08d38e3e3ed5838f6dc8";
        private var containers:Array;

        public function Main() {
            //Wonderfl.capture_delay(1);
            init();
        }

        private function init():void {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            //
            loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.INIT, initialize, false, 0, true);
            //loader.contentLoaderInfo.addEventListener(Event.COMPLETE, complete, false, 0, true);
            loader.load(new URLRequest(basePath + photoPath), new LoaderContext(true));
            //
            containers = new Array();
            bitmapData = new BitmapData(400, 400, false, 0xFF000000);
            bitmap = new Bitmap(bitmapData);
            bitmap.x = 32;
            bitmap.y = 32;
            //addChild(bitmap);
            //containers.push(bitmap);
        }
        private function initialize(evt:Event):void {
            content = evt.target.content;
            var bd:BitmapData = content.bitmapData;
            var bw:Number = 400/bd.width;
            var bh:Number = 400/bd.height;
            var scale:Number = Math.min(bw, bh);
            var matrix:Matrix = new Matrix();
            matrix.scale(scale, scale);
            bitmapData.draw(bd, matrix, null, null, null, true);
            bitmap.bitmapData = bitmapData;
            //
            separate(bitmapData);
        }
        private function separate(bd:BitmapData):void {
            var r:BitmapData = new BitmapData(400, 400, false, 0xFF000000);
            var g:BitmapData = new BitmapData(400, 400, false, 0xFF000000);
            var b:BitmapData = new BitmapData(400, 400, false, 0xFF000000);
            r.copyChannel(bd, bd.rect, new Point(), BitmapDataChannel.RED, BitmapDataChannel.RED);
            g.copyChannel(bd, bd.rect, new Point(), BitmapDataChannel.GREEN, BitmapDataChannel.GREEN);
            b.copyChannel(bd, bd.rect, new Point(), BitmapDataChannel.BLUE, BitmapDataChannel.BLUE);
            //
            var rb:Bitmap = new Bitmap(r);
            var gb:Bitmap = new Bitmap(g);
            var bb:Bitmap = new Bitmap(b);
            rb.x = 32;
            rb.y = 32;
            gb.x = 32;
            gb.y = 32;
            bb.x = 32;
            bb.y = 32;
            rb.blendMode = BlendMode.SCREEN;
            gb.blendMode = BlendMode.SCREEN;
            bb.blendMode = BlendMode.SCREEN;
            //
            addChild(bb);
            addChild(gb);
            addChild(rb);
            //
            containers.push(rb);
            containers.push(gb);
            containers.push(bb);
            //addEventListener(Event.ENTER_FRAME, update, false, 0, true);
        }
        private function update(evt:Event):void {
            for (var n:uint = 0; n < 4; n++) {
                var container:Bitmap = containers[n];
                container.x = 32 + (Math.random() - 0.5)*20;
                container.y = 32 + (Math.random() - 0.5)*20;
            }
        }

    }

}
