/**
 * Copyright Linkforce ( http://wonderfl.net/user/Linkforce )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8F6X
 */

package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.DisplayObject;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.display.Stage;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.utils.Dictionary;
    
    [SWF(frameRate = 60 , backgroundColor = 0x000000)]
    
    public class WorkStation extends Sprite
    {
        
        private const NUM_PARTICLES:Number = 300;
        private const TWO_PI:Number = 2*Math.PI;
        
        private var _objects:Dictionary = new Dictionary;        
        private var _sprites:Dictionary = new Dictionary;
        
        private var _objectCount:int = 0;
        private var _canvas:BitmapData;
        private var _screen:Bitmap;
        
        //==== Assets
        private function circle(r:int = 5, c:uint = 0xFFFFFF):BitmapData{
            
            var disp:Sprite = new Sprite;
            var grap:Graphics = disp.graphics;
            var bmpd:BitmapData;
            var matr:Matrix;
            
            grap.beginFill(c);
            grap.drawCircle(r,r,r);
            grap.endFill();
            
            return convertToBitmapData(disp);
        }
        
        private function particle(c:uint):BitmapData{
            var disp:Sprite = new Sprite;
            var grap:Graphics = disp.graphics;
            var bmpd:BitmapData;
            var matr:Matrix;
            
            grap.beginFill(c);
            grap.drawRect(0,0,1,1);
            grap.endFill();
            
            return convertToBitmapData(disp);
            
        }
        
        //====
        
        public function WorkStation()
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align        = StageAlign.TOP_LEFT;
            stage.quality   = StageQuality.HIGH;
            init();
            
        }
        
        
        
        public function init():void{
            setDisplay();
            stage.addEventListener(Event.ENTER_FRAME, onFrame);
            stage.addEventListener(Event.RESIZE, onResize);
            startup();
            
            function onFrame(e:Event):void{
                dataUpdate();
                dispUpdate();
            }
            
            function onResize(e:Event):void{
                trace("resized!", stage.stageWidth, stage.stageHeight);
                setDisplay();
            }
        }
        
        public function setDisplay():void{
            if(_canvas)_canvas.dispose();
            _canvas = null;
            
            _canvas = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x00000000);
            _screen = new Bitmap(_canvas);
            
            stage.addChild(_screen);
            dispUpdate();
        }
        
        
        private var bossID:String;
        private function startup():void{
            // Create Objects
            
            //Boss
            var boss:Object;
            
            boss = generateObject("boss", bossUpdate, bossRender);
            bossID = boss.id;
            _sprites[bossID] = circle(10, 0x0000FF);
            
            function bossUpdate(obj:Object):void{
                var i:int = 0;
                //Movement Vars
                if(!obj.moveCounter) obj.moveCounter = 0;
                if(!obj.moveQueue)   obj.moveQueue   = 120;
                if(!obj.destX1)         obj.destX1      = stage.stageWidth * (1/3);
                if(!obj.destX2)         obj.destX2      = stage.stageWidth * (2/3);
                if(!obj.destY1)         obj.destY1      = 100;
                if(!obj.destY2)         obj.destY2      = 100;
                if(!obj.currTarg)    obj.currTarg     = {"destX" : obj.destX2, "destY" : obj.destY2};
                
                //First shot type
                
                if(!obj.fire1Counter) obj.fire1Counter     =  0;
                if(!obj.fire1Queue)      obj.fire1Queue       = 15;
                if(!obj.numFire1)      obj.numFire1         = 20;
                if(!obj.fireSpawnRad) obj.fire1SpawnRad    = 10;
                if(!obj.fire1Tally)      obj.fire1Tally       =  0;
                
                if(!obj.inited){
                    obj.x = obj.destX1;
                    obj.y = obj.destY1;
                    obj.inited = true;
                }
                
                //Boss Movement
                if(obj.moveCounter >= obj.moveQueue){
                    obj.x += tweenTo(obj.currTarg.destX, obj.x, 50);
                    obj.y += tweenTo(obj.currTarg.destY, obj.y, 50);
                    
                    if(inBounds(obj.x, obj.currTarg.destX, 5) && inBounds(obj.y, obj.currTarg.destY, 5)){
                        obj.x = obj.currTarg.destX;
                        obj.y = obj.currTarg.destY;
                        
                        obj.currTarg.destX = (obj.currTarg.destX == obj.destX1) ? obj.destX2 : obj.destX1;  
                        obj.currTarg.destY = (obj.currTarg.destY == obj.destY1) ? obj.destY2 : obj.destY1;
             
                        obj.moveCounter = 0;
                    }
                } else {
                    obj.moveCounter++;
                }
                
                //Boss firing shottype 1
                if(obj.fire1Counter >= obj.fire1Queue){
                    trace("FIRE");
                    var dir:int = obj.fire1Tally % 2 == 0 ? -1 : 1; 
                    for(i = 0; i < obj.numFire1; i++){
                        var fire1:Object = generateObject("fireOne", particleUpdate, render);
                        _sprites[fire1.id] = circle(2,0x000000);
                        fire1.origin = {"x":obj.x, "y":obj.y};
                        fire1.radius = obj.fire1SpawnRad;
                        fire1.angle  = i / obj.numFire1;
                        fire1.x      = obj.x + Math.cos(fire1.angle * TWO_PI) * fire1.radius;
                        fire1.y      = obj.y + Math.sin(fire1.angle * TWO_PI) * fire1.radius;
                        fire1.dir    = dir;
                        fire1.accX   = (fire1.x - obj.x) / 100;
                        fire1.accY   = (fire1.y - obj.y) / 100;
                    }
                    obj.fire1Tally++;
                    obj.fire1Counter = 0;
                } else {
                    obj.fire1Counter ++ ;
                }
                
            }
            
            function particleUpdate(obj:Object):void{
                if(obj.x > stage.stageWidth || obj.x < -(stage.stageWidth) || obj.y > stage.stageHeight || obj.y < -(stage.stageHeight)){
                    destroy(obj.id);
                    return;
                }
                
                if(!obj.angleStep)      obj.angleStep      = .002;
                if(!obj.radiusStep)     obj.radiusStep     = .5;
                if(!obj.maxMagnitude)   obj.maxMagnitude   = -5;
                if(!obj.vector1)    obj.vector0    = {"vx":obj.accX, "vy":obj.accY};
                if(!obj.vector2)    obj.vector1    = {"vx":       0, "vy":       0};
                if(!obj.vector3)    obj.vector2    = {"vx":       0, "vy":       0};
                
                obj.angle += obj.angleStep * obj.dir;
                obj.radius-= obj.radiusStep;
                
                if(obj.radius < obj.maxMagnitude){
                    obj.radius = obj.maxMagnitude;
                }
                
                obj.vector0.vx = obj.x - (obj.x + Math.cos(obj.angle * TWO_PI) * obj.radius);
                obj.vector0.vy = obj.y - (obj.y + Math.sin(obj.angle * TWO_PI) * obj.radius);
                
                //obj.vx += obj.accX + obj.xOffset;
                //obj.vy += obj.accY;
                
                obj.x += obj.vector0.vx;
                obj.y += obj.vector0.vy;
                
            }
            
            function bossRender(screen:BitmapData, sprite:BitmapData, obj:Object):void{
                screen.copyPixels(sprite, screen.rect, new Point(obj.x - sprite.width/2, obj.y - sprite.width/2));
            }
            
            function render(screen:BitmapData, sprite:BitmapData, obj:Object):void{
                screen.copyPixels(sprite, screen.rect, new Point(obj.x - sprite.width/2, obj.y - sprite.width/2));
            }
            
        }
        
        private function destroy(id:String):void{
            delete _sprites[id];
            delete _objects[id];
        }
        
        private function inBounds(currPos:Number, dest:Number, range:Number):Boolean{
            return (currPos > dest - range && currPos < dest + range);
        }
        
        private function tweenTo(dest:Number, orig:Number, coeff:Number = 10):Number{
            return (dest - orig) / coeff;
        }
        
        private function dataUpdate():void{
            var k:String;
            var num:int = 0;
            for(k in _objects){
                _objects[k].update(_objects[k]);
                num++;
            }
            
            trace("Number of objects onscreen: " + num);
        }
        
        private function dispUpdate():void{
            var k:String;
            var display:BitmapData = new BitmapData(_canvas.width, _canvas.height, true, 0x00000000);
            
            _canvas.lock();
            
            display.lock();
            for(k in _sprites){
                _objects[k].render(display, _sprites[k], _objects[k]);
            }
            display.unlock();
            
            _canvas.copyPixels(display, display.rect, new Point);
            _canvas.unlock();
            
            display.dispose();
            display = null;
        }
        
        
        public function convertToBitmapData(d:DisplayObject):BitmapData{
            var matr:Matrix     = new Matrix();
            var rect:Rectangle  = d.getRect(stage.root);
            var bmpd:BitmapData 
            
            bmpd = new BitmapData(rect.width, rect.height, true, 0x000000);
            bmpd.draw(d, matr);
            
            return bmpd;
        }
        
        public function generateObject(type:String, update:Function, render:Function):Object{
            var obj:Object = new Object;
            
            obj.id     = generateID(type);
            obj.update = update;
            obj.render = render;
            obj.x      = 0;
            obj.y      = 0;
            obj.vx     = 0;
            obj.vy     = 0;
            obj.acc       = Math.random() * .2;
            obj.angle  = 0;
            obj.weight = Math.random() * .2;
            
            
            
            _objects[obj.id] = obj;
            return obj;
            
            function generateID(t:String):String{
                var iter:int = 0;
                
                while(true){
                    if(!_objects[t + iter]){
                        return String(t + iter);
                    } else {
                        iter++;
                    }
                }
                
                return "invalid_name"; //this should never hit
            }
        }
        
    }
}