/**
 * Copyright yprops ( http://wonderfl.net/user/yprops )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8EsL
 */

// forked from yprops's テキスト表示用
package
{
    import flash.net.SharedObject;
    import flash.utils.*;
    import flash.events.*;
    import flash.display.*;
    import flash.text.*;
    
    public class DebugText extends Sprite
    {
        
        
        //------------main-----------------------
        
        
        public function main() :void{
            var so :SharedObject, ba0 :ByteArray, obj :*;
            var resource :*;
            
            //-----------------
            addDebLine("\n■ローカルのSharedObjecから読み込み");
            try{
                so = SharedObject.getLocal("local");
            }catch(er:Error){
                addDebLine(er);
                return;
            }
            ba0 = so.data.ba0 as ByteArray;
            if(ba0){
                ba0.uncompress();
                resource = ba0.readObject();
            }
            traceObj(resource);
            
            //------------------
            addDebLine("\n■新規に保存用オブジェクト作成");
            resource = {
                obj0 :{
                    child0 :100, child1 :"入れ子情報"
                },
                rndnum:Math.random(), val2:true,
                mc0 :new MovieClip(), sp0 :new Sprite(),
                count : (!resource || !resource.hasOwnProperty("count"))? 0 : resource.count + 1
            };
            traceObj(resource);
            
            //-------------------
            addDebLine("\n■オブジェクトを圧縮してSharedObjectに保存");
            ba0 = new ByteArray();
            ba0.writeObject(resource);
            addDebLine(ba0.length, "圧縮前サイズ");
            ba0.compress();
            addDebLine(ba0.length, "圧縮");
            
            so.data.ba0 = ba0;
            so.flush();
            
            //-------------------
            addDebLine("\n\n■備考：\n※マウスホイールでスクロールします");
            addDebLine("※wonderflは裏で一度再生している？count値が飛ぶ。");
        }
        private function traceObj(o:*) :void{
            addDebLine("----オブジェクトの中身をチェック");
            traceObjSub(o,"\t");
            addDebLine("----\n");
        }
        
        
        //出力用-----------------------------
        
        private function traceObjSub(o :*, tab :String) :void{
            var s :String, c :*;
            for(s in o){
                c = o[s];
                if(c is Number || c is String || c is Boolean){
                    addDebLine(tab + s, c);
                    continue;
                }
                addDebLine(tab + s, "{");
                traceObjSub(c, tab + "\t");
                addDebLine(tab + "}");
            }
        }


        
        
        
        //------------general---------------------
        public function DebugText(){
            if(stage)init();
            addEventListener(Event.ADDED_TO_STAGE, init);
        }
        private function init(ev:Event = null) :void{
            removeEventListener(Event.ADDED_TO_STAGE, init);
            addDeb(450, 450);
            main();
        }
        private var deb :TextField;
        private function addDeb(w:uint, h:uint) :void{
                deb = new TextField();
                deb.wordWrap = true;
                deb.width = w;
                deb.height = h;
                deb.border = true;
                deb.borderColor = 0;
                deb.background = true;
                deb.backgroundColor = 0x99ffffff;
                deb.text = "beginDebugText-------\n\n";
                addChild(deb);
        }
        private function addDebLine(...args) :void{
                deb.appendText(args.join(" ") + "\n");
                deb.scrollV = deb.maxScrollV;
        }
    }
}