/**
 * Copyright hacker_xaotp5zq ( http://wonderfl.net/user/hacker_xaotp5zq )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8ENZ
 */

// forked from clockmaker's [PV3D]親子構造で回転
package {
    import flash.display.Sprite;
    import flash.events.*;
    
    import org.papervision3d.view.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.special.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.objects.*;
    
    public class FlashTest extends BasicView {
        
        private var obj:DisplayObject3D;
        private var plane:Plane;
        
        public function FlashTest() {
            // 適当にマテリアル(コンポジットマテリアル)
            var m:CompositeMaterial = new CompositeMaterial();
            m.addMaterial(new WireframeMaterial(0xFF0000));
            m.addMaterial(new ColorMaterial(0x0));
            m.doubleSided = true;
            
            //親のDisplayObject3Dを作成
            obj = new DisplayObject3D();
            scene.addChild(obj);
            
            // 子のPlaneを作成
            plane = new Plane(m, 800, 800, 5, 5);
            plane.rotationZ = 45; // Z回転を45°
            
            // 親に子を追加
            obj.addChild(plane);
            
            startRendering();
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function loop(e:Event):void{
            // 親のY回転
            obj.rotationY += 2;
        }
    }
}