/**
 * Copyright fukt ( http://wonderfl.net/user/fukt )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8DMD
 */

// forked from sakusan393's Right Angle Walker
package  
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.utils.getTimer;
    
    /**
     * ...
     * @author 393
     */
    
    [SWF(width = "465", height = "465", backgroundColor = "0x0", frameRate = "60")];
    public class Dot extends Sprite
    {
        private var _w:int, _h:int;
        private var _count:int = 1;
        private var _offsetX:int,_offsetY:int;
        private var _countIndex:int = 2 , _checkIndex:int= 2;
        private var _ratio:int = 1;
        private var _power:int = 10;

        private var _point:Point;
        private var _marker:Sprite;
        private var _tf:TextField;
        private var _bm:Bitmap;
        private var _bmd:BitmapData;
        private var _copyBmd:BitmapData;
        private var _isPlus:Boolean = true;
        private var _isPlaying:Boolean = false;
        private var _time:Number;
        
        public function Dot() 
        {
            Wonderfl.capture_delay( 10 );
            _w = stage.stageWidth;
            _h = stage.stageHeight;
            
            _bmd = new BitmapData(_w, _h, false, 0);
            _point = new Point(_w / 2, _h / 2);
            _bm = Bitmap(addChild(new Bitmap(_bmd)));
            
            //ゴールの設定
            var goal:Sprite = new Sprite();
            goal.graphics.beginFill(0xFF0000);
            goal.graphics.drawRect(455, 455, 10, 10);
            goal.graphics.endFill();
            _bmd.draw(goal);
            //ゴール付きフィールドの保持
            _copyBmd = _bmd.clone();
            //自機マーカー
            _marker = new Sprite();
            _marker.graphics.beginFill(0x9999FF);
            _marker.graphics.drawCircle(0, 0, 5);
            _marker.graphics.endFill();
            this.addChild(_marker);
            _marker.x = _marker.y= _w / 2;
            //テキスト
            _tf = new TextField();
            _tf.autoSize = "left";
            _tf.defaultTextFormat = new TextFormat("_ゴシック", 20, 0xFFFFFF, true);
            _tf.textColor = 0xFFFFFF;
            _tf.text = "Induce BlueCircle to the RedSquareArea.\n\nclick to start ";
            _tf.x = 10
            _tf.y = 10;
            this.addChild(_tf);
            stage.addEventListener(MouseEvent.CLICK, clickHandler);
        }
        
        private function clickHandler(e:MouseEvent):void 
        {
            if (_isPlaying) return;
            _time = getTimer() / 1000;
            _isPlaying = true;
            _bm.alpha = 1;
            _bmd.draw(_copyBmd);
            _point.x = _point.y = _w / 2;
            _offsetX = _offsetY = 0;
            _checkIndex = _countIndex = 2;
            _count = 1;
            this.addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }
        
        private function enterFrameHandler(e:Event):void 
        {
            _tf.text = (getTimer() / 1000 - _time).toFixed(3);
            _power = mouseX / 100 + 1;
            if (_count % _checkIndex == 0) {
                _checkIndex += (_countIndex * 2);
                _countIndex++;
                _isPlus = !_isPlus;
            }
            if (_isPlus) _ratio = _power;
            else _ratio = -_power;
            
            _offsetX = _offsetY = 0;
            if (_count < _checkIndex - _countIndex-1) _offsetX = 1 * _ratio
            else _offsetY = 1 * _ratio;
            
            _point.x += _offsetX;
            _point.y += _offsetY;
            _marker.x = _point.x;
            _marker.y = _point.y;
            if (_point.x > _w || _point.y > _h || _point.x < 0 || _point.y < 0) endGame(false);
            if (0xFF0000 == _bmd.getPixel(_point.x, _point.y)) endGame(true);
            _bmd.setPixel(_point.x, _point.y, 0xFFFFFF);
            _count++;
        }
        private function endGame(isClear:Boolean):void
        {
            _isPlaying = false;
            _bm.alpha = .4;
            this.removeEventListener(Event.ENTER_FRAME, enterFrameHandler);
            if (isClear) _tf.text = "CLEAR !\nTime:"+_tf.text+"sec\n\nclick to restart";
            else _tf.text = "GAME OVER \n\nclick to restart";
        }
        
    }

}