/**
 * Copyright FlashBum ( http://wonderfl.net/user/FlashBum )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8DJE
 */

package  
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.BlendMode;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.events.IOErrorEvent;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;
	import flash.utils.Dictionary;
 
	/**
	 * @author Jesse Freeman aka @theFlashBum | http://jessefreeman.com
	 */
	public class PhotoCompositionSandbox extends Sprite 
	{
 
		private static const PHOTO : String = "photo";
		private static const MASK : String = "mask";
		private static const TEXTURE : String = "texture";
		private static const EDGES_MASK : String = "edges_mask";
		private static const BASE_URL : String = "http://demos.flashartofwar.com/RandomImageComposite/images/skin"+Math.round(Math.random()*5+1)+"/";
		private var loader : Loader = new Loader( );
		private var currentlyLoading : Object;
		private var preloadList : Array = new Array( {name:MASK, src:"photo_mask.png"}, {name:PHOTO, src:"photo.jpg"}, {name:TEXTURE, src:"photo_texture.jpg"}, {name:EDGES_MASK, src: "photo_edges_mask.png"} );
		private var layers : Dictionary = new Dictionary( true );
		private var context : LoaderContext;
 
		public function PhotoCompositionSandbox()
		{
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
 
			context = new LoaderContext( );
			context.checkPolicyFile = true;
 
			preload( );
		}
 
		/**
		 * Handles preloading our images. Checks to see how many are left then
		 * calls loadNext or compositeImage.
		 */
		protected function preload() : void
		{
			if (preloadList.length == 0)
			{
				compositeImage( );
			}
			else
			{
				loadNext( );
			}
		}
 
		/**
		 * Loads the next item in the prelaodList
		 */
		private function loadNext() : void
		{
			currentlyLoading = preloadList.shift( );
			loader.contentLoaderInfo.addEventListener( Event.COMPLETE, onLoad );
			loader.contentLoaderInfo.addEventListener( IOErrorEvent.IO_ERROR, onError );
 
			loader.load( new URLRequest( BASE_URL + currentlyLoading.src ), context );
		}
 
		private function onError(event : IOErrorEvent) : void
		{
			trace("IOErrorEvent", event );
			preload();
		}
 
		/**
		 * Handles onLoad, saves the BitmapData then calls preload
		 */
		private function onLoad(event : Event) : void
		{
			loader.contentLoaderInfo.removeEventListener( Event.COMPLETE, onLoad );
 
			layers[currentlyLoading.name] = Bitmap( event.target.content ).bitmapData;
 
			currentlyLoading = null;
 
			preload( );
		}
 
		/**
		 * Composit image
		 */
		private function compositeImage() : void
		{
			// Create Bitmap data for final image
			var bmd2 : BitmapData = new BitmapData( layers[PHOTO].width, layers[PHOTO].height, true, 0xffffff );
 
			// Get width and height for cutting out image
			var rect : Rectangle = new Rectangle( 0, 0, layers[PHOTO].width, layers[PHOTO].height );
			var pt : Point = new Point( 0, 0 );
 
			// This is our container while we apply the texture
			var imageComposit : BitmapData = new BitmapData( layers[PHOTO].width, layers[PHOTO].height, true, 0xffffff );
 
			// Copy pixel data from the photo over to the container using the layers[MASK] to cut out the shape
			imageComposit.copyPixels( layers[PHOTO], rect, pt, layers[MASK], null, true );
 
			if(layers[TEXTURE])
			{
				// Draw on top of container with the texture and apply Darken + Multiply blend modes
				imageComposit.draw( layers[TEXTURE], null, null, BlendMode.MULTIPLY, null, true );
				imageComposit.draw( layers[TEXTURE], null, null, BlendMode.MULTIPLY, null, true );
				imageComposit.draw( layers[TEXTURE], null, null, BlendMode.MULTIPLY, null, false );
			}
 
			if(layers[EDGES_MASK])
			{
				// Copy the edges on top of the the entire compisited image 
				imageComposit.copyPixels( layers[TEXTURE], rect, pt, layers[EDGES_MASK], null, true );
			}
 
			// Copy over the composite image to the BitmapData using the mask to cut out it's shape
			bmd2.copyPixels( imageComposit, rect, pt, layers[MASK], null, true );
 
			// Create Bitamp to test display and add to stage
			var bm2 : Bitmap = new Bitmap( bmd2 );
			addChild( bm2 );
			bm2.x = 50;
			bm2.y = 50;
		}
	}
}