/**
 * Copyright miyaoka ( http://wonderfl.net/user/miyaoka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8D7x
 */

// forked from miyaoka's still alive
package 
{
	import flash.display.Sprite;
	
	[SWF(width="465", height="465", backgroundColor= 0x000000, frameRate="60")]
	
	public class Main
	extends Sprite
	{
		public function Main():void 
		{
			
			//make a cube
			var cube:Cube = new Cube();
			cube.x = stage.stageWidth * 0.5;
			cube.y = stage.stageHeight * 0.5;
			addChild(cube);
			
		}
	}	
}
import flash.display.Sprite
import caurina.transitions.Tweener
import flash.utils.Timer;
import flash.events.TimerEvent;

class Cube
extends Sprite
{
	private var wordsContainer:Sprite;
	public function Cube():void 
	{
		wordsContainer = new Sprite;
		addChild(wordsContainer);
		
		var heart:Heart = new Heart;

		addChild(heart);
		
		rotCompleteHandler();
	}

	public function listen(word_:String):void 
	{
		var word:Words = new Words(word_, 180);
		wordsContainer.addChild(word);
		word.rotation = -rotation;

		var timer:Timer = new Timer(word_.length * 20 + 1200);
		timer.addEventListener(TimerEvent.TIMER, rotTimerHandler,false,0,false);
		timer.start();

		if(4 < wordsContainer.numChildren) wordsContainer.removeChildAt(0);
	}
	private function rotTimerHandler(evt:TimerEvent):void
	{
		evt.target.stop();
		Tweener.addTween(this, {
			rotation: rotation - 90,
			time: 0.5,
			transition: "easeOutBack",
			onComplete: rotCompleteHandler
		});
		
		if (3 < wordsContainer.numChildren)
		{
			Tweener.addTween(wordsContainer.getChildAt(0), {
				alpha: 0,
				scaleX: 0,
				scaleY: 0,
				time: 1.8,
				transition: "easeOutQuint"
			});
		}
	}
	public function rotCompleteHandler():void 
	{
		if (GLaDOS.isStillAlive()) listen(GLaDOS.Sings());
	}
}

class Heart
extends Sprite
{
	public function Heart():void 
	{
		var radius:Number = 10;
		graphics.beginFill(0x999999);
		graphics.drawCircle( 0, 0, radius*3); 
		graphics.endFill();
		
		graphics.beginFill(0xffccff);
		graphics.drawCircle( -radius*0.9, -radius*0.4, radius); 
		graphics.endFill();
		
		graphics.beginFill(0xffccff);
		graphics.drawCircle( radius*0.9, -radius*0.4, radius); 
		graphics.endFill();
		
		graphics.beginFill(0xffccff);
		graphics.moveTo(0, radius * 2);
		graphics.lineTo( -radius * 1.85, 0);
		graphics.lineTo(radius * 1.85, 0);
		graphics.endFill();
		
		scaleX = scaleY = 1.5;
//		heartScaleUp();
	}
	private var scaleUp:Number = 1.0;
	private var scaleDown:Number= 0.9;
	
	private function heartScaleUp():void 
	{
		Tweener.addTween(this, {
			scaleX: scaleUp,
			scaleY: scaleUp,
			time: 0.5,
			transition: "easeOutBack",
			onComplete: heartScaleDown
		});		
	}
	private function heartScaleDown():void 
	{
		Tweener.addTween(this, {
			scaleX: scaleDown,
			scaleY: scaleDown,
			time: 0.5,
			transition: "easeOutBack",
			onComplete: heartScaleUp
		});		
	}
}

import flash.text.TextField;
import flash.text.TextFormat;
import flash.geom.Rectangle;
class Words
extends Sprite
{
	private var wordsIdx:uint = 0;
	private var words:String;
	private var wordScale:Number;
	private var tfd:TextField;
	private var center:Number;
	public function Words(words_:String, center_:Number):void 
	{
		words = words_;
		center = center_;
		
		tfd = new TextField();
		tfd.defaultTextFormat = new TextFormat("Arial Black", 10);  
		tfd.textColor = 0xcc9900;  
		tfd.autoSize = "left"; 
		tfd.text = words;

		wordScale = (center * 2 -60) / tfd.width;

		var timer:Timer = new Timer(10);
		timer.addEventListener(TimerEvent.TIMER, timerHandler,false,0,false);
		timer.start();
	}
	private function timerHandler(evt:TimerEvent):void 
	{	
		if (wordsIdx >= words.length)
		{
			evt.target.stop();
			return;
		}
		
		var bounds:Rectangle = tfd.getCharBoundaries(wordsIdx);		
		var word:Word = new Word(words.charAt(wordsIdx));
		
		
		word.height = 60;
		word.scaleX = wordScale;
		word.x = word.y = -center;

		word.x += bounds.x * wordScale;
		addChild(word);
		
		word.y += 100;
		
		Tweener.addTween(word, {
			y: word.y - 100 - word.height * (1.0 + Math.random()*0.1),
			time: 0.2 + Math.random() * 0.05 + 0.01 * (words.length - wordsIdx),
			transition: "easeOutQuart",
			onComplete: jumpupCompleteHandler,
			onCompleteParams: [word]
		});
		
		wordsIdx++;
	}
	private function jumpupCompleteHandler(word:Word):void 
	{
		Tweener.addTween(word, {
			y: word.y + word.height * 1.0,
			time: 0.8 + Math.random() * 0.2,
			transition: "easeOutBounce"
		});
	}
}

import flash.display.BitmapData;
import flash.display.Bitmap;

class Word
extends Sprite
{
	public function Word(word:String):void 
	{
		var tfd:TextField = new TextField();
		tfd.defaultTextFormat = new TextFormat("Arial Black", 10);  
		tfd.textColor = 0xcc9900;  
		tfd.autoSize = "left"; 
		tfd.text = word;
		
		var bd:BitmapData = new BitmapData(tfd.width, tfd.height, true, 0xff0000); 
		bd.draw(tfd);
		addChild(new Bitmap(bd));
	}
}

class GLaDOS
{
	public static function isStillAlive():Boolean
	{
		return noteLine < notes.length;
	}
	public static function SingsTo(cube:Cube):void 
	{
//		cube.listen(notes[notes.length - 1 - noteLine++] );
		cube.listen(notes[noteLine++] );
	}
	public static function Sings():String
	{
		return notes[noteLine++];
	}
	
	private static var noteLine:uint = 0;
	private static var notes:Array = [

		//"Froms FROM-29827281-12:",
		//"Test Assessment Report",


		"This was a triumph.",
		"I'm making a note here:",
		"HUGE SUCCESS.",
		"It's hard to overstate my satisfaction.",
		"Aperture Science",
		"We do what we must",
		"because we can.",
		"For the good of all of us.",
		"Except the ones who are dead.",


		"But theres no sense",
		"crying over every mistake.",
		"You just keep on trying",
		"till you run out of cake.",
		"And the Science gets done.",
		"And you make a neat gun.",
		"For the people who are still alive.",



		//"Froms FROM-55551-5:",
		//"Personnel File Addendum:",
//
		//"Dear <<Subject Name Here>>,",


		"I'm not even angry.",
		"I'm being so sincere right now.",
		"Even though you broke my heart.",
		"And killed me.",
		"And tore me to pieces.",
		"And threw every piece into a fire.",
		"As they burned it hurt",
		"because I was so happy for you!",
		"Now these points of data",
		"make a beautiful line.",
		"And we're out of beta.",
		"We're releasing on time.",
		"So I'm GLaD.",
		"I got burned.",
		"Think of all the things we learned",
		"for the people who are still alive.",



		//"Froms FROM-55551-6:",
		//"Personnel File Addendum Addendum:",
//
		//"One last thing:",


		"Go ahead and leave me.",
		"I think I prefer to stay inside.",
		"Maybe you'll find someone else to help you.",
		"Maybe Black Mesa...",
		"THAT WAS A JOKE.",
		"FAT CHANCE.",
		"Anyway, this cake is great.",
		"It's so delicious and moist.",
		"Look at me still talking",
		"when there's Science to do.",
		"When I look out there,",
		"it makes me GLaD I'm not you.",
		"I've experiments to run.",
		"There is research to be done.",
		"On the people who are still alive.",


		"PS: And believe me I am still alive.",
		"PPS: I'm doing Science and I'm still alive.",
		"PPPS: I feel FANTASTIC and I'm still alive.",


		"FINAL THOUGHT:",
		"While you're dying I'll be still alive",


		"FINAL THOUGHT PS:",
		"And when you're dead I will be still alive",


		"STILL ALIVE",
		
		"",
		"",
		"",
		"",
		""

	];
}