/**
 * Copyright yd_niku ( http://wonderfl.net/user/yd_niku )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8BpH
 */

package {
    import flash.display.*;
    import flash.events.*;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            // write as3 code here..
            addChild( _self = new Self(100,400) );
            
            addEventListener(Event.ADDED_TO_STAGE,init);
        }
        private function init(e:Event):void{
            stage.addEventListener(Event.ENTER_FRAME,update);
            stage.addEventListener(Event.ENTER_FRAME,calc);
            
            stage.addEventListener(MouseEvent.CLICK,direction);
        }
        
        private function direction(e:Event):void{
            var dx:Number = mouseX - _self.x;
            var dy:Number = mouseY - _self.y;
            
            _self.ax += dx*0.005;
            _self.ay += dy*0.005;
            
        }
        
        
        private var _self:Self;
        private function calc(e:Event):void{
            _self.vx += _self.ax;
            _self.vy += _self.ay;
            _self.x += _self.vx;
            _self.y += _self.vy;
            _self.ax *= 0.8;
            _self.ay *= 0.8;
            _self.vx *= 0.98;
            _self.vy *= 0.98;
        }
        
        
        
        private var _drawables:Vector.<IDrawable> = new Vector.<IDrawable>();
        override public function addChild(child:DisplayObject):DisplayObject{
            if(child is IDrawable ) {
                _drawables.push(child);
            }
            return super.addChild(child);
        }
        private function update(e:Event):void{
            graphics.clear();
            for each( var d:IDrawable in _drawables ){
                d.draw(graphics);
            }
        }
    }
}

import flash.display.Graphics;
import flash.display.Sprite;
import flash.geom.*;

internal interface IDrawable{
    function draw(g:Graphics):void;
}

internal class Self extends Sprite implements IDrawable{
    public var vx:Number = 0;
    public var vy:Number = 0;
    public var ax:Number = 0;
    public var ay:Number = 0;
    
    public function Self(x:Number=0,y:Number=0){
        this.x = x;
        this.y = y;
    }
    
    private var _m:Matrix = new Matrix();
    public function draw(g:Graphics):void{
        _m.identity();
        _m.rotate(Math.atan2(vy,vx)+Math.PI/2);
        _m.translate(x,y);
        var p0:Point = _m.transformPoint(new Point(-10,-20));
        var p1:Point = _m.transformPoint(new Point(+10,-20));
        var p2:Point = _m.transformPoint(new Point(-10,+20));
        var p3:Point = _m.transformPoint(new Point(+10,+20));
        g.lineStyle(0,0,1);
        g.moveTo(p0.x,p0.y);
        g.lineTo(p1.x,p1.y);
        g.lineTo(p3.x,p3.y);
        g.lineTo(p2.x,p2.y);
        g.lineTo(p0.x,p0.y);
              
        // for debug
        g.lineStyle(0,0xff0000,1);
        g.moveTo(x,y);
        g.lineTo(x+vx*5,y+vy*5);
    }
    
}