/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8BWa
 */

package {
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            
            myRect = new xRect();
            myRect.cx =  0;
            myRect.cy =  0;
            myRect.cw = 100;
            myRect.ch = 140;
            
            stage.addEventListener(Event.ENTER_FRAME, onEnter);
        }//ctor
        
        public var myRect:xRect;
        
        public function onEnter(e:Event):void
        {
            //myRect.cx = stage.mouseX;
            //myRect.cy = stage.mouseY;
            
            graphics.clear();
            graphics.lineStyle(2, 0);
            
            var cx:Number;
            var cy:Number;
            var r:Number;
            r = 100;
            cx = 200;
            cy = 200;
            
            graphics.drawCircle(cx, cy, r);
            
            var b:Boolean;
            b = isInside(myRect, cx,cy,r);
            
            graphics.beginFill(b ? 0xFF:0xFF0000, 0.5);
            graphics.drawRect(myRect.cx, myRect.cy, myRect.cw, myRect.ch);
            graphics.endFill();
            
            if (!b)
            {
             var dx:Number;
             var dy:Number;
             var a:Number;
             a = Math.atan2(cy-(myRect.cy+myRect.ch*0.5), cx-(myRect.cx+myRect.cw*0.5));
             myRect.cx += Math.cos(a);
             myRect.cy += Math.sin(a);   
                
            }
            
            
        }//onenter
        
        public function isInside(a:xRect, cx:Number, cy:Number, rad:Number):Boolean
        {
         var m:Number;
         
         m = getDist(a.cx,a.cy, cx, cy);
         if (m > rad) { return false; }
         m = getDist(a.cx+a.cw,a.cy, cx, cy);
         if (m > rad) { return false; }
         m = getDist(a.cx,a.cy+a.ch, cx, cy);
         if (m > rad) { return false; }
         m = getDist(a.cx+a.cw,a.cy+a.ch, cx, cy);
         if (m > rad) { return false; }
                     
         return true;   
        }//isin
        
        
        public function getDist(ax:Number, ay:Number, cx:Number, cy:Number):Number
        {
          var dx:Number;
          var dy:Number;
          dx = ax - cx;
          dy = ay - cy;
          return Math.sqrt(dx*dx+dy*dy);  
        }//getdist
        
        
    }//classend
}

internal class xRect
{
    public var cx:Number = 0;
    public var cy:Number = 0;
    public var cw:Number = 0;
    public var ch:Number = 0;
    
    
}//xrect
