/**
 * Copyright bou_Ujin ( http://wonderfl.net/user/bou_Ujin )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8BAL
 */

// forked from bou_Ujin's 蠢く何か
package
{
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.events.KeyboardEvent;

	[SWF(backgroundColor="0x000000", frameRate="60")]
	//開始処理用Sprite、各種システム変数変更やイベントなどの追加はここで
	public class StartSprite extends Sprite
	{
		private var main:Vector.<MainClass>;
		
		public function StartSprite() 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(evt:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			main = new Vector.<MainClass>(5,true);
			for(var i:int=0; i<main.length; i++)
			{
				main[i]= new MainClass(this);
				main[i].resize(stage.stageWidth, stage.stageHeight);
			}
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			stage.addEventListener(Event.RESIZE, onResize);
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		
		private function onEnterFrame(evt:Event):void 
		{
			for(var i:int=0; i<main.length; i++)
			{
				main[i].onEnterFrame();
			}
		}
		
		private function onResize(evt:Event):void 
		{
			for(var i:int=0; i<main.length; i++)
			{
				main[i].resize(stage.stageWidth, stage.stageHeight);
			}
		}
	}
}


import flash.display.Sprite;
import flash.display.Graphics;
import flash.display.Shape;

//本体処理クラス
class MainClass
{
	public var view:Sprite;
	public var ww:int;
	public var wh:int;
	public var FT:Number;
	
	private var lineAddSprite:Sprite;
	private var line:Vector.<Shape>;
	private var topLine:Shape;
	private var lineNum:int = 50;
	private var linelength:int = 20;
	private var frame:int = 0;
	private var code:Number = 1;
	private var codeChangeFrameRate:int = 60;
	private var rotateRate:Number = 10;
	
	public function MainClass(topSprite:Sprite)
	{
		FT = 1/60;
		view = topSprite;
		lineAddSprite = new Sprite();
		line = new Vector.<Shape>(lineNum,true);
		var coler:uint = 0xFFFFFFFF*Math.random();		
		for(var i:int=0; i<lineNum; i++)
		{
			line[i] = new Shape();
			var g:Graphics = line[i].graphics;
			g.lineStyle(5,coler,1-(lineNum-i+1)/lineNum);
			g.moveTo(0,0);
			g.lineTo(0,-1);
			lineAddSprite.addChild(line[i]);
		}
		view.addChild(lineAddSprite);
		topLine = line[lineNum-1];
	}
	
	public function onEnterFrame():void
	{
		for(var i:int=0; i<lineNum-1; i++)
		{
			line[i].x=line[i+1].x;
			line[i].y=line[i+1].y;
			line[i].rotation=line[i+1].rotation;
		}
		var rad:Number = topLine.rotation/180*Math.PI;
		topLine.x += Math.sin(rad)*linelength;
		topLine.y += -Math.cos(rad)*linelength;
		

		frame++;
		if(Math.abs(topLine.rotation) < 90)
		{
			if(frame>codeChangeFrameRate*Math.random())
			{
				frame = 0;
				code = -topLine.rotation/Math.abs(topLine.rotation);
			}
		}else{
			code*=1.1;
		}
		topLine.rotation +=code*rotateRate*Math.random();
		
		lineAddSprite.y -= (topLine.y+lineAddSprite.y)*FT*8;
		lineAddSprite.x -= (topLine.x+lineAddSprite.x)*FT*2;
	}
	
	public function resize(w:Number, h:Number):void
	{
		view.x = w/2;
		view.y = h/2;
		ww = w;
		wh = h;
	}
}