/**
 * Copyright genny ( http://wonderfl.net/user/genny )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8B0L
 */

package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.filters.GlowFilter;
	
	public class Main extends Sprite
	{
		/**
		*	property
		*/
		private var _startX:Number = 0;					//	スタート位置
		private var _endX:Number = stage.stageWidth;	//	目的の位置
		private var _frame:int = 0;						//	最初のフレーム数
		private var _frameCount:int = 30;				//	合計のフレーム数
		private var _frameAmount:Array;
		
		
		/**
		*	constructer
		*/
		public function Main()
		{
			init();
		}
		
		
		/**
		*	init
		*/
		private function init() :void
		{
			_frameAmount = getFrameAmount();	//	各フレーム語との移動量を算出
			 
			//	グラフィックの描画
			graphics.clear();
			graphics.beginFill(0xFFCC00);
			graphics.drawCircle( 0, 0, 5 );
			graphics.endFill();
			 
			x = 0;
			y = stage.stageHeight / 2;
			filters=[ new GlowFilter(0xFFCC00,1,16,16,2,2) ];
			
			//	レンダリング開始
			start();
			
		}
		
		
		private function getFrameAmount() :Array
		{
			var arr:Array = new Array();
			var len:int = _frameCount;
			var easeRatio:Number = 0.2;
			var tempX:Number = _startX;

			for( var i:int = 0; i < len; i ++ )
			{
				tempX += ( _endX - tempX ) * easeRatio;
				arr.push( tempX );
			}
			return arr;
		}
		
		
		/**
		*	Listener Start
		*/
		private function start() :void
		{
			addEventListener( Event.ENTER_FRAME, render );
		}
		
		private function stop() :void
		{
			removeEventListener( Event.ENTER_FRAME, render );
		}
		
		
		/**
		*	Handler
		*/
		private function render( event:Event ) :void
		{
			
			if( _frame < _frameCount )
			{
				x = _frameAmount[ _frame ];
			}
			else
			{
				x = 0;
				_frame = 0;
			}
			
			_frame ++;
		}
		
		
		
	}
	
}