/**
 * Copyright mimshwright ( http://wonderfl.net/user/mimshwright )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/89pw
 */

// forked from mimshwright's HelloKitchenSync
// Shows a basic hello world using KSFunction
// The program will wait five seconds then call 
// sayHelloTo("world"). Following that, event handler
// will display the number of characters in the message.

package {
	import flash.text.TextField;
	import flash.display.Sprite;
	import flash.events.Event;
	
	import org.as3lib.kitchensync.KitchenSync;
	import org.as3lib.kitchensync.action.*;
	import org.as3lib.kitchensync.core.*;
	
	[SWF(width="500", height="500", frameRate="50", backgroundColor="#FFFFFF")]
	
	public class HelloKitchenSync extends Sprite {
		
		private var func:KSFunction;
		private var tf:TextField;
		
		public function HelloKitchenSync()
		{
			super();
			KitchenSync.initialize(this);
			
			tf = new TextField();
			tf.autoSize = "left";
			tf.width = 300;
			addChild (tf);
			
			func = new KSFunction (sayHelloTo, "5sec", "world");
			func.addEventListener(KitchenSyncEvent.ACTION_COMPLETE, onFunctionComplete);
			func.start();
		}
		
		// print's greeting and saves the 
		// number of characters in the message.
		private function sayHelloTo(who:String):int {
			tf.text = "Hello, " + who + "!";
			return tf.text.length;
		}
		
		private function onFunctionComplete (event:Event):void {
			tf.appendText ( " - " + func.result.toString() );
		}
	}
}