/**
 * Copyright soh1106c ( http://wonderfl.net/user/soh1106c )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/89Hs
 */

package {
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Matrix3D;
    import flash.geom.Vector3D;

    import jiglib.cof.JConfig;
    import jiglib.geometry.*;
    import jiglib.math.*;
    import jiglib.physics.*;
    import jiglib.physics.constraint.*;
    import jiglib.plugin.papervision3d.*;

    import org.papervision3d.cameras.CameraType;
    import org.papervision3d.core.geom.renderables.Vertex3D;
    import org.papervision3d.core.math.Number3D;
    import org.papervision3d.core.math.Plane3D;
    import org.papervision3d.core.utils.Mouse3D;
    import org.papervision3d.events.*;
    import org.papervision3d.lights.PointLight3D;
    import org.papervision3d.materials.shadematerials.*;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.materials.*;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.view.BasicView;
    import org.papervision3d.view.layer.ViewportLayer;
    import org.papervision3d.view.layer.util.ViewportLayerSortMode;
    import org.papervision3d.objects.parsers.*;

    [SWF(width="800",height="600",backgroundColor="#ffffff",frameRate="60")]
    public class falling_buddha extends BasicView {
        private var mylight:PointLight3D;
        private var mouse3D:Mouse3D;
        private var wireframeMateria:WireframeMaterial;
        private var shadeMateria:GouraudMaterial;

        private var ground:RigidBody;

        private var boxBody:Vector.<RigidBody>;
        private var boxBodyb:Vector.<RigidBody>;

        private var onDraging:Boolean=false;

        private var currDragBody:RigidBody;
        private var dragConstraint:JConstraintWorldPoint;
        private var startMousePos:Vector3D;
        private var planeToDragOn:Plane3D;

        private var physics:Papervision3DPhysics;

        private var BuddhaSkin:DAE;
        private var BuddhaBox:RigidBody;

        public function falling_buddha() {
            super(800, 600, true, true, CameraType.TARGET);

            stage.addEventListener(MouseEvent.MOUSE_UP, handleMouseRelease);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, handleMouseMove);

            init3D();
        }

        private function init3D():void {
            JConfig.numContactIterations=12;
            physics=new Papervision3DPhysics(scene,8);

            Mouse3D.enabled=true;
            mouse3D=viewport.interactiveSceneManager.mouse3D;
            viewport.containerSprite.sortMode = ViewportLayerSortMode.INDEX_SORT;

            mylight=new PointLight3D(true,true);
            mylight.y=0;
            mylight.z=-600;
            
            var vplObjects:ViewportLayer = new ViewportLayer(viewport,null);
            vplObjects.layerIndex = 2;
            vplObjects.sortMode = ViewportLayerSortMode.Z_SORT;
            viewport.containerSprite.addLayer(vplObjects);

/////////////////////////////////　地面表示
            
            var bridge:DAE=new DAE;
                bridge.load("http://soh1106.lolipop.jp/res/bridge/washington_bridge/washington_bridge.DAE");
                bridge.scale=0.2;
                scene.addChild(bridge);

            var bridgeBox=new JBox(new Pv3dMesh(bridge),800,150,10);
            physics.addBody(bridgeBox);
            bridgeBox.movable=false;
            bridgeBox.z=0;
            bridgeBox.y=-450;
            bridgeBox.rotationY=-20;

            bridgeBox.restitution=1;

/////////////////////////////////　大仏表示

            shadeMateria=new GouraudMaterial(mylight,0xeeee00);
            shadeMateria.interactive=true;
            var materiaList = new MaterialsList();
            materiaList.addMaterial(shadeMateria,"all");

            boxBody=new Vector.<RigidBody>();
            for (var i:int = 0; i < 3; i++) {
                BuddhaSkin=new DAE;
                BuddhaSkin.load("http://soh1106.lolipop.jp/res/buddha/buddha.dae");
                BuddhaSkin.scale=5;
                scene.addChild(BuddhaSkin);

                var BuddhaBox=new JBox(new Pv3dMesh(BuddhaSkin),200,200,400);
                
                physics.addBody(BuddhaBox);
                boxBody[i]=BuddhaBox;
                boxBody[i].moveTo(new Vector3D(0, 2000 + (500 * i + 40), 0));
                vplObjects.addDisplayObject3D(physics.getMesh(boxBody[i]));
            }

/////////////////////////////////　キューブ表示

            boxBodyb=new Vector.<RigidBody>();
            for (i= 0; i < 1; i++) {
                boxBodyb[i]=physics.createCube(materiaList,100,100,100);
                physics.getMesh(boxBodyb[i]).addEventListener(InteractiveScene3DEvent.OBJECT_PRESS, handleMousePress);
                boxBodyb[i].moveTo(new Vector3D(-1000, 2000 + (40 * i + 40), 0));
            }

            camera.y=mylight.y;
            camera.z=mylight.z;

            startRendering();
        }
/////////////////////////////////　ドラッグ

        private function findSkinBody(skin:DisplayObject3D):int {
            for (var i:String in PhysicsSystem.getInstance().bodies) {
                if (skin==physics.getMesh(PhysicsSystem.getInstance().bodies[i])) {
                    return int(i);
                }
            }
            return -1;
        }

        private function handleMousePress(event:InteractiveScene3DEvent):void {
            onDraging=true;
            startMousePos=new Vector3D(mouse3D.x,mouse3D.y,mouse3D.z);
            currDragBody=PhysicsSystem.getInstance().bodies[findSkinBody(event.displayObject3D)];
            planeToDragOn=new Plane3D(new Number3D(0,0,-1),new Number3D(0,0,- startMousePos.z));

            var bodyPoint:Vector3D=startMousePos.subtract(currDragBody.currentState.position);
            dragConstraint=new JConstraintWorldPoint(currDragBody,bodyPoint,startMousePos);
            PhysicsSystem.getInstance().addConstraint(dragConstraint);
        }

        private function handleMouseMove(event:MouseEvent):void {
            if (onDraging) {
                var ray:Number3D=camera.unproject(viewport.containerSprite.mouseX,viewport.containerSprite.mouseY);
                ray=Number3D.add(ray,new Number3D(camera.x,camera.y,camera.z));

                var cameraVertex3D:Vertex3D=new Vertex3D(camera.x,camera.y,camera.z);
                var rayVertex3D:Vertex3D=new Vertex3D(ray.x,ray.y,ray.z);
                var intersectPoint:Vertex3D=planeToDragOn.getIntersectionLine(cameraVertex3D,rayVertex3D);

                dragConstraint.worldPosition=new Vector3D(intersectPoint.x,intersectPoint.y,intersectPoint.z);
            }
        }

        private function handleMouseRelease(event:MouseEvent):void {
            if (onDraging) {
                onDraging=false;
                PhysicsSystem.getInstance().removeConstraint(dragConstraint);
                currDragBody.setActive();
            }
        }
        
//////////////////////　リセット        
        
        private function resetBox():void
        {            
            for (var i:int = 0; i < boxBody.length;i++ )
            {
                if (boxBody[i].currentState.position.y < -3000)
                {
                    boxBody[i].moveTo(new Vector3D(0, 2000 + (60 * i + 60), 0));
                }
            }
            
            for (i = 0; i < boxBodyb.length;i++ )
            {
                if (boxBodyb[i].currentState.position.y < -1000)
                {
                    boxBodyb[i].moveTo(new Vector3D(0, 2000 + (60 * i + 60), 0));
                }
            }
        }
        
///////////////////////// レンダリング

        protected override function onRenderTick(event:Event = null):void {
            
            var rot:Number=(mouseX/stage.stageWidth)*720;
            camera.x=600*Math.sin(rot*Math.PI/180);
            camera.z=600*Math.cos(rot*Math.PI/180);
            camera.y=600*(mouseY/stage.stageHeight);
            
//            physics.step();//dynamic timeStep
            physics.engine.integrate(0.5);//static timeStep
            resetBox();
            super.onRenderTick(event);
        }
    }
}