/**
 * Copyright irobutsu ( http://wonderfl.net/user/irobutsu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/889H
 */

package{
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.display.Sprite;
   import flash.geom.*;

    [SWF(width="400", height="400",backgroundColor=0xffffff)]


    public class Kepler extends Sprite
    {
	private var slV:Tsumami , slA:Tsumami ; 
	private var cbV:Check , cbA:Check , cbS:Check ; 
	private var w:int , h:int ; 
	private var hankei:int = 10 ; 
	private var x0:Number , y0:Number;
	private var vx:Number = 10 ; 
	private var vy:Number = -10 ; 
	private var vx0:Number , vy0:Number ; 
	private var a:Number = 6 ; 
	private var nowDrag:int = 0 ; 
	private var t:Number = 0.0 ; 
	private var movingFlg:Boolean ; 
	private var epsilon:RealTsumami , R:IntTsumami ; 

	public function Kepler():void { 
	    w=400;
	    h=346;

	    cbV = new Check(this,true,0,364,100, "速度を描く" ,0xff ) ;
	    cbS = new Check(this,true,300,364,100, "面積速度を描く" ,0x888800 ) ;
	    cbA = new Check(this,true,0,382,100, "加速度を描く",0xff0000  ) ;
	    R = new IntTsumami(this, 120 ,30, 200 ,0,346,200,"長半径=") ;
	    epsilon = new RealTsumami(this, 0.01, 66, 0 ,99 , 200,346,200,"離心率=") ;
	    slA = new IntTsumami(this, 200,50,500 ,100,382,200,"加速度倍率=") ;
	    slV = new IntTsumami(this, 200,50,500 ,100,364,200,"速度倍率=" ) ;

	    addEventListener(Event.ENTER_FRAME,update);
	}
	
	public function calcE( nt:Number , ee:Number ):Number { 
	    var E:Number = nt ;
	    var EU:Number = E + Math.PI ;
	    var ED:Number = E - Math.PI ;
	    var diff:Number ;
	    diff = E - ee * Math.sin(E) - nt ;
	    while( Math.abs(diff) > 1e-10 ) {
		if( diff > 0 ) {
		    EU = E ;
		    E = ( ED + E ) * 0.5 ;
		}
		else {
		    ED = E ;
		    E = ( EU + E ) * 0.5 ;
		}
		diff = E - ee * Math.sin(E) - nt ;
	    }
	    return E ;
	}
	
	public function update(e:Event):void { 
	    t += 0.03;

	    graphics.clear();
	    graphics.lineStyle(1,0xffffff);
	    graphics.beginFill(0xffffff);
	    graphics.drawRect(0 , 0 , w , h) ;
	    graphics.endFill();

	    var ee:Number = epsilon.RealValue() ;
	    var r0:Number = R.IntValue() * ( 1 - ee * ee ) ;
	    var EE:Number = calcE(t , ee) ;
	    var r1:Number = r0 / ( 1.0 + ee ) ;
	    var r2:Number = r0 / ( 1.0 - ee ) ;
	    var r3:Number = r0 / Math.sqrt(1 - ee * ee) ;

	    graphics.lineStyle(1,0xff00ff) ;
	    graphics.drawEllipse(w / 2 -int((r2+r1)*0.5), 5*h/8-int(r3) , int(( ( r1 + r2 ) )) , int(( 2 * r3 ))) ;

	    var theta:Number = 2.0 * Math.atan2(
		Math.sin(EE * 0.5) * Math.sqrt(( 1.0 + ee ) / ( 1.0 - ee )) ,
		Math.cos(EE * 0.5)
	    ) ;
	    var r:Number = r0 / ( 1 + ee * Math.cos(theta) ) ;
	    var hankei1:int = 5 ;
	    graphics.lineStyle(1,0xff00) ;
	    var xx1:int = w / 2 -int((r2-r1)*0.5);
	    var yy1:int = 5*h / 8 ;
	    graphics.beginFill(0xff00);
	    graphics.drawEllipse(xx1-hankei , yy1-hankei , hankei * 2 , hankei * 2) ;
	    graphics.endFill();

	    graphics.lineStyle(0) ;
	    var xx:int = w / 2 - int(((r2-r1)*0.5+ r * Math.cos(theta) )) ;
	    var yy:int = 5*h / 8 + int(( r * Math.sin(theta) )) ;

	    graphics.beginFill(0);
	    graphics.drawEllipse(xx-hankei1 , yy-hankei1 , hankei1 * 2 , hankei1 * 2) ;
	    graphics.endFill();

	    var xx0:int;


	    xx0= 2*w/3;

	    graphics.lineStyle(1,0xffff) ;
	    graphics.beginFill(0xffff);
	    graphics.drawRect(xx0 , 0 , w / 3 , w / 3) ;
	    graphics.endFill();
	    graphics.lineStyle(1,0xffffff) ;
	    graphics.beginFill(0xffffff);
	    graphics.drawRect(xx0 + hankei , hankei , w / 3 - hankei * 2 , w / 3 - hankei * 2) ;
	    graphics.endFill();
	    graphics.lineStyle(1,0) ;
	    graphics.beginFill(0);
	    graphics.drawEllipse(xx0 + w / 6 -hankei1, w / 6-hankei1  , hankei1 * 2 , hankei1 * 2) ;
	    graphics.endFill();
	    var vtheta:Number = 2.0 * slV.value() * Math.sqrt(r0) / r ;
	    var vr:Number = 2.0 * slV.value() * Math.sqrt(r0 * ( 1.0 / r - ( 1.0 + ee ) / r0 ) * ( ( 1.0 - ee ) / r0 - 1.0 / r )) ;
	    if( Math.sin(theta) > 0.0 ) {
		vr = -vr ;
	    }
	    
	    if( cbS.isChecked() ) {
		graphics.lineStyle(1,0xffff00) ;
		graphics.beginFill(0xffff00);

		graphics.moveTo(w / 2- int((r2-r1)*0.5) , 5*h / 8) ;
		graphics.lineTo(xx , yy) ;
		graphics.lineTo(xx + int(( vr * Math.cos(theta) + vtheta * Math.sin(theta) )) , yy + int(( -vr * Math.sin(theta) + vtheta * Math.cos(theta) ))) ;
		graphics.endFill() ;
	    }
	    
	    if( cbA.isChecked() ) {
		var a:Number = slA.value() * 1500 ;
		drawYajirusi(xx , yy , a / ( r * r ) * Math.cos(theta) , -a / ( r * r ) * Math.sin(theta),0xff00000) ;
		drawYajirusi(
		    xx0 + w / 6 + int(( vr * Math.cos(theta) + vtheta * Math.sin(theta) )) , 
		    w / 6 + int(( -vr * Math.sin(theta) + vtheta * Math.cos(theta) )) , 
		    a / ( r * r ) * Math.cos(theta) , 
		    -a / ( r * r ) * Math.sin(theta),0xff0000) ;
	    }
	    
	    if( cbV.isChecked() ) {
		drawYajirusi(xx , yy , 
		    vr * Math.cos(theta) + vtheta * Math.sin(theta) , 
		    -vr * Math.sin(theta) + vtheta * Math.cos(theta),
		    0xff) ;
		drawYajirusi(xx0 + w / 6 , w / 6 , 
		    vr * Math.cos(theta) + vtheta * Math.sin(theta) , 
		    -vr * Math.sin(theta) + vtheta * Math.cos(theta)
		    ,0xff) ;
	    }
	    
	}
	
	public function drawYajirusi(XX:int , YY:int , vx:Number , vy:Number,c:int ):void { 
	    var rr:Number = Math.sqrt(vx * vx + vy * vy) ;
	    var rx:Number = vx / rr ;
	    var ry:Number = vy / rr ;
	    var xx:int = int(( vx )) ;
	    var yy:int = int(( vy )) ;

	    graphics.lineStyle(3,c);

	    graphics.moveTo(XX,YY);
	    graphics.lineTo(XX+vx,YY+vy);


	    graphics.lineStyle(2,c);
	    graphics.beginFill(c);

	    graphics.moveTo(XX + int(( vx - 0.25 * vx - 0.12 * vy )) , YY + int(( vy - 0.25 * vy + 0.12 * vx ))) ;
	    graphics.lineTo(XX+vx,YY+vy);
	    graphics.lineTo(XX + int(( vx - 0.25 * vx + 0.12 * vy )) , YY + int(( vy - 0.25 * vy - 0.12 * vx ))) ;
	    graphics.endFill();
	}
    }
}

import flash.events.Event;
import flash.events.MouseEvent;
import flash.display.Sprite;
import flash.display.*;
import flash.system.*;
import flash.geom.*;
import flash.text.*

class Clickable extends Sprite {
    public function Clickable(pp:Sprite):void {
	buttonMode=true;
	pp.addChild(this);
    }

}

class current extends Clickable {
    private var i:int;
    private var hankei:int;
    private var color:int;
    private var nowDrag:Boolean;

    public function I():int { return i;}
    public function X():int {return x;}
    public function Y():int {return y;}

    public function current(pp:Sprite, qq:int,XX:int, YY:int, c:int):void {
	super(pp);
	x=XX;
	y=YY;
	i=qq;
	hankei=10;
	color=c;
	nowDrag=false;
	write();
    }
    public function setI(qq:int):void { i=qq; }

    public function goDrag():void {
	nowDrag=true;
	startDrag(false,new Rectangle(hankei,hankei,400-hankei*2,346-hankei*2));
    }

    public function isNear(xx:int, yy:int):Boolean {
	return (xx-x)*(xx-x)+(yy-y)*(yy-y) < hankei*hankei;
    }

    public function endDrag():void {
	nowDrag=false;
	stopDrag();
	update();
    }

    public function update():void {
	write();
    }

    public function write():void {
	graphics.clear();
	graphics.lineStyle(1,color);
	graphics.beginFill(color);
	graphics.drawCircle(0,0,hankei);
	graphics.endFill();
	if( i > 0 ) {
	    graphics.lineStyle(1,0);
	    graphics.beginFill(0);
	    graphics.drawCircle(0,0,hankei/2);
	    graphics.endFill();
	} else if( i< 0 ) {
	    graphics.lineStyle(1,0);
	    graphics.moveTo(-7*hankei/10,-7*hankei/10);
	    graphics.lineTo(7*hankei/10,7*hankei/10);
	    graphics.moveTo(-7*hankei/10,7*hankei/10);
	    graphics.lineTo(7*hankei/10,-7*hankei/10);
	}
    }
}


class Plate extends Sprite {
    protected var txt:TextField;
    protected var Width:int;
    public function Plate(pp:Sprite,X:int,Y:int,W:int,s:String):void {
	x=X;
	y=Y;
	txt=new TextField();
	txt.text=s;
	txt.height=18;
	txt.width=W-20;
	txt.y=0;
	addChild(txt);

	Width=W;
	buttonMode=true;
	writeNormal();
	pp.addChild(this);
    }

    protected function writeNormal():void { 
	graphics.clear();
	graphics.lineStyle(1,0xaaaaaa);
	graphics.beginFill(0xdddddd);
	graphics.drawRect(0,0,Width-1,17);
	graphics.endFill();
	graphics.lineStyle(1,0x666666);
	graphics.moveTo(1,17);
	graphics.lineTo(Width-1,17);
	graphics.lineTo(Width-1,1);
    }
}

class MessagePlate extends Plate {
    private var normalTxt:String;
    private var messageTxt:String;
    private var normalColor:int;
    private var messageColor:int;

    public function MessagePlate(pp:Sprite,X:int,Y:int,W:int,s1:String,s2:String,c1:int=0,c2:int=0xff0000):void {
	super(pp,X,Y,W,s1);
	normalTxt=s1;
	messageTxt=s2;
	normalColor=c1;
	messageColor=c2;
	Off();
    }
    public function On():void {
	txt.text=messageTxt;
	txt.textColor=messageColor;
    }
    public function Off():void {
	txt.text=normalTxt;
	txt.textColor=normalColor;
    }
}

class ClickablePlate extends Plate {
    public function ClickablePlate(pp:Sprite,X:int,Y:int,W:int,s:String):void {
	super(pp,X,Y,W,s);

	buttonMode=true;
	addEventListener(MouseEvent.MOUSE_UP,MUp);
	addEventListener(MouseEvent.MOUSE_OVER,MOver);
	addEventListener(MouseEvent.MOUSE_OUT,MOut);
    }

    public function MUp(e:Event):void {
	;
    }

    public function MOut(e:Event):void {
	writeNormal();
    }

    public function MOver(e:Event):void {
	writeHilight();
    }
    protected function writeHilight():void {
	graphics.clear();
	graphics.lineStyle(1,0xffffff);
	graphics.beginFill(0xdddddd);
	graphics.drawRect(0,0,Width-1,17);
	graphics.endFill();
	graphics.lineStyle(1,0xaaaaaa);
	graphics.moveTo(1,17);
	graphics.lineTo(Width-1,17);
	graphics.lineTo(Width-1,1);
    }
}

class Check extends ClickablePlate {
    private var val:Boolean;
    private var box:Sprite;

    public function Check(pp:Sprite,now:Boolean,X:int,Y:int,W:int,l:String,c:int=0):void {
	super(pp,X,Y,W,l);
	val=now;
	txt.x=16;
	txt.textColor=c;
	box=new Sprite();
	box.buttonMode=true;
	addChild(box);
	write();
    }

    public override function MUp(e:Event):void {
	toggle();
	dispatchEvent(new Event("update",true));
    }

    public function setValue(a:Boolean):void {
	val=a;
	write();
    }


    public function isChecked():Boolean {
	return val;
    }

    public function toggle():void {
	setValue(!val);
    }

    public function update():void {
	write();
    }

    public function write():void {
	box.graphics.clear();
	box.graphics.lineStyle(1,0);
	box.graphics.beginFill(0xffffff);
	box.graphics.drawRect(1,1,14,14);
	box.graphics.endFill();	
	if( val ) {
	    box.graphics.lineStyle(2,0);
	    box.graphics.moveTo(2,11);
	    box.graphics.lineTo(4,11);
	    box.graphics.lineTo(6,13);
	    box.graphics.lineTo(14,3);
	}
    }
}



class Tsumami extends Plate {
    protected var val:int;
    protected var min:int;
    protected var max:int;
    protected var label:String;
    protected var nowDrag:Boolean;
    protected var lever:Sprite;
    protected var mizo:Sprite;
    public function Tsumami(pp:Sprite,now:int,minimum:int,maximum:int,X:int,Y:int,WW:int,l:String,c:int=0):void {
	super(pp,X,Y,WW,l);
	txt.textColor=c;
	buttonMode=false;
	nowDrag=false;
	min=minimum;
	max=maximum;
	val=now;
	label=l;
	lever=new Sprite();
	mizo=new Sprite();
	addChild(mizo);
	addChild(lever);
	mizo.x=Width/2;
	mizo.y=6;
	mizo.buttonMode=true;
	lever.buttonMode=true;
	mizo.addEventListener(MouseEvent.MOUSE_UP,mizoMUp);
	mizo.addEventListener(MouseEvent.MOUSE_OVER,mizoMOver);
	mizo.addEventListener(MouseEvent.MOUSE_OUT,mizoMOut);
	stage.addEventListener(MouseEvent.MOUSE_UP,leverMUp);
	lever.addEventListener(MouseEvent.MOUSE_DOWN,leverMDown);
	lever.addEventListener(MouseEvent.MOUSE_OVER,leverMOver);
	lever.addEventListener(MouseEvent.MOUSE_OUT,leverMOut);
	leverNormal();
	mizoNormal();
	update();
    }

    public function leverMUp(e:MouseEvent):void {
    	if(nowDrag ) {
	    endDrag();
    	}
    }
    public function leverMOver(e:MouseEvent):void {
	leverHighlight();
    }
    public function leverMDown(e:MouseEvent):void {
	goDrag();
    }


    public function mizoMUp(e:MouseEvent):void {
	var p:Point=localToGlobal(new Point(lever.x,lever.y) );
	if( e.stageX < p.x+6 ) {
	    oneDown();
	} else {
	    oneUp();
	}
	mizoHighlight(e);
    }
    public function mizoMOver(e:MouseEvent):void {
	mizoHighlight(e);
    }
    public function mizoMOut(e:MouseEvent):void {
	mizoNormal();
    }

    public function mizoNormal():void {
	mizo.graphics.clear();
	mizo.graphics.lineStyle(1,0x555555);
	mizo.graphics.beginFill(0x555555);
	mizo.graphics.drawRect(0,0,Width/2-4,5);
	mizo.graphics.endFill();
	mizo.graphics.lineStyle(1,0);
	mizo.graphics.moveTo(0,5);
	mizo.graphics.lineTo(0,0);
	mizo.graphics.lineTo(Width/2-4,0);
    }

    public function mizoHighlight(e:MouseEvent):void {
	if( nowDrag ) {
	    return;
	}
	var p:Point=localToGlobal(new Point(lever.x,lever.y) );
	mizo.graphics.clear();
	mizo.graphics.lineStyle(1,0x555555);
	mizo.graphics.beginFill(0x555555);
	mizo.graphics.drawRect(0,0,Width/2-4,5);
	mizo.graphics.endFill();
	mizo.graphics.lineStyle(1,0xffffff);
	if( e.stageX > p.x+6 ) {
	    mizo.graphics.moveTo(lever.x-mizo.x,0);
	    mizo.graphics.lineTo(Width/2-4,0);
	    mizo.graphics.beginFill(0xaaaa);
	    mizo.graphics.moveTo(lever.x-mizo.x+8,0);
	    mizo.graphics.lineTo(lever.x-mizo.x+18,3);
	    mizo.graphics.lineTo(lever.x-mizo.x+8,6);
	    mizo.graphics.endFill();
	} else {
	    mizo.graphics.moveTo(lever.x-mizo.x,0);
	    mizo.graphics.lineTo(0,0);
	    mizo.graphics.lineTo(0,6);
	    mizo.graphics.beginFill(0xaaaa);
	    mizo.graphics.moveTo(lever.x-mizo.x-2,0);
	    mizo.graphics.lineTo(lever.x-mizo.x-12,3);
	    mizo.graphics.lineTo(lever.x-mizo.x-2,6);
	    mizo.graphics.endFill();
	}
    }

    public function leverMOut(e:MouseEvent):void {
	if( !nowDrag ) {
	    leverNormal();
	}
    }

    public function oneUp():void {
	setValue(val+1);
    }

    public function oneDown():void {
	setValue(val-1);
    }

    protected function XIchi():int{
	return int(Number((Width/2-6)*(val-min))/Number(max-min))+Width/2;
    }


    public function goDrag():void {
	nowDrag=true;
	leverInDrag();
	lever.startDrag(false,new Rectangle(Width/2,0,Width/2-6,0));
    }

    public function endDrag():void {
	nowDrag=false;
	leverNormal();
	lever.stopDrag();
	val=min + int(Number((lever.x-Width/2)*(max-min))/Number(Width/2-6)+0.5);
	update();
    }

    public function setValue(a:int):void { 
	if( a>max ) {
	    a=max;
	}
	if( a<min ) {
	    a=min;
	}
	val=a; 
	update();
    }

    public function value():int {
	return val;
    }

    public function update():void {
	lever.x=XIchi();
	txt.text=label+String(val);
	dispatchEvent(new Event("update",true));
    }

    public function leverNormal():void {
	lever.graphics.clear();
	lever.graphics.lineStyle(1,0x333300);
	lever.graphics.beginFill(0xaa0000);
	lever.graphics.drawRect(0,0,6,18);
	lever.graphics.endFill();	
    }

    public function leverHighlight():void {
	lever.graphics.clear();
	lever.graphics.lineStyle(1,0xaaaa33);
	lever.graphics.beginFill(0xaa0000);
	lever.graphics.drawRect(0,0,6,18);
	lever.graphics.endFill();	
    }

    public function leverInDrag():void {
	lever.graphics.clear();
	lever.graphics.lineStyle(1,0x888800);
	lever.graphics.beginFill(0xee8888);
	lever.graphics.drawRect(0,0,6,18);
	lever.graphics.endFill();
    }
}


class IntTsumami extends Tsumami {
    public function IntTsumami(pp:Sprite,now:int,minimum:int,maximum:int,X:int,Y:int,WW:int,l:String,c:int=0):void {
	super(pp,now,minimum,maximum,X,Y,WW,l,c);
    }
    public function IntValue():int {
	return value();
    }
}


class RealTsumami extends Tsumami {
    private var ratio:Number;
    public function RealTsumami(pp:Sprite,r:Number,now:int,minimum:int,maximum:int,X:int,Y:int,WW:int,l:String,c:int=0):void {
	super(pp,now,minimum,maximum,X,Y,WW,l,c);
	ratio=r;
	update();
    }
    public function RealValue():Number {
	return value()*ratio;
    }
    public override function update():void {
	lever.x=XIchi();
	txt.text=label+String(val*ratio);
	dispatchEvent(new Event("update",true));
    }
}

class Magnet extends Clickable {
    private var cosine:Number ; 
    private var sine:Number ; 
    private var hankei:int;
    private var R:int;
    private var nowTurn:Boolean;

    function Magnet(xx:int, yy:int, pp:Sprite ){ 
	super(pp);
	hankei=5;
	R=30;
	x = xx;
	y = yy;
	cosine = 1.0;
	sine = 0.0;
	nowTurn=false;
	write();
	addEventListener(MouseEvent.MOUSE_OVER,MOver);
	addEventListener(MouseEvent.MOUSE_MOVE,MOver);
	addEventListener(MouseEvent.MOUSE_OUT,MOut);
    }
    
    public function Mark():void {
	graphics.lineStyle(1,0x8888);
	graphics.beginFill(0xaaaaaa);
	graphics.drawRect(-3,-3,6,6);
	graphics.endFill();
    }

    public function TurnMark():void {
	graphics.lineStyle(1,0x8888);
	graphics.beginFill(0xaaaaaa);

	graphics.moveTo(
	    int(  1.5*hankei * sine + (R-hankei/2) * cosine ),
	    int(  -1.5* hankei * cosine + (R-hankei/2)  * sine )) ;
	graphics.lineTo(
	    int(  -1.5*hankei * sine + (R-hankei/2) * cosine ),
	    int( 1.5*hankei * cosine + (R-hankei/2)  * sine )) ;
	graphics.lineTo(
	    int(  -1.5*hankei * sine + (R-hankei) * cosine ),
	    int( 1.5*hankei * cosine + (R-hankei)  * sine )) ;
	graphics.lineTo(
	    int(  -3* hankei * sine + R * cosine ),
	    int( 3*hankei * cosine + R  * sine )) ;
	graphics.lineTo(
	    int(  -1.5*hankei * sine + (R+hankei) * cosine ),
	    int( 1.5*hankei * cosine + (R+hankei)  * sine )) ;
	graphics.lineTo(
	    int(  -1.5*hankei * sine + (R+hankei/2) * cosine ),
	    int( 1.5*hankei * cosine + (R+hankei/2)  * sine )) ;
	graphics.lineTo(
	    int(  1.5*hankei * sine + (R+hankei/2) * cosine ),
	    int( -1.5*hankei * cosine + (R+hankei/2)  * sine )) ;
	graphics.lineTo(
	    int(  1.5*hankei * sine + (R+hankei) * cosine ),
	    int( -1.5*hankei * cosine + (R+hankei)  * sine )) ;
	graphics.lineTo(
	    int(  3* hankei * sine + R * cosine ),
	    int( -3*hankei * cosine + R  * sine )) ;
	graphics.lineTo(
	    int(  1.5*hankei * sine + (R-hankei) * cosine ),
	    int( -1.5*hankei * cosine + (R-hankei)  * sine )) ;
	graphics.lineTo(
	    int(  1.5*hankei * sine + (R-hankei/2) * cosine ),
	    int( -1.5*hankei * cosine + (R-hankei/2)  * sine )) ;

	graphics.endFill();
    }

    public function TurnOn():void {nowTurn=true; write();}
    public function TurnOff():void {nowTurn=false; write();}

    public function MOver(e:MouseEvent):void {
	if( isNPole(e.stageX,e.stageY) || nowTurn ) {
	    TurnMark();
	} else if( isCenter(e.stageX,e.stageY) ) {
	    Mark();
	} else {
	    write();
	}
    }

    public function MOut(e:MouseEvent):void {
	write();
    }

    public function write():void {
	graphics.clear();
	graphics.lineStyle(1,0xff0000);
	graphics.beginFill(0xff0000) ;

	graphics.moveTo(int(  - hankei * sine),int(  + hankei * cosine ) );
	graphics.lineTo(int(  + hankei * sine),int(  - hankei * cosine ) );
	graphics.lineTo(int(  + hankei * sine + ( R + hankei ) * cosine ),
	    int(  - hankei * cosine + ( R + hankei ) * sine )) ;
	graphics.lineTo(int(  - hankei * sine + ( R + hankei ) * cosine ),
	    int(  + hankei * cosine + ( R + hankei ) * sine )) ;
	graphics.endFill();
	graphics.lineStyle(1,0);
	graphics.beginFill(0) ;
	graphics.moveTo(int(  - hankei * sine),int(  + hankei * cosine ) );
	graphics.lineTo(int(  + hankei * sine),int(  - hankei * cosine ) );
	graphics.lineTo(int(  + hankei * sine - ( R + hankei ) * cosine ),
	    int(  - hankei * cosine - ( R + hankei ) * sine )) ;
	graphics.lineTo(int( - hankei * sine - ( R + hankei ) * cosine ),
	    int( + hankei * cosine - ( R + hankei ) * sine )) ;
	graphics.endFill();

	if( nowTurn ) {
	    TurnMark();
	}
    }

    public function X():int { 
	return x ;
    }
    
    public function Y():int { 
	return y ;
    }
    
    public function cos():Number { 
	return cosine ;
    }
    
    public function sin():Number { 
	return sine ;
    }
    
    public function setX( xx:int ):void { 
	x = xx ;
    }
	
    public function setY( yy:int ):void { 
	y = yy ;
    }
    
    public function setCosineSin( c:Number , s:Number ):void { 
	cosine = c ;
	sine = s ;
    }

    public function isCenter( x1:int , y1:int ):Boolean { 
	return ( ( x - x1 ) * ( x - x1 ) + ( y - y1 ) * ( y - y1 ) <= hankei * hankei );
    }

    public function isNPole( x1:int , y1:int ):Boolean { 
	var xx:int = NX();
	var yy:int = NY();
	return ( ( xx - x1 ) * ( xx - x1 ) + ( yy - y1 ) * ( yy - y1 ) <= hankei * hankei );
    }
    public function isSPole( x1:int , y1:int ):Boolean { 
	var xx:int = SX() ;
	var yy:int = SY() ;
	return ( ( xx - x1 ) * ( xx - x1 ) + ( yy - y1 ) * ( yy - y1 ) <= hankei * hankei );
    }
    

    public function NX():int {
	return int(Math.floor(x + R * cosine)) ;
    }
    
    public function NY():int {
	return int(Math.floor(y+ R * sine )) ;
    }

    public function SX():int {
	return int(Math.floor(x - R * cosine)) ;
    }
    
    public function SY():int {
	return int(Math.floor(y- R * sine )) ;
    }

    public function setAngle(xx:int,yy:int):void {
	var YY:Number = Number(( yy - y )) ;
	var XX:Number = Number(( xx - x )) ;
	var RR:Number = Math.sqrt(XX * XX + YY * YY) ;
	cosine=XX / RR;
	sine=YY / RR ;
    }

    public function setPoint(xx:int,yy:int):void {
	x=xx;
	y =yy;
    }
}

