/**
 * Copyright ushisantoasobu ( http://wonderfl.net/user/ushisantoasobu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/87xz
 */

package{
	
	import flash.display.Sprite;
	import flash.display.BitmapData;
	import flash.display.Bitmap;
	import flash.geom.Matrix;
	import flash.events.Event;
	import flash.events.MouseEvent;
	public class BitmapDataSample extends Sprite{
		
		private var bmpdata:BitmapData;
		private var sprite:Sprite;
		private var matrix:Matrix;
		
		public function BitmapDataSample(){
			bmpdata = new BitmapData(465, 465, false, 0);
			addChild(new Bitmap(bmpdata));
			sprite = newFig(0, 0, 40, 0xFFFFFF);
			matrix = new Matrix();
			addEventListener(Event.ENTER_FRAME, enterframe);
			stage.addEventListener(MouseEvent.CLICK, reset);
		}
		
		private function enterframe(e:Event):void{
			matrix.identity();
			var s:Number = Math.random()*1;
			matrix.scale(s, s);
			//matrix.rotate(Math.PI * Math.random() );
			matrix.translate(mouseX, mouseY);	
			bmpdata.draw(sprite, matrix);
		}	
		
		private function reset(e:MouseEvent):void{
			bmpdata.fillRect(bmpdata.rect, 0xFF000000);
		}
		
		private function newFig(cx:Number, cy:Number, size:Number, col:uint):Sprite{
			var shape:Sprite = new Sprite();
			shape.graphics.lineStyle(0, 0x000000, 0.3);
			shape.graphics.beginFill(col);
			shape.graphics.drawCircle(cx, cy, size*0.5);
			shape.graphics.drawCircle(cx, cy, size*0.4);
			var w:Number = size*0.6;
			var h:Number = size*0.15;
			shape.graphics.drawRect(cx-w/2, cy-h/2,w,h);
			shape.graphics.endFill();
			return shape;
		}
	}
}