/**
 * Copyright bongiovi015 ( http://wonderfl.net/user/bongiovi015 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/87rN
 */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.GradientType;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.geom.Vector3D;
    import flash.utils.Timer;
    
    public class FlashTest extends Sprite {
        public static const W : int = 465;
        public static const R : int = 150;
        public static const RECT : Rectangle = new Rectangle(0, 0, W, W);
        public static const COLORS : Array = [0x587b7C, 0x719b9E, 0x9FC1BE, 0xE0D9BB, 0xDACB94, 0xCABA88, 0xDABD55, 0xC49F32, 0xA97409];
        public static const SEED : int = Math.floor( Math.random() * 0xFFFF );
        public static const ROTATION : Number = 2;
        public static const CTRANS : ColorTransform = new ColorTransform(.9, .9, .9, .8);
        public static const BLUR : BlurFilter = new BlurFilter(3, 3, 1);
        
        private var __bmpd : BitmapData = new BitmapData(W, W, true, 0x00000000);
        private var __bmpdPerlin : BitmapData;
        private var __particles : Vector.<Particle> = new Vector.<Particle>;
        private var __offset : Array = [ new Point, new Point ];
        private var __sContainer : Shape = new Shape;
        
        public function FlashTest() {
            var mtx:Matrix = new Matrix;
            mtx.createGradientBox(W, W);
            graphics.beginGradientFill(GradientType.RADIAL, [0x1e1506, 0x000000], [1, 1], [25, 255], mtx);
            graphics.drawRect(0, 0, W, W);
            graphics.endFill();
            
            addChild(new Bitmap(__bmpd));
            __initParticles();
            __initPerlin();

            var timer:Timer = new Timer(200);
            timer.addEventListener(TimerEvent.TIMER, __initPerlin);
            timer.start();

            addEventListener(Event.ENTER_FRAME, render);
        }
        public function render(e:Event) : void {
            __sContainer.graphics.clear();
            
            var p:Particle;
            var pos:Vector3D;
            var posOrg:Vector3D;
            var color:Number;
            var tx:Number, ty:Number;

            for each ( p in __particles) {
                if(stage) {
                    p.matrix.appendRotation((stage.mouseX - stage.stageWidth*.5) / (stage.stageWidth*.5) * ROTATION, Vector3D.Y_AXIS);
                    p.matrix.appendRotation( - (stage.mouseY - stage.stageHeight*.5) / (stage.stageHeight*.5) * ROTATION, Vector3D.X_AXIS);
                }
                pos = p.matrix.position;
                posOrg = p.mtxOrg.position;
                if(pos.z > 0) {
                    tx = Math.asin( posOrg.x / R ) / Math.PI + .5;
                    ty = Math.asin( posOrg.y / R ) / Math.PI + .5;

                    color = __bmpdPerlin.getPixel(tx*W*.5, ty*W*.5);
                    color /= 0xFF;
                    color = Math.pow(color, 5) * 14;

                    var bColor:uint = brightnessColor(p.color, 1 - Math.sqrt( Math.pow(pos.x, 2) + Math.pow(pos.y, 2) ) / 250);
                    __sContainer.graphics.beginFill(bColor);
                    __sContainer.graphics.drawCircle(pos.x+W*.5, pos.y+W*.5, color);
                    __sContainer.graphics.endFill();
                }
            }
            
            
            __bmpd.lock();
            __bmpd.applyFilter(__bmpd, RECT, new Point, BLUR);
            __bmpd.colorTransform(RECT, CTRANS);
            __bmpd.draw(__sContainer);
            __bmpd.unlock();
        }

        
        private function __initParticles() : void {
            const TOTAL:int = 72; 
            const DIS:int = 360 / TOTAL;
            var i:int, j:int;


            for (j=0; j<TOTAL*.5; j++ ) {
                for (i=0; i<TOTAL; i++ ) {
                    var p:Particle = new Particle();
                    p.matrix.identity();
                    p.matrix.appendTranslation(R, 0, 0);
                    p.matrix.appendRotation(i*DIS, Vector3D.Z_AXIS);
                    p.matrix.appendRotation(j*DIS, Vector3D.Y_AXIS);

                    p.mtxOrg.appendTranslation(R, 0, 0);
                    p.mtxOrg.appendRotation(i*DIS, Vector3D.Z_AXIS);
                    p.mtxOrg.appendRotation(j*DIS, Vector3D.Y_AXIS);

                    p.color = getRandomColor(COLORS);
                    __particles.push(p);
                }
            }
        }

        
        private function __initPerlin(e:Event=null) : void {
            if(__bmpdPerlin == null) __bmpdPerlin = new BitmapData(W*.5, W*.5);
            __bmpdPerlin.perlinNoise(W*.5, W*.5, 8, SEED, false, true, 4, false, __offset);
            __offset[0].x += 2;
            __offset[1].y += 2;
        }

        
        public static function getRandomColor(colors:Array) : uint {
            return colors[int(Math.random() * colors.length)];
        }
        
        
        public static function brightnessColor(color:uint, level:Number) : uint {
            var a:uint = color >> 24 & 0xFF; 
            var r:uint = color >> 16 & 0xFF; 
            var g:uint = color >> 8 & 0xFF; 
            var b:uint = color & 0xFF;
            
            r *= level;
            g *= level;
            b *= level;
            
            if(r > 0xFF) r = 0xFF;
            if(g > 0xFF) g = 0xFF;
            if(b > 0xFF) b = 0xFF;
            
            var newColor:uint = a << 24 | r << 16 | g << 8 | b;
            return newColor;
        }

    }

}


import flash.geom.Matrix3D;

class Particle {
    public var matrix : Matrix3D = new Matrix3D;
    public var mtxOrg : Matrix3D = new Matrix3D;
    public var color : uint;
}