/**
 * Copyright itou_hiroki ( http://wonderfl.net/user/itou_hiroki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/87Iz
 */

// -*- coding:utf-8-unix -*- encoding: utf8 -*-
// Copyright (c) 2010 Itou Hiroki
// ChangeLog
// - Ctrl+PまたはF9による全角英数への変換に対応した(ただし1文字単位の変換)。これでビックリマークや？を問題に追加できる。
// - BackSpaceまたはCtrl+Hが効くようになった。
// - キーボードの配置を変更する
// - [F1] - [F12] も表示する。
// - 表示と入力を「英数字」から「かな入力」に変更した。
// Todo
// - 文字出力幅が知りたい。fontsize * charnumもできるけど。
// - e-typingかな　をまねる。
// - 漢字表示は要らない。ひらがな表示の行と、Ctrl+Pなどを示す。
// 「入力文字」を表示するのは必要。F8とかで入力文字を変更したいから。
// - タイピング: 画面最上段に問題表示(漢字と、かな　のみの2行)。
//               次に入力文字。まちがえたら BS する。入力終わればEnter押す。
//               その下にキーボード。
// NotToDo
// - Shiftの右と左を両方押して離すとShift残りが発生するが、両方押すことが起きることはめったにないのでよしとする。
// - 全角カタカナへの変換(Ctrl+IまたはF7)は1文字ずつだけできる。複数文字まとめてカタカナにできない。これ以上対応しない。
// - 半角英数への変換(Ctrl+TまたはF10)は、F10がなぜかFlashから取得できないので、Ctrl+Tでないとできない。これ以上対応しない。



package {
    import flash.display.Sprite;
    import flash.display.*;
    import flash.events.*;
    import flash.text.*;
    import flash.ui.KeyLocation;
    import flash.system.IME;
    import flash.filters.*;
    
    [SWF(width="465",height="465",backgroundColor="0x888888",frameRate="60")]
    
    public class FlashTest extends Sprite {
        private const KEY_PADDING:uint = 2;
        private const KEY_AREA:uint = 30;
        private const KEY_COLOR:int = 0xeee8e8;
        private const KEY_TRANCEPARENCY:Number = 1.0;
        private const KEY_HIT_COLOR:int = 0xffcc00;
        private const KEY_HIT_TRANCEPARENCY:Number = 0.5;
        private const KEY_COLOR_OUTLINE:int = 0x333333;
        private const KEY_CHAR_COLOR:int = 0x333333;
        private const MAX_BOARD_LENGTH:int = 10;
        private const KEYCODE_SHIFT_RIGHT:int = 255;
        private const FONT_INPUTTEXT_COLOR:int = 0xaaaaaa;
        private const FONT_INPUTTEXT_LASTCHAR_COLOR:int = 0x116611;
        private const FONT_INPUTTEXT_MODIFY_COLOR:int = 0xcc3333;
        private var code:Array = new Array();
        private var keys:Array = new Array();
        private var brd:TextField = new TextField();
        private var qst:TextField = new TextField();
        private var raw_text:Array = [];
        private var rawInput2Zenkaku:Array = [];
        private var tfm_new:TextFormat = new TextFormat();
        private var hiragana2katakana:Array = [];
        private var keys_change:Boolean = true; //一回BackSpaceしたら、そのあと文字種変換をできなくする
        public function FlashTest() {
            var i:int;
            // write as3 code here..
            if (IME.enabled){
                IME.enabled = false;
            }
            make_japanese_keyboard_obj(10, 270);
            make_board(20, 50);
    
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
            stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
        }
    
        private function onKeyDown(e:KeyboardEvent):void {
            var kc:uint = e.keyCode;
            var i:int;
            //trace('onKeyDown:', e.keyCode);
            //IMEをONにしようとしたなら、OFFにする
            if (IME.enabled){
                IME.enabled = false;
            }
            // '229' is HanZen or IME enable key
            if (keys[kc] === null || kc === 229){ return; }
            //右shift
            //trace('down keyloc=',e.keyLocation);
            if (kc === 16 && e.keyLocation === KeyLocation.RIGHT) { kc = KEYCODE_SHIFT_RIGHT; }
    
            keys[kc].pushed = true;
            addChild(keys[kc].hit);
    
            //16 or KEYCODE_SHIFT_RIGHT is 'Shift'
            if (keys[16].pushed || keys[KEYCODE_SHIFT_RIGHT].pushed){
                for (i=0; i<code.length; i++){
                    keys[code[i]].textfield.text = keys[code[i]].kana_display_shift;
                }
                put_char_on_board(keys[kc].kana_input_shift, keys[kc].char_input_shift);

            //8 is BackSpace,  17 is Ctrl and 72 is 'H'
            }else if (keys[8].pushed || keys[17].pushed && keys[72].pushed) {
                put_char_on_board('BackSpace', '');
                keys_change = false;

            //120 is 'F9',  17 is Ctrl and 80 is 'P'
            }else if (keys[120].pushed || keys[17].pushed && keys[80].pushed) {
                put_char_on_board('ReplaceZenkakuAlnum', '');
            //121 is 'F10',  17 is Ctrl and 84 is 'T'
            }else if (keys[121].pushed || keys[17].pushed && keys[84].pushed) {
                put_char_on_board('ReplaceHankakuAlnum', '');
            //118 is 'F7',  17 is Ctrl and 73 is 'I'
            }else if (keys[120].pushed || keys[17].pushed && keys[73].pushed) {
                put_char_on_board('ReplaceZenkakuKatakana', '');
            }else{
                // Ctrl 押したまま、それ以外のキーを入力したとき、文字が入力されるのを防ぐ
                for (i=0; i<code.length; i++){
                    if (keys[code[i]].pushed && keys[code[i]].char_input === 'NULL'){ return; }
                }
                keys_change = true;
                put_char_on_board(keys[kc].kana_input, keys[kc].char_input);
            }
        }
    
        private function onKeyUp(e:KeyboardEvent):void {
            var kc:uint = e.keyCode;
            var i:int;
            //trace('onKeyUp:', e.keyCode);
            //IMEをONにしようとしたなら、OFFにする
            if (IME.enabled){
                IME.enabled = false;
            }
            // '243' is HanZen key up code
            if (keys[kc] === null || kc === 243){ return ; }
            //右shift
            if (kc === 16){
                //trace('up keyloc=',e.keyLocation);
                //右シフト押したまま文字キーを押して離して、それから右シフト離したときに
                // e.keyLocationが2にならず0になるのはなぜだAdobe in FlashPlayer10.0.42.34
                if (e.keyLocation === KeyLocation.RIGHT || keys[KEYCODE_SHIFT_RIGHT].pushed) {
                    kc = KEYCODE_SHIFT_RIGHT;
                }
            }
    
            if (keys[kc].pushed){
                removeChild(keys[kc].hit);
                keys[kc].pushed = false;
            }
    
            //16 or KEYCODE_SHIFT_RIGHT is 'Shift'
            if (! keys[16].pushed && ! keys[KEYCODE_SHIFT_RIGHT].pushed){
                for (i=0; i<code.length; i++){
                    keys[code[i]].textfield.text = keys[code[i]].kana_display;
                }
            }
            // '229' is HanZen or IME enable key
            if (keys[229].pushed){
                removeChild(keys[229].hit);
                keys[229].pushed = false;
            }
        }


        private function make_board(_x:int, _y:int):void {
            //make board
            var fontsize:uint = 32;
            var i:int;

            var obj:Sprite = new Sprite();
            obj.graphics.lineStyle(1,0x000000);
            obj.graphics.beginFill(0xeeeeee,1);
            obj.graphics.drawRect(_x,_y,
                                  stage.stageWidth - _x*2, fontsize*5);
            obj.graphics.endFill();
            addChild(obj);

            //set input characters font
            brd.x = _x;
            brd.y = _y+fontsize*2;
            brd.width = stage.stageWidth - 20*2;
            brd.height = _y;
            //brd.border = true;
            //brd.borderColor = 0xffcc00;
            //brd.background = true;
            //brd.backgroundColor = 0xffffff;
            //brd.border = true;
            //brd.multiline = true;
            //brd.wordWrap = true;
            brd.autoSize = TextFieldAutoSize.RIGHT;
            brd.antiAliasType = flash.text.AntiAliasType.ADVANCED;
            var tfm:TextFormat = new TextFormat();
            tfm.font = 'Verdana';
            tfm.size = fontsize;
            tfm.color=FONT_INPUTTEXT_COLOR;
            brd.defaultTextFormat = tfm;
            var flt:DropShadowFilter = new DropShadowFilter(2,45,0x333333, 0.2);
            brd.filters = [flt];
            addChild(brd);
        }
    
        private function put_char_on_board(_char:String, _raw:String):void {
            if (_char === 'NULL') { return; }
            else if (_char === 'Space') { _char = ' '; }

            var str:String = '';
            if (_char === 'BackSpace') {
                //文字を削除
                if (brd.text.length <= 0) { return; }
                brd.text = brd.text.substr(0, str.length - 1);
                raw_text.pop();
            }else if (keys_change === false){
                return;
            }else if (_char === 'ReplaceZenkakuAlnum') {
                //文字を置き換え (全角英数)
                if (brd.text.length <= 0) { return; }
                str = brd.text.substr(0, str.length - 1);
                brd.text = str + rawInput2Zenkaku[raw_text[raw_text.length-1]];

                tfm_new.color = FONT_INPUTTEXT_MODIFY_COLOR;
                brd.setTextFormat(tfm_new, brd.text.length-1);

            }else if (_char === 'ReplaceHankakuAlnum') {
                //文字を置き換え (半角英数)
                if (brd.text.length <= 0) { return; }
                str = brd.text.substr(0, str.length - 1);
                brd.text = str + raw_text[raw_text.length-1];

                tfm_new.color = FONT_INPUTTEXT_MODIFY_COLOR;
                brd.setTextFormat(tfm_new, brd.text.length-1);

            }else if (_char === 'ReplaceZenkakuKatakana') {
                //文字を置き換え (全角カタカナ)
                if (brd.text.length <= 0) { return; }
                var lastkana:String = brd.text.substr(str.length - 1);
                if (hiragana2katakana[lastkana]){
                    str = brd.text.substr(0, str.length - 1);
                    brd.text = str + hiragana2katakana[lastkana];
                    trace('hiragana2katakana[lastkana]=', hiragana2katakana[lastkana]);
                }

                tfm_new.color = FONT_INPUTTEXT_MODIFY_COLOR;
                brd.setTextFormat(tfm_new, brd.text.length-1);

            }else{
                //文字を追加
                str = brd.text + _char;
                if (str.length > MAX_BOARD_LENGTH) {
                    brd.text = str.substr(str.length - MAX_BOARD_LENGTH);
                }else{
                    brd.text = str;
                }

                tfm_new.color = FONT_INPUTTEXT_LASTCHAR_COLOR;
                brd.setTextFormat(tfm_new, brd.text.length-1);

                raw_text.push(_raw);
                if (raw_text.length > MAX_BOARD_LENGTH){
                    raw_text.slice(str.length - MAX_BOARD_LENGTH);
                }
            }
        }
    
        private function add_text_on_key(_tfd:TextField, _char:String, _x:int,_y:int):void {
            var tfm:TextFormat = new TextFormat();
            tfm.font = "Verdana";
            if (_char.length > 1){
                tfm.size = 12;
                _tfd.x = _x;
                _tfd.y = _y;
            }else{
                tfm.size = 18;
                _tfd.x = _x + KEY_PADDING;
                _tfd.y = _y - KEY_PADDING;
            }
            tfm.color = KEY_CHAR_COLOR;
            //_tfd.antiAliasType = flash.text.AntiAliasType.ADVANCED;
            _tfd.autoSize = TextFieldAutoSize.LEFT;
            _tfd.defaultTextFormat = tfm;
            if (_char != 'Space'){
                _tfd.text = _char;
            }
        }
    
        private function make_japanese_keyboard_obj(_x:int, _y:int):void {
            var i:int;
            var tfd:TextField;
            var key_str:String = '';
            var key_ary:Array  = [];
    
            //http://livedocs.adobe.com/flex/3_jp/langref/flash/events/KeyboardEvent.html
            key_str  = '27 112 113 114 115 116 117 118 119 120 121 122 123 ';
            key_str += '229 49 50 51 52 53 54 55 56 57 48 189 222 220 8 ';
            key_str += '9 81 87 69 82 84 89 85 73 79 80 192 219 13 ';
            key_str += '20 65 83 68 70 71 72 74 75 76 187 186 221 ';
            key_str += '16 90 88 67 86 66 78 77 188 190 191 226 ' + KEYCODE_SHIFT_RIGHT + ' ';
            key_str += '17 29 32 28';
            code = key_str.split(' ');
    
            key_str  = 'Esc F1 F2 F3 F4 F5 F6 F7 F8 F9 F10 F11 F12 ';
            key_str += 'HanZen Num1 Num2 Num3 Num4 Num5 Num6 Num7 Num8 Num9 Num0 Minus Accent Yen BackSpace ';
            key_str += 'Tab Q W E R T Y U I O P AtMark LeftBracket Enter ';
            key_str += 'Eisuu A S D F G H J K L SemiColon Colon RightBracket ';
            key_str += 'Shift Z X C V B N M Comma Period Slash Backslash RightShift ';
            key_str += 'Ctrl NoConvert Space Convert';
            var charNameJP:Array = key_str.split(' ');

            key_str  = 'Esc F1 F2 F3 F4 F5 F6 F7 F8 F9 F10 F11 F12 ';
            key_str += '半全 1 2 3 4 5 6 7 8 9 0 - ^ ￥ BS ';
            key_str += 'Tab q w e r t y u i o p @ [ Enter ';
            key_str += '英数 a s d f g h j k l ; : ] ';
            key_str += 'Shift z x c v b n m , . / \\ Shift ';
            key_str += 'Ctrl 無変換 　 変換'; //全角空白使ってます
            var keycap:Array = key_str.split(' ');
    
            key_str  = 'Esc F1 F2 F3 F4 F5 F6 F7 F8 F9 F10 F11 F12 ';
            key_str += '半全 ! " # $ % & \' ( ) 　 = ~ | BS '; //全角空白使ってます
            key_str += 'Tab Q W E R T Y U I O P ` { Enter ';
            key_str += '英数 A S D F G H J K L + * } ';
            key_str += 'Shift Z X C V B N M < > ? _ Shift ';
            key_str += 'Ctrl 無変換 　 変換'; //全角空白使ってます
            var keycap_shift:Array = key_str.split(' ');

            key_str  = 'NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL ';
            key_str += 'NULL 1 2 3 4 5 6 7 8 9 0 - ^ ￥ BackSpace ';
            key_str += 'Space q w e r t y u i o p @ [ NULL ';
            key_str += 'NULL a s d f g h j k l ; : ] ';
            key_str += 'NULL z x c v b n m , . / \\ NULL ';
            key_str += 'NULL NULL Space NULL';
            var output:Array = key_str.split(' ');
    
            key_str  = 'NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL ';
            key_str += 'NULL ! " # $ % & \' ( ) NULL = ~ | BackSpace ';
            key_str += 'Space Q W E R T Y U I O P ` { NULL ';
            key_str += 'NULL A S D F G H J K L + * } ';
            key_str += 'NULL Z X C V B N M < > ? _ NULL ';
            key_str += 'NULL NULL Space NULL';
            var output_shift:Array = key_str.split(' ');

            key_str  = 'Esc F1 F2 F3 F4 F5 F6 F7 F8 F9 F10 F11 F12 ';
            key_str += '半全 ぬ ふ あ う え お や ゆ よ わ ほ へ ー BS ';
            key_str += 'Tab た て い す か ん な に ら せ ゛ ゜ Enter ';
            key_str += '英数 ち と し は き く ま の り れ け む ';
            key_str += 'Shift つ さ そ ひ こ み も ね る め ろ Shift ';
            key_str += 'Ctrl 無変換 　 変換'; //全角空白使ってます
            var keycap_kana:Array = key_str.split(' ');

            key_str  = 'Esc F1 F2 F3 F4 F5 F6 F7 F8 F9 F10 F11 F12 ';
            key_str += '半全 ぬ ふ ぁ ぅ ぇ ぉ ゃ ゅ ょ を ほ ゑ ー BS ';
            key_str += 'Tab た て ぃ す か ん な に ら せ ゛ 「 Enter ';
            key_str += '英数 ち と し は き く ま の り れ け 」 ';
            key_str += 'Shift っ さ そ ゐ こ み も 、 。 ・ ろ Shift ';
            key_str += 'Ctrl 無変換 　 変換'; //全角空白使ってます
            var keycap_kana_shift:Array = key_str.split(' ');
    
            key_str  = 'NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL ';
            key_str += 'NULL ぬ ふ あ う え お や ゆ よ わ ほ へ ー BackSpace ';
            key_str += 'Space た て い す か ん な に ら せ ゛ ゜ NULL ';
            key_str += 'NULL ち と し は き く ま の り れ け む ';
            key_str += 'NULL つ さ そ ひ こ み も ね る め ろ NULL ';
            key_str += 'NULL NULL Space NULL';
            var output_kana:Array = key_str.split(' ');

            key_str  = 'NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL ';
            key_str += 'NULL ぬ ふ ぁ ぅ ぇ ぉ ゃ ゅ ょ を ほ ゑ ー BackSpace ';
            key_str += 'Space た て ぃ す か ん な に ら せ ゛ 「 NULL ';
            key_str += 'NULL ち と し は き く ま の り れ け 」 ';
            key_str += 'NULL っ さ そ ゐ こ み も 、 。 ・ ろ NULL ';
            key_str += 'NULL NULL Space NULL';
            var output_kana_shift:Array = key_str.split(' ');

            key_str  = 'NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL ';
            key_str += 'NULL １ ２ ３ ４ ５ ６ ７ ８ ９ ０ － ＾ ￥ BackSpace ';
            key_str += 'Space ｑ ｗ ｅ ｒ ｔ ｙ ｕ ｉ ｏ ｐ ＠ ［ NULL ';
            key_str += 'NULL ａ ｓ ｄ ｆ ｇ ｈ ｊ ｋ ｌ ； ： ］ ';
            key_str += 'NULL ｚ ｘ ｃ ｖ ｂ ｎ ｍ ， ． ／ ￥ NULL ';
            key_str += 'NULL NULL Space NULL';
            var output_zenkaku:Array = key_str.split(' ');

            key_str  = 'NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL ';
            key_str += 'NULL ！ ” ＃ ＄ ％ ＆ ’ （ ） を ＝ ～ ｜ BackSpace ';
            key_str += 'Space Ｑ Ｗ Ｅ Ｒ Ｔ Ｙ Ｕ Ｉ Ｏ ｐ ＠ ｛ NULL ';
            key_str += 'NULL Ａ Ｓ Ｄ Ｆ Ｇ Ｈ Ｊ Ｋ Ｌ ＋ ＊ ｝ ';
            key_str += 'NULL Ｚ Ｘ Ｃ Ｖ Ｂ Ｎ Ｍ ＜ ＞ ？ ＿ NULL ';
            key_str += 'NULL NULL Space NULL';
            var output_zenkaku_shift:Array = key_str.split(' ');

            for (i=0; i<output.length; i++){
                rawInput2Zenkaku[output[i]] = output_zenkaku[i];
            }
            for (i=0; i<output_shift.length; i++){
                rawInput2Zenkaku[output_shift[i]] = output_zenkaku_shift[i];
            }

            var hiragana:Array = 'あ い う え お か き く け こ さ し す せ そ た ち つ て と な に ぬ ね の は ひ ふ へ ほ ま み む め も や ゆ よ わ を ん ぁ ぃ ぅ ぇ ぉ っ ゃ ゅ ょ'.split(' ');
            var katakana:Array = 'ア イ ウ エ オ カ キ ク ケ コ サ シ ス セ ソ タ チ ツ テ ト ナ ニ ヌ ネ ノ ハ ヒ フ ヘ ホ マ ミ ム メ モ ヤ ユ ヨ ワ ヲ ン ァ ィ ゥ ェ ォ ッ ャ ュ ョ'.split(' ');
            for (i=0; i<hiragana.length; i++){
                hiragana2katakana[hiragana[i]] = katakana[i];
            }

            //key_str  = 'NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL ';
            //key_str += 'NULL 1 2 3 4 5 6 7 8 9 0 - ^ \\ BackSpace ';
            //key_str += 'Space q w e r t y u i o p @ [ NULL ';
            //key_str += 'NULL a s d f g h j k l ; : ] ';
            //key_str += 'NULL z x c v b n m , . / \\ NULL ';
            //key_str += 'NULL NULL Space NULL';
            //var output_Hankaku:Array = key_str.split(' ');
            //
            //key_str  = 'NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL ';
            //key_str += 'NULL ! " # $ % & \' ( ) を = ~ | BackSpace ';
            //key_str += 'Space Q W E R T Y U I O p @ { NULL ';
            //key_str += 'NULL A S D F G H J K L + * } ';
            //key_str += 'NULL Z X C V B N M < > ? _ NULL ';
            //key_str += 'NULL NULL Space NULL';
            //var output_Hankaku_shift:Array = key_str.split(' ');

            var w:uint = KEY_AREA;
            key_ary = [];
    
            //ESC
            var y:int = 0;
            var x:int = 0;
            key_ary.push([x,y,w]);

            //Functionキー
            x = w*2;
            key_ary.push(
                [x,y,'Func'],[x+w,y,'Func'],[x+w*2,y,'Func'],[x+w*3,y,'Func'],[x+w*4+w/2,y,'Func'],
                [x+w*5+w/2,y,'Func'],[x+w*6+w/2,y,'Func'],[x+w*7+w/2,y,'Func'],[x+w*8+w,y,'Func'],[x+w*9+w,y,'Func'],
                [x+w*10+w,y,'Func'],[x+w*11+w,y,'Func']
                );

            //数字の段 (半角全角とBackSpace含む)(含めていいのは幅が同じだから)
            //    キーボード横幅は 数字段で、15個。
            //    (画面横幅pixel)465÷15=31 余白を考えて1key 30pxで使う
            y = w*1;
            x = 0;
            key_ary.push(
                [x,y,w],[x+w,y,w],[x+w*2,y,w],[x+w*3,y,w],[x+w*4,y,w],
                [x+w*5,y,w],[x+w*6,y,w],[x+w*7,y,w],[x+w*8,y,w],[x+w*9,y,w],
                [x+w*10,y,w],[x+w*11,y,w],[x+w*12,y,w],[x+w*13,y,w],[x+w*14,y,w]
                );
    
            //TAB
            y = w*2;
            x = 0;
            key_ary.push([x,y,w+w/2]);
            //QWERTYの段
            x = w+w/2;
            key_ary.push(
                [x,y,w],[x+w,y,w],[x+w*2,y,w],[x+w*3,y,w],[x+w*4,y,w],
                [x+w*5,y,w],[x+w*6,y,w],[x+w*7,y,w],[x+w*8,y,w],[x+w*9,y,w],
                [x+w*10,y,w],[x+w*11,y,w]
                );
            //Enter (日本語キーボードの場合ここに来る)(英語キーボードならもう一つ下なんだけど)
            x = x+w*12;
            key_ary.push([x,y,'ENTER']);
    
            //Eisuu
            y = w*3;
            x = 0;
            key_ary.push([x,y,w+w/2+Math.floor(w/4)]);
            //ASDFの段
            x = w+w/2+Math.floor(w/4);
            key_ary.push(
                [x,y,w],[x+w,y,w],[x+w*2,y,w],[x+w*3,y,w],[x+w*4,y,w],
                [x+w*5,y,w],[x+w*6,y,w],[x+w*7,y,w],[x+w*8,y,w],[x+w*9,y,w],
                [x+w*10,y,w],[x+w*11,y,w]
                );
    
            //Shift
            y = w*4;
            x = 0;
            key_ary.push([x,y, w+w/2+Math.floor(w/4)+w/2]);
            //ZXCVの段
            x = w+w/2+Math.floor(w/4)+w/2;
            key_ary.push(
                [x,y,w],[x+w,y,w],[x+w*2,y,w],[x+w*3,y,w],[x+w*4,y,w],
                [x+w*5,y,w],[x+w*6,y,w],[x+w*7,y,w],[x+w*8,y,w],[x+w*9,y,w],
                [x+w*10,y,w]
                );
            //RightShift
            var x_shift_rightside:int = x+w*11;
            x = x+w*11;
            key_ary.push([x,y, w*15 - x_shift_rightside]);
    
            //Ctrl
            y = w*5;
            x = 0;
            key_ary.push([x,y,w+w/2]); //Tabと同じ幅
            //NoConvert
            x = w+w/2+Math.floor(w/4)+w/2 + w + w - Math.floor(w/4);
            key_ary.push([x,y,w+w/2]); //Tabと同じ幅
            //Space
            x = w+w/2+Math.floor(w/4)+w/2 + w + w - Math.floor(w/4) + w+w/2;
            key_ary.push([x,y,w+w+w/2]); //2.5キーぶんの幅
            //Convert
            x = w+w/2+Math.floor(w/4)+w/2 + w + w - Math.floor(w/4) + w+w/2 + w+w+w/2;
            key_ary.push([x,y,w+w/2]); //Tabと同じ幅
    
            for (i=0; i<code.length; i++) {
                x = key_ary[i][0] + _x;
                y = key_ary[i][1] + _y;
    
                tfd = new TextField();
                var spr_key:Sprite = new Sprite();
                var spr_hit:Sprite = new Sprite();
    
                if (key_ary[i][2]==='ENTER') {
                    make_enterkey_image(spr_key, x,y, KEY_COLOR,KEY_TRANCEPARENCY);
                    addChild(spr_key);
    
                    add_text_on_key(tfd, keycap_kana[i], x,y);
                    addChild(tfd);
    
                    make_enterkey_image(spr_hit, x,y, KEY_HIT_COLOR,KEY_HIT_TRANCEPARENCY);
                }else if (key_ary[i][2]==='Func') {
                    make_funckey_image(spr_key, x,y, KEY_COLOR,KEY_TRANCEPARENCY);
                    addChild(spr_key);
    
                    add_text_on_key(tfd, keycap_kana[i], x,y);
                    addChild(tfd);
    
                    make_funckey_image(spr_hit, x,y, KEY_HIT_COLOR,KEY_HIT_TRANCEPARENCY);

                }else{
                    make_key_image(spr_key, x,y, key_ary[i][2], KEY_COLOR,KEY_TRANCEPARENCY);
                    addChild(spr_key);
    
                    add_text_on_key(tfd, keycap_kana[i], x,y);
                    addChild(tfd);
    
                    make_key_image(spr_hit, x,y, key_ary[i][2], KEY_HIT_COLOR,KEY_HIT_TRANCEPARENCY);
                }
                keys[code[i]] = [];
                keys[code[i]].x = x;
                keys[code[i]].y = y;
                keys[code[i]].key = spr_key;
                keys[code[i]].hit = spr_hit;
                keys[code[i]].textfield = tfd;
                keys[code[i]].name = charNameJP[i];
                keys[code[i]].pushed = false;
                keys[code[i]].char_display = keycap[i];
                keys[code[i]].char_display_shift = keycap_shift[i];
                keys[code[i]].char_input = output[i];
                keys[code[i]].char_input_shift = output_shift[i];
                keys[code[i]].kana_display = keycap_kana[i];
                keys[code[i]].kana_display_shift = keycap_kana_shift[i];
                keys[code[i]].kana_input = output_kana[i];
                keys[code[i]].kana_input_shift = output_kana_shift[i];
                
            }
            for (i=0; i<=255; i++) {
                if (keys[i] === undefined){
                    keys[i] = null;
                }
            }
        }
    
        private function make_key_image(_obj:Sprite, _x:int,_y:int, _w:int, _col:int,_tp:Number):void {
            //http://livedocs.adobe.com/flex/3_jp/langref/flash/display/Graphics.html
            _obj.graphics.lineStyle(1,KEY_COLOR_OUTLINE);
            _obj.graphics.beginFill(_col,_tp);
            _obj.graphics.drawRect(_x,_y,
                                   _w-KEY_PADDING*2,KEY_AREA-KEY_PADDING*2);
            _obj.graphics.endFill();
        }
        private function make_funckey_image(_obj:Sprite, _x:int,_y:int, _col:int,_tp:Number):void {
            _obj.graphics.lineStyle(1,KEY_COLOR_OUTLINE);
            _obj.graphics.beginFill(_col,_tp);
            _obj.graphics.drawRect(_x,_y,
                                   KEY_AREA-KEY_PADDING*2,(KEY_AREA-KEY_PADDING*2)*3/4);
            _obj.graphics.endFill();
        }
        private function make_enterkey_image(_obj:Sprite, _x:int,_y:int, _col:int,_tp:Number):void {
            _obj.graphics.lineStyle(0,KEY_COLOR_OUTLINE);
            _obj.graphics.beginFill(_col,_tp);
            _obj.graphics.moveTo(_x,_y);
            //→
            _obj.graphics.lineTo(_x + KEY_AREA + Math.floor(KEY_AREA/4) + KEY_PADDING*2,
                                 _y);
            //↓
            _obj.graphics.lineTo(_x + KEY_AREA + Math.floor(KEY_AREA/4) + KEY_PADDING*2,
                                 _y + KEY_AREA-KEY_PADDING*2 + KEY_AREA-KEY_PADDING*2 + (KEY_PADDING*2));
            //←
            _obj.graphics.lineTo(_x+Math.floor(KEY_AREA/4),
                                 _y + KEY_AREA-KEY_PADDING*2 + KEY_AREA-KEY_PADDING*2 + (KEY_PADDING*2));
            //↑
            _obj.graphics.lineTo(_x+Math.floor(KEY_AREA/4),
                                 _y + KEY_AREA-KEY_PADDING*2);
            //←
            _obj.graphics.lineTo(_x,
                                 _y + KEY_AREA-KEY_PADDING*2);
            //↑
            _obj.graphics.lineTo(_x,_y);
            _obj.graphics.endFill();
        }
    }//class
}//package


{
    class KeyboardJP106 extends Sprite {
        private var code:Array;

        public function KeyboardJP106() {
            set_keyboard();
        }
        private function set_keyboard():void {
             //http://livedocs.adobe.com/flex/3_jp/langref/flash/events/KeyboardEvent.html
            key_str  = '27 112 113 114 115 116 117 118 119 120 121 122 123 ';
            key_str += '229 49 50 51 52 53 54 55 56 57 48 189 222 220 8 ';
            key_str += '9 81 87 69 82 84 89 85 73 79 80 192 219 13 ';
            key_str += '20 65 83 68 70 71 72 74 75 76 187 186 221 ';
            key_str += '16 90 88 67 86 66 78 77 188 190 191 226 ' + KEYCODE_SHIFT_RIGHT + ' ';
            key_str += '17 29 32 28';
            code = key_str.split(' ');
    
            //key_str  = 'Esc F1 F2 F3 F4 F5 F6 F7 F8 F9 F10 F11 F12 ';
            //key_str += 'HanZen Num1 Num2 Num3 Num4 Num5 Num6 Num7 Num8 Num9 Num0 Minus Accent Yen BackSpace ';
            //key_str += 'Tab Q W E R T Y U I O P AtMark LeftBracket Enter ';
            //key_str += 'Eisuu A S D F G H J K L SemiColon Colon RightBracket ';
            //key_str += 'Shift Z X C V B N M Comma Period Slash Backslash RightShift ';
            //key_str += 'Ctrl NoConvert Space Convert';
            //var charNameJP:Array = key_str.split(' ');

            key_str  = 'Esc F1 F2 F3 F4 F5 F6 F7 F8 F9 F10 F11 F12 ';
            key_str += '半全 1 2 3 4 5 6 7 8 9 0 - ^ ￥ BS ';
            key_str += 'Tab q w e r t y u i o p @ [ Enter ';
            key_str += '英数 a s d f g h j k l ; : ] ';
            key_str += 'Shift z x c v b n m , . / \\ Shift ';
            key_str += 'Ctrl 無変換 　 変換'; //全角空白使ってます
            var keycap:Array = key_str.split(' ');
    
            key_str  = 'Esc F1 F2 F3 F4 F5 F6 F7 F8 F9 F10 F11 F12 ';
            key_str += '半全 ! " # $ % & \' ( ) 　 = ~ | BS '; //全角空白使ってます
            key_str += 'Tab Q W E R T Y U I O P ` { Enter ';
            key_str += '英数 A S D F G H J K L + * } ';
            key_str += 'Shift Z X C V B N M < > ? _ Shift ';
            key_str += 'Ctrl 無変換 　 変換'; //全角空白使ってます
            var keycap_shift:Array = key_str.split(' ');

            key_str  = 'NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL ';
            key_str += 'NULL 1 2 3 4 5 6 7 8 9 0 - ^ ￥ BackSpace ';
            key_str += 'Space q w e r t y u i o p @ [ NULL ';
            key_str += 'NULL a s d f g h j k l ; : ] ';
            key_str += 'NULL z x c v b n m , . / \\ NULL ';
            key_str += 'NULL NULL Space NULL';
            var output:Array = key_str.split(' ');
    
            key_str  = 'NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL ';
            key_str += 'NULL ! " # $ % & \' ( ) NULL = ~ | BackSpace ';
            key_str += 'Space Q W E R T Y U I O P ` { NULL ';
            key_str += 'NULL A S D F G H J K L + * } ';
            key_str += 'NULL Z X C V B N M < > ? _ NULL ';
            key_str += 'NULL NULL Space NULL';
            var output_shift:Array = key_str.split(' ');

            key_str  = 'Esc F1 F2 F3 F4 F5 F6 F7 F8 F9 F10 F11 F12 ';
            key_str += '半全 ぬ ふ あ う え お や ゆ よ わ ほ へ ー BS ';
            key_str += 'Tab た て い す か ん な に ら せ ゛ ゜ Enter ';
            key_str += '英数 ち と し は き く ま の り れ け む ';
            key_str += 'Shift つ さ そ ひ こ み も ね る め ろ Shift ';
            key_str += 'Ctrl 無変換 　 変換'; //全角空白使ってます
            var keycap_kana:Array = key_str.split(' ');

            key_str  = 'Esc F1 F2 F3 F4 F5 F6 F7 F8 F9 F10 F11 F12 ';
            key_str += '半全 ぬ ふ ぁ ぅ ぇ ぉ ゃ ゅ ょ を ほ ゑ ー BS ';
            key_str += 'Tab た て ぃ す か ん な に ら せ ゛ 「 Enter ';
            key_str += '英数 ち と し は き く ま の り れ け 」 ';
            key_str += 'Shift っ さ そ ゐ こ み も 、 。 ・ ろ Shift ';
            key_str += 'Ctrl 無変換 　 変換'; //全角空白使ってます
            var keycap_kana_shift:Array = key_str.split(' ');
    
            key_str  = 'NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL ';
            key_str += 'NULL ぬ ふ あ う え お や ゆ よ わ ほ へ ー BackSpace ';
            key_str += 'Space た て い す か ん な に ら せ ゛ ゜ NULL ';
            key_str += 'NULL ち と し は き く ま の り れ け む ';
            key_str += 'NULL つ さ そ ひ こ み も ね る め ろ NULL ';
            key_str += 'NULL NULL Space NULL';
            var output_kana:Array = key_str.split(' ');

            key_str  = 'NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL ';
            key_str += 'NULL ぬ ふ ぁ ぅ ぇ ぉ ゃ ゅ ょ を ほ ゑ ー BackSpace ';
            key_str += 'Space た て ぃ す か ん な に ら せ ゛ 「 NULL ';
            key_str += 'NULL ち と し は き く ま の り れ け 」 ';
            key_str += 'NULL っ さ そ ゐ こ み も 、 。 ・ ろ NULL ';
            key_str += 'NULL NULL Space NULL';
            var output_kana_shift:Array = key_str.split(' ');

            key_str  = 'NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL ';
            key_str += 'NULL １ ２ ３ ４ ５ ６ ７ ８ ９ ０ － ＾ ￥ BackSpace ';
            key_str += 'Space ｑ ｗ ｅ ｒ ｔ ｙ ｕ ｉ ｏ ｐ ＠ ［ NULL ';
            key_str += 'NULL ａ ｓ ｄ ｆ ｇ ｈ ｊ ｋ ｌ ； ： ］ ';
            key_str += 'NULL ｚ ｘ ｃ ｖ ｂ ｎ ｍ ， ． ／ ￥ NULL ';
            key_str += 'NULL NULL Space NULL';
            var output_zenkaku:Array = key_str.split(' ');

            key_str  = 'NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL NULL ';
            key_str += 'NULL ！ ” ＃ ＄ ％ ＆ ’ （ ） を ＝ ～ ｜ BackSpace ';
            key_str += 'Space Ｑ Ｗ Ｅ Ｒ Ｔ Ｙ Ｕ Ｉ Ｏ ｐ ＠ ｛ NULL ';
            key_str += 'NULL Ａ Ｓ Ｄ Ｆ Ｇ Ｈ Ｊ Ｋ Ｌ ＋ ＊ ｝ ';
            key_str += 'NULL Ｚ Ｘ Ｃ Ｖ Ｂ Ｎ Ｍ ＜ ＞ ？ ＿ NULL ';
            key_str += 'NULL NULL Space NULL';
            var output_zenkaku_shift:Array = key_str.split(' ');
        }
    }
}