/**
 * Copyright WLAD ( http://wonderfl.net/user/WLAD )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/87HO
 */

package {
    import flash.display.Sprite;
    import flash.display.Graphics;
    import flash.geom.Point;
    
    public class FlashTest extends Sprite {
        
        
        private var a:DragablePoint;
        private var b:DragablePoint;
        
        private var points:Array = [
            new Point(0, 0.1),
            new Point(0.1, 0.5),
            new Point(0.2, 0.2),
            new Point(0.3, 1),
            new Point(0.5, 0),
            new Point(0.6, 1),
            new Point(0.7, 0.5),
            new Point(1, 0.9)
        ];
        
        
        
        
        private var g:Graphics;
        
        private var g2:Graphics;
        
        public function FlashTest() {
            // write as3 code here..
            
            graphics.beginFill(0);
            graphics.drawRect(0,0,500,500);
            graphics.endFill();
            
            var s:Sprite = new Sprite();
            addChild( s );
            g = s.graphics;
            s = new Sprite();
            addChild( s );
            g2 = s.graphics;
            
            
            a = new DragablePoint(onMove);
            addChild(a);
            
            a.x = 100;
            a.y = 200;
            
            b = new DragablePoint(onMove);
            addChild(b);
            
            b.x = 400;
            b.y = 300;
            
            onMove();
            
            addEventListener("enterFrame", update);
        }
        
        private function update(e:*=null):void
        {
            g2.clear();
            
            var gap:int = 10;
            
            // Line start value
            var ls:int = 30;
            // Line end value
            var le:int = 150;
            
            // ************************* PINK
            g2.lineStyle( 6, 0xFF00FF );
            g2.moveTo( ls, gap );
            g2.lineTo( le, gap );
            var mx:Number = mouseX < ls ? ls : ( mouseX > le ? le : mouseX );
            g2.drawCircle( mx , gap, 5 );
            g2.lineStyle( 2, 0xFF00FF, 0.4 );
            g2.moveTo( mx, 0 );
            g2.lineTo( mx, 500 );
            
            // ************************* CYAN
            g2.lineStyle( 6, 0x00FFFF );
            g2.moveTo( gap, ls );
            g2.lineTo( gap, le);
            var my:Number = mouseY < ls ? ls : ( mouseY > le ? le : mouseY );
            g2.drawCircle( gap , my, 5 );
            g2.lineStyle( 2, 0x00FFFF , 0.4 );
            g2.moveTo( 0, my );
            g2.lineTo( 500, my );
            
            var vx:Number = ( mx - ls ) / ( le-ls );
            var vy:Number = ( my - ls ) / ( le-ls ); 
            
            
            // ************************* YELLOW
            g2.lineStyle( 6, 0xFFFF00 );
            g2.drawCircle( mx, my, 5 );
            
            // ************************* ORANGE 
            
            
            
            var p:Vector2D = cubicCoord( new Vector2D(a.x, a.y),new Vector2D(b.x, b.y), vx,vy );
            
            g2.lineStyle( 6, 0xFF7D00);
            g2.drawCircle( p.x, p.y, 5 );
        }
        
        //////////////////////////////////////////////// BEGIN ALGORITHM
        
        private function cubicCoord( start:Vector2D, end:Vector2D, x:Number, y:Number ):Vector2D
        {
            var lx:Vector2D = new Vector2D( end.x - start.x, end.y - start.y );
            
            var ly:Vector2D = lx.clone();
            ly.angle += 90;
           
            lx.force *= x;
            ly.force *= (y-0.5);
           
            var v:Vector2D = start.clone();
            v.plus( lx );
            v.plus( ly );
            
            
            return v;    
        }
        
        //////////////////////////////////////////////// END
        
        
        private function onMove():void
        {
            
            var va:Vector2D = new Vector2D( a.x, a.y);
            var vb:Vector2D = new Vector2D( b.x, b.y);
            
            // ************************* GREEN 
            
            g.clear();
            g.lineStyle( 3, 0x00FF00 );
            g.moveTo( a.x, a.y );
            
            var line:Vector2D = new Vector2D( b.x - a.x, b.y - a.y );
            var hLine:Vector2D = line.clone();
            hLine.force = hLine.force/2;
            var pp:Vector2D;
            
            
            hLine.degrees -= 90;
            
            pp = new Vector2D( a.x + hLine.x, a.y + hLine.y );
            
            g.lineTo( pp.x, pp.y );
            pp.plus( line );
            g.lineTo( pp.x, pp.y );
            line.degrees += 90;
            pp.plus(line);
            g.lineTo( pp.x, pp.y );
            line.degrees += 90;
            pp.plus(line);
            g.lineTo( pp.x, pp.y );
            g.lineTo( a.x, a.y );
            
            
            
            
            // ************************* WHITE
            
            g.lineStyle( 3, 0xFFFFFF );
            
            for( var i:int = 0; i < points.length; i++ )
            {
                var p:Vector2D = cubicCoord( va, vb, points[i].x, points[i].y );
                
                if( i == 0 ) g.moveTo( p.x, p.y );
                
                else g.lineTo( p.x, p.y );
                
            }
            
        }
    }
}

// HELPER CALSSES

/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////








	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Rectangle;
	
	/**
	 * ...
	 * @author vladik.voina@gmail.com
	 */
	class DragablePoint extends Sprite 
	{
		private var isStatic:Boolean;
		private var onMove:Function;
		


                static public const DP_Normal:Object = 
		{ 
			
			border: 0x00FF00, 
			bg: 0x00FF00, 
			bs: 12, 
			radius: 9, 
			lineAlpha: 0.2
		};
		static public const DP_Static:Object = 
		{ 
			border: 0xFF0000, 
			bg: 0x00FFFF, 
			bs: 0, 
			radius: 6, 
			alpha: 0.5
		};
		static public const DP_Down:Object = 
		{ 
			border: 0xFF0000, 
			bg: 0xFF0000, 
			bs: 12, 
			radius: 9, 
			lineAlpha: 0.2
		};
		

		public function DragablePoint( onMove:Function = null , isStatic:Boolean = false ) 
		{
			this.onMove = onMove;
			this.isStatic = isStatic;
			useHandCursor = buttonMode = true;
			addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			
			draw( isStatic ? DP_Static : DP_Normal );
			addEventListener(MouseEvent.MOUSE_DOWN, onMD);
		}
		
		private function onMD(e:MouseEvent):void 
		{
			draw( DP_Down );
			
			stage.addEventListener(MouseEvent.MOUSE_UP, onMU);
			stage.addEventListener(MouseEvent.MOUSE_MOVE, update);
		}
		
		public var dragBounds:Rectangle = null;
		
		private function update(e:MouseEvent):void 
		{
			if( !isStatic ) this.x = parent.mouseX;
			this.y = parent.mouseY;
			
			if ( dragBounds )
			{
				if ( !isStatic) 
				{
					if ( this.x - radius < dragBounds.x )
						this.x = dragBounds.x + radius;
					if ( this.x + radius > dragBounds.right )
						this.x = dragBounds.right - radius;				
				}
				
				if ( this.y - radius < dragBounds.y )
					this.y = dragBounds.y + radius;
				
				if ( this.y + radius > dragBounds.bottom )
					this.y = dragBounds.bottom - radius;
			}
			
			if ( onMove != null ) 
			{
				if ( onMove.length == 1 ) onMove( e );
				else onMove();
			}
		}
		
		private function onMU(e:MouseEvent):void 
		{
			stage.removeEventListener(MouseEvent.MOUSE_UP, onMU);
			stage.removeEventListener(MouseEvent.MOUSE_MOVE, update);
			
			draw( isStatic ? DP_Static : DP_Normal );
		}
		
		private var radius:Number = 0;
		
		public function draw( style:Object ):void
		{
			var lineAlpha:Number  = style.hasOwnProperty("lineAlpha") ? style.lineAlpha : 1;
			
			graphics.clear();
			graphics.lineStyle( style.bs, style.border, lineAlpha );
			graphics.beginFill( style.bg );
			graphics.drawCircle( 0, 0, style.radius );
			graphics.endFill();
			
			if ( style.hasOwnProperty("alpha") ) alpha = style.alpha;
			else alpha = 1;
			
			radius = style.radius + style.bs / 2;
		}
	}





class Vector2D
{
    
                public static function rotate(vec:Vector2D, around:Vector2D, angle:Number):Vector2D
		{
			var v:Vector2D = vec.vecMinus(around);
			
			v.radians += angle;
			v.plus(around);
			
			return v;
		}
    
    
                public var x:Number, y:Number;
		public function Vector2D(x:Number = 0,y:Number = 0) 
		{
			this.x = x;
			this.y = y;
		}
		public function get force():Number
		{
			return Math.sqrt(x * x + y * y);
		}
		public function set force(value:Number):void 
		{
			if (force == 0) scale(0);
			else scale(value / force);
		}
		public function set degrees(value:Number):void 
		{
			radians = value * Math.PI / 180;
		}
		public function get degrees():Number
		{
			return radians * 180 / Math.PI;
		}

                public function set angle(value:Number):void 
    		{
			degrees = value;
		}
		public function get angle():Number
		{
			return degrees;
		}

		public function set radians(value:Number):void 
		{
			var f:Number = force;
			x = Math.cos(value) * f;
			y =  Math.sin(value) * f;
		}
		public function get radians():Number 
		{
			return Math.atan2(y, x);
		}

		public function scale(n:Number):void
		{
			x *= n;
			y *= n;
		}
                public function plus(vec:Vector2D):void 
		{
			x += vec.x;
			y += vec.y;
		}

		public function vecMinus(vec:Vector2D):Vector2D
		{
			return new Vector2D(x - vec.x, y - vec.y);
		}

public function clone():Vector2D
{
    return new Vector2D( x, y );
    }
}