/**
 * Copyright narutohyper ( http://wonderfl.net/user/narutohyper )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/87BS
 */

package
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Point;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.text.TextFieldAutoSize
    /**
     * ...
     * @author narutohyper
     */
    [SWF(width = 465, height = 465, frameRate = 60,backgroundColor=0x000000)]
    public class Main extends Sprite
    {
        
        private var _buttons:Vector.<switchButton> = new Vector.<switchButton>();
        private var _actionVector:Vector.<switchButton>
        private var _counter:uint=0
        private var _all:Boolean=false
        public var _label:TextField=new TextField()
        private var _sound:mySound
        private var _voiceCounter:uint=0


        public function Main():void {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void
        {
            this.graphics.beginFill(0x000000);
            this.graphics.drawRect(0,0,465,465);
            removeEventListener(Event.ADDED_TO_STAGE, init);
            _sound=new mySound()
            
            for (var i:int = 0; i < 25; i++) {
                var bt:switchButton = _buttons[i] = new switchButton(i,_sound);
                bt.x = i % 5 * 90 + 52;
                bt.y = 300;
                bt.z = 250 - Math.floor(i / 5) * 65;
                bt.addEventListener(switchButton.DOWN, onClick);
                addChild(bt);
            }
            
            this.transform.perspectiveProjection.projectionCenter = new Point(stage.stageWidth / 2, stage.stageHeight / 2 - 300);

            _counter = 1;
            _buttons[12].up();
            _actionVector = _buttons.slice();
            
        }
        

        
        
        private function onClick(e:Event):void {
            _counter--

            var i:int=0
            for (i = 0; i < _actionVector.length; i++ ) {
                if (_actionVector[i]==e.target) {
                    _actionVector.splice(i, 1);
                    break;
                }
            }
            
            if (_actionVector.length == 0) {
                if (!_all) {
                    _counter = 25;
                    _actionVector = _buttons.slice()
                    for (i = 0; i < _counter; i++) {
                        _actionVector[i].up()
                    }
                    _all = true;
                } else {
                    _voiceCounter=(_voiceCounter+1)%6
                    _sound.changeVoice(_voiceCounter)
                    _counter=1
                    _buttons[12].up();
                    _actionVector = _buttons.slice()
                    _all = false;
                }
            } else {
                if (_counter == 0) {

                    var tempVector:Vector.<switchButton>=_actionVector.slice()
                    var next:uint
                    var max:uint = (tempVector.length > 5)?5:tempVector.length;
                    _counter = Math.floor(Math.random() * max) + 1
                    //次の候補
                    
                    for (i = 0; i < _counter; i++) {
                        next = Math.floor(Math.random() * (tempVector.length))
                        tempVector[next].up()
                        tempVector.splice(next, 1);
                        if (tempVector.length==0) {
                            break;
                        }
                    }

                }
            }
        }
        
    }
    
}



import flash.display.DisplayObject;
import flash.events.EventDispatcher;
import org.si.sion.*;
import org.si.sion.events.*;
import org.si.sion.effector.*;
import org.si.sion.utils.SiONPresetVoice;

class mySound extends EventDispatcher {
    
    
    public var driver:SiONDriver = new SiONDriver();
    public var presetVoice:SiONPresetVoice = new SiONPresetVoice();
    public var drumLoop:SiONData;
    public var lpf:SiCtrlFilterLowPass = new SiCtrlFilterLowPass();


    private var _notes:Vector.<int> = new Vector.<int>(5);
    private var _length:Vector.<int> = new Vector.<int>(5);
    private var _voices:Vector.<SiONVoice> = new Vector.<SiONVoice>(5);
    private var _voiceNo:uint=0
    public function mySound() {

        
        //木琴
        //_notes = Vector.<int>([ 60, 62, 64, 65, 67, 69, 71]);
        _length[0] = 4
        _voices[0] = presetVoice["valsound.bell5"]
        
        //chime
        //_notes = Vector.<int>([ 60, 62, 64, 65, 67, 69, 71]);
        _length[1] = 4
        _voices[1] = presetVoice["valsound.bell2"]
        
        //ギター
        //_notes = Vector.<int>([ 48, 50, 52, 53, 55, 57, 59]);
        _length[2] = 8;
        _voices[2] = presetVoice["valsound.guitar2"]

        //ピアノ
        //_notes = Vector.<int>([ 60, 62, 64, 65, 67, 69, 71]);
        _length[3] = 8;
        _voices[3] = presetVoice["valsound.piano1"]
        
        //リード
        //_notes = Vector.<int>([ 72, 74, 76, 77, 79, 81, 83]);
        _length[4] = 2;
        _voices[4] = presetVoice["valsound.lead3"]

        //_notes = Vector.<int>([ 48, 50, 52, 53, 55, 57, 59]);
        _length[5] = 4;
        _voices[5] = presetVoice["valsound.brass5"]



        _notes = Vector.<int>([36, 38, 40, 41, 43, 45, 47 , 48, 50, 52, 53, 55, 57, 59, 60, 62, 64, 65, 67, 69, 71, 72, 74, 76, 77, 79, 81, 83,  84, 86, 88, 89, 91, 93, 95,97]);
        
        //_notes = Vector.<int>([72, 74, 76, 77, 79])
        //_notes = Vector.<int>([  0,  2,  4,  5,  7,  9, 11]);
        //_notes = Vector.<int>([ 12, 14, 16, 17, 19, 21, 23]);
        //_notes = Vector.<int>([ 24, 26, 28, 29, 31, 33, 35]);
        //_notes = Vector.<int>([ 36, 38, 40, 41, 43, 45, 47]);
        //_notes = Vector.<int>([ 48, 50, 52, 53, 55, 57, 59]);
        //_notes = Vector.<int>([ 60, 62, 64, 65, 67, 69, 71]);
        //_notes = Vector.<int>([ 72, 74, 76, 77, 79, 81, 83]);
        //_notes = Vector.<int>([ 84, 86, 88, 89, 91, 93, 95]);
        //_notes = Vector.<int>([ 96, 98,100,101,103,105,107]);
        //_notes = Vector.<int>([108,110,112,113,115,117,119]);
        //_notes = Vector.<int>([120,122,124,125,127]);
        
        //_length = Vector.<int>([8,8,8,8,8])
        //_voices[0]=_sound.presetVoice["valsound.bell3"]
        //_voices[1]=_sound.presetVoice["valsound.bell3"]
        //_voices[2]=_sound.presetVoice["valsound.bell3"]
        //_voices[3]=_sound.presetVoice["valsound.bell3"]
        //_voices[4]=_sound.presetVoice["valsound.bell3"]




        var mml:String = "t132;"
        mml += "%6@0 o2 l16 $[v16crv8crr8crr8crr8rc];"
        mml += "%6@1 o2 l16 $[v16r4dr8rr4 d r8r];"
        mml += "%6@2 o2 l16 $[v8 r4b-r8rrb-r8b-r8b-];"
        mml += "%6@3 o2 l16 $[v8 f+rf+rrf+rf+r8f+rr8f+r];"
        mml += "%6@4 o4 l16 $[v12 cc8cr8o3g+8&g+8g+rrg+g+ro4e-e-8e-r8o3b-8&b-8b-rr8b-r];"
            
        drumLoop = driver.compile(mml);
        
        var percusVoices:Array = presetVoice["valsound.percus"];
        drumLoop.setVoice(0, percusVoices[0]);    // bass drum
        drumLoop.setVoice(0, percusVoices[0]);    // bass drum
        drumLoop.setVoice(1, percusVoices[27]); // snare drum
        drumLoop.setVoice(2, percusVoices[16]); // close hihat
        drumLoop.setVoice(3, percusVoices[21]); // open hihat
        var baseVoices:Array = presetVoice["valsound.bass"];
        drumLoop.setVoice(4, baseVoices[2]); // open hihat

        driver.addEventListener(SiONTrackEvent.BEAT, onBeat);
        
        driver.play(drumLoop, false);
        
    }


    public function noteOn(id:uint):void {
        //_sound.driver.noteOn(65,_sound.presetVoice["valsound.piano11"],4)
        driver.noteOn(_notes[id], _voices[_voiceNo], _length[_voiceNo],0)
    }

    public function changeVoice(no:uint):void {
        _voiceNo = no
        trace(String(_voiceNo))
    }

    private function onBeat(e:SiONTrackEvent) : void
    {
            //controlPad.beat(32);
        dispatchEvent(e)
    }
    
    
}



import flash.display.Shape;
import flash.display.Sprite;
import flash.display.GradientType
import flash.events.MouseEvent;
import flash.events.Event;
import flash.geom.Matrix
import flash.geom.ColorTransform;

import flash.filters.BitmapFilter;
import flash.filters.BitmapFilterQuality;
import flash.filters.GlowFilter;
import flash.filters.BlurFilter;

import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.core.easing.IEasing;
import org.libspark.betweenas3.tweens.ITween;
import org.libspark.betweenas3.easing.*;
import org.libspark.betweenas3.events.TweenEvent;
import org.libspark.betweenas3.tweens.ITweenGroup;

import frocessing.color.ColorHSV;

class switchButton extends Sprite {
    public static const DOWN:String = 'down'
    private var _size:Number = 60
    private var _hall:Sprite = new Sprite();
    private var _bt:Sprite = new Sprite();
    private var _cylinder:Shape = new Shape();
    private var _msk:Shape = new Shape();
    private var _cap:Sprite = new Sprite()
    private var _top:Shape = new Shape();
    private var _light:Shape = new Shape();
    private var _id:uint = 0
    private var _ct:ColorTransform = new ColorTransform()
    private var _tg:ITweenGroup
    private var _sound:mySound;
    private var _glowSize:Number=1

    
    public function switchButton(id:uint,sound:mySound) {
        _id = id;
        _sound=sound
        
        makeShape(_cylinder)
        makeShape(_msk)

        _hall.graphics.beginFill(0x000000);
        _hall.graphics.drawEllipse(0, 0, _size, 30);
        _hall.graphics.endFill()

        _top.graphics.beginFill(0xFFFFFF);
        _top.graphics.drawEllipse(0, 0, _size, 30);
        _top.graphics.endFill()
        
        _light.graphics.beginFill(0xFFFFFF,0.8);
        _light.graphics.drawEllipse(0,-1, _size, 30);
        _light.graphics.endFill()

        var filter:BitmapFilter = getBlurFilter(5);
        var myFilters:Array = [filter];
        _light.filters = myFilters;
        
        
        //addChild(hall);
        addChild(_bt);
        addChild(_msk);
        _hall.scaleX=_hall.scaleY=1.4
        _hall.x = -_hall.width/2
        _hall.y = 57
        _cylinder.mask = _msk
        _bt.addChild(_cylinder);
        _msk.x = -_size / 2
        _bt.addChild(_cap);
        _cap.addChild(_top);
        _cap.addChild(_light);
        _bt.x=-_size/2
        _bt.y = 60
        _cap.alpha = 0
        //bt.cacheAsBitmap = true;

        visible = false;
        
        var hsv:ColorHSV = new ColorHSV();
        hsv.h = Math.floor(360 * _id / 25);
        hsv.s = 1
        hsv.v = 1
        _ct.color = hsv.toRGB().value;
        _top.transform.colorTransform = _ct;


        _sound.addEventListener(SiONTrackEvent.BEAT,onBeat)
        this.addEventListener(Event.ENTER_FRAME,onEnter)
    }

    
    public function onBeat(e:SiONTrackEvent):void {
        _glowSize = 1;
    }
    
    
    public function onEnter(e:Event):void {
        if (visible) {
            _glowSize *= 0.9;
            var filter:BitmapFilter = getGlowFilter(_glowSize);
            var myFilters:Array = [filter];
            _top.filters = myFilters;
        }
    }
    
    
    public function get id():uint { return _id; }
    
    public function set id(value:uint):void
    {
        _id = value;
    }
    
    
    
    public function reset():void {
        if (_tg) {
            _tg.stop();
        }
        
        _bt.buttonMode = false;
        _bt.removeEventListener(MouseEvent.MOUSE_DOWN, onClick)

        var _t:Array
        _t=[]
        _t[0] = BetweenAS3.tween(_bt, { y: 60 }, null, 0.3, Circ.easeOut)
        _t[1] = BetweenAS3.tween(_cylinder, { alpha: 0}, null, 0.01, Circ.easeOut)
        _t[2] = BetweenAS3.tween(_cap, { alpha: 0}, null, 0.5, Circ.easeOut)
        _tg = BetweenAS3.serialTweens(_t)
        _tg.addEventListener(TweenEvent.COMPLETE, onComplete);
        _tg.play();
        
        function onComplete(e:TweenEvent):void {
            _tg.removeEventListener(TweenEvent.COMPLETE, onComplete);
            visible = false;
            dispatchEvent(new Event(DOWN))
        }

    }
    
    public function up():void {
        visible = true;
        //_bt.y=60
        //_top.alpha = 0.5;
        //cylinder.alpha = 0;
        if (_tg) {
            _tg.stop();
        } else {
            _cap.alpha = 0
            _cylinder.alpha=0
        }
        
        
        var _t:Array
        _t=[]
        _t[0] = BetweenAS3.tween(_cap, { alpha: 1 }, null, 0.5, Circ.easeOut)
        _t[1] = BetweenAS3.tween(_cylinder, { alpha: 1 }, null, 0.01, Circ.easeOut)
        _t[2] = BetweenAS3.tween(_bt, { y: 30 }, null, 0.3, Circ.easeOut)
        _tg = BetweenAS3.serialTweens(_t)
        _tg.addEventListener(TweenEvent.COMPLETE, onComplete);
        _tg.play();
        
        function onComplete(e:TweenEvent):void {
            _tg.removeEventListener(TweenEvent.COMPLETE, onComplete);
            _bt.buttonMode = true;
            _bt.addEventListener(MouseEvent.MOUSE_DOWN, onClick)
        }
    }
    
    private function onClick(e:MouseEvent):void {
        _sound.noteOn(id)
        reset();

    }
    
    
    private function makeShape(bt:Shape):void {
        var fillType:String = GradientType.LINEAR;
        var colors:Array = [0xCCCCCC,0xFFFFFF, 0x666666, 0x999999];
        var alphas:Array = [1, 1, 1, 1];
        var ratios:Array = [0x00,0x22, 0xAA,0xFF];
        var matr:Matrix = new Matrix();
        

        matr.createGradientBox(_size, _size, 0, 0, 0);
        bt.graphics.beginGradientFill(fillType, colors, alphas, ratios, matr);
        bt.graphics.drawRect(0, 15, _size, _size);
        bt.graphics.endFill()
        bt.graphics.beginGradientFill(fillType, colors, alphas, ratios, matr);
        bt.graphics.drawEllipse(0, _size, _size, 30);
        bt.graphics.endFill()
        bt.graphics.beginGradientFill(fillType, colors, alphas, ratios, matr);
        bt.graphics.drawEllipse(0, 0, _size, 30);
        bt.graphics.endFill()
    }
    

    private function getGlowFilter(no:Number=1):BitmapFilter {
            var color:Number = 0x33CCFF;
            var alpha:Number = 0.8;
            var blurX:Number = 35*no;
            var blurY:Number = 25*no;
            var strength:Number = 2;
            var inner:Boolean = false;
            var knockout:Boolean = false;
            var quality:Number = BitmapFilterQuality.HIGH;

            return new GlowFilter(color,alpha,
                                                        blurX,blurY,
                                                        strength,quality,
                                                        inner,knockout);
    }
    
    private function getBlurFilter(no:Number=1):BitmapFilter {
            var blurX:Number = 3.5*no;
            var blurY:Number = 2.5*no;
            var quality:Number = BitmapFilterQuality.HIGH;

            
            return new BlurFilter(blurX,blurY,quality);
    }

    
}
