/**
 * Copyright umi_kappa ( http://wonderfl.net/user/umi_kappa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/86SS
 */

// forked from actionscriptbible's Chapter 38 Example 2
/*ちと使ってみたくなったんで、読み解く！
 * 
 * このぐにゃぐにゃ具合をコントロールできたらいいなー
 * 
 * pbjファイルを読み込んでいるから細かい編集には手が出せないやー
 * PixelBenderToolkitも勉強してみなきゃ。
 * */

package {
  import flash.display.*;
  import flash.events.*;
  import flash.filters.*;
  import flash.geom.*;
  import flash.media.*;
  import flash.net.*;
  import flash.utils.*;
  
  public class Main extends Sprite {
    protected var holder:Sprite;
    protected var video:Video;
    protected var testPattern:Loader;
    protected var noise:BitmapData;
    
    protected var shader:Shader;
    protected var shaderFilter:ShaderFilter;
    
    protected var smoothRandomNoise:BitmapData;
    protected var pointers:Vector.<Point>;
    protected var rands:Vector.<Number>;
    
    public function Main() {
		//LOWの方がリアルかも
      stage.quality = StageQuality.LOW;
	  
      holder = new Sprite();
      noise = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0);
	  
	  //WEBカメラの映像をGET
      var camera:Camera = Camera.getCamera();
	  //カメラの映像をvideoに設定
      video = new Video(stage.stageWidth/2, stage.stageHeight/2);
      video.scaleX = video.scaleY = 2;
	  
	  //根本的なwebカメラのサイズを設定する
      camera.setMode(stage.stageWidth/2, stage.stageWidth/2, stage.frameRate, false);
      /*Videoクラスは，単にcamera.setMode()で設定したサイズに対して縮小・拡大してサイズを調整するだけなので，
	   * webカメラのサイズがVideoクラスで設定したサイズより小さければ，
	   * どんなに高解像度のwebカメラを使っても画質が低く表示されてしまいます． だそうです（笑）*/
	  video.attachCamera(camera);
	  
	  //夜中のテレビみたいな画像を配置
      testPattern = new Loader();
      testPattern.blendMode = BlendMode.ADD;
      testPattern.alpha = 0;
      holder.addChild(video);
      holder.addChild(testPattern);
      addChild(holder);
      
      smoothRandomNoise = new BitmapData(300, 10, false, 0);
      smoothRandomNoise.perlinNoise(Math.random()*100, Math.random()*100, 4,30 * int(1000*Math.random()), true, true, 7);
      /*こいつがキモみたい。 perlinNoise
	   * 1 ぐにゃぐにゃになるスピード？？　X
	   * 2 ぐにゃぐにゃになるスピード？？　Y
	   * 3 これを増やすとさらにぐじゃぐじゃになる.
	   * 4 乱数を生成するための元となる数値を指定する ノイズの幅？？　ここがコントロールと関係ありそう
	   * 5　つなぎめが綺麗に見えるかどうか
	   * */
	  
	  pointers = new Vector.<Point>(12);
      rands = new Vector.<Number>(12);
      for (var i:int = 0; i < 12; i++)
        pointers[i] = (new Point(
          Math.random()*smoothRandomNoise.width,
          Math.random()*smoothRandomNoise.height));
      
		  //pixecbender系??
      var PBJURL:String = "http://actionscriptbible.com/files/badreception.pbj";
      var loader:URLLoader = new URLLoader(new URLRequest(PBJURL));
      loader.dataFormat = URLLoaderDataFormat.BINARY;
      loader.addEventListener(Event.COMPLETE, onBytecodeLoaded);
      
	  //放送テストみたいな画像
      var IMGURL:String = "http://actionscriptbible.com/files/testpattern.jpg";
      testPattern.load(new URLRequest(IMGURL));
      testPattern.contentLoaderInfo.addEventListener(Event.COMPLETE, onImageLoaded);
    }
	
	
    protected function onBytecodeLoaded(event:Event):void {
      shader = new Shader(URLLoader(event.target).data);
      shaderFilter = new ShaderFilter(shader);
      shader.data.noiseImage.input = noise;
      shader.data.srcImage.input = noise; 
      shader.data.dimensions.value = [noise.width, noise.height];

      stage.fullScreenSourceRect = noise.rect;
      stage.addEventListener(MouseEvent.CLICK, onFullScreen);
      stage.addEventListener(Event.ENTER_FRAME, go);
    }
	
    protected function go(event:Event):void {
      noise.noise(getTimer(), 0, 255, 7, true);
	  
      for (var i:int = 0; i < pointers.length; i++) {
        var p:Point = pointers[i];
        p.x = (int(p.x) + 2*(1+i)) % smoothRandomNoise.width;
        rands[i] = smoothRandomNoise.getPixel(p.x, p.y) / 0x00ffffff;
      }
      
      testPattern.alpha = Math.max(0, rands[6] * 3 - 2);
	  
      var sd:ShaderData = shader.data;
	  /*
	   * ここの数値をどうにかしたらコントロールできそう。
	   * */
	  //横にピピっとでるノイズ
      sd.noisyHDisplace.value = [Math.pow(rands[2],4)*40];
      //上下の移動
	  sd.vRoll.value = [rands[0] * 80 - 20];
      //色
	  sd.channelSplit.value = [rands[3] * 40 - 10];
	  //なみ？
      sd.sinHDisplaceAmplitudes.value = [20.0, 2.0, 1.0];
	  //なみ？　ガタガタをなめらかに
      sd.sinHDisplaceFrequencies.value = [rands[2]*2+0.4, rands[10]*4+4, rands[11]*8+8];
      //なみ？
	  sd.sinHDisplace.value = [Math.pow(rands[2], 8) * 100];
	  //粒子状のノイズ
      sd.noiseLayer.value = [Math.pow(rands[10], 4) * 0.8];
	  //くろい横棒
      sd.blackoutThresh.value = [rands[2] * 0.3];
	  
      holder.filters = [shaderFilter];
    }
	
	//画像を読み終わったら
    protected function onImageLoaded(event:Event):void {
      testPattern.width = noise.width;
      testPattern.height = noise.height;
    }
	
	//画面をクリックするとフルスクリーンに
    protected function onFullScreen(event:MouseEvent):void {
      if (stage.displayState == StageDisplayState.FULL_SCREEN) {
        stage.displayState = StageDisplayState.NORMAL;
      } else {
        stage.displayState = StageDisplayState.FULL_SCREEN;
      }
    }
  }
}