/**
 * Copyright Jacky.Riawan ( http://wonderfl.net/user/Jacky.Riawan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/85wp
 */

package  
{
    import flash.text.TextField;
    import Box2D.Collision.b2AABB;
    import Box2D.Collision.Shapes.b2CircleDef;
    import Box2D.Collision.Shapes.b2PolygonDef;
    import Box2D.Common.Math.b2Vec2;
    import Box2D.Dynamics.b2Body;
    import Box2D.Dynamics.b2BodyDef;
    import Box2D.Dynamics.b2DebugDraw;
    import Box2D.Dynamics.b2World;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    /**
     * ...
     * @author Jacky Riawan
     */
    public class domino extends Sprite
    {
        private var world:b2World;
        private const ratio:uint=30
        private var screen:Sprite;
        public function domino() 
        {
            var textF:TextField=new TextField()
            textF.x=100
            textF.y=100
            textF.autoSize="left"
            textF.text="move mouse left/right side of the screen to scroll"
            addChild(textF)
            setupWorld()
            createGround()        
            putStuffs()
            setupDebugDraw()

            addEventListener(Event.ENTER_FRAME, render)
            
        }
        

        private function putStuffs():void
        {
             putBall(10, 10)
            for (var i:uint = 0; i < 11; i++) {
                putDomino(100+i*50,360)
            }
            putBall(640, 340)
            putLongDomino(720, 320)
            putStaticBox(920, 280)
            for (i = 0; i < 6; i++) {
                putDomino(847+i*30,240)
            }
            
            for (i = 0; i < 11; i++) {
                putDomino(1080+i*50,360)
            }
            putBall(1660, 340)
        }
        
        private function putBall(posx:int,posy:int):void
        {
            var ballShape:b2CircleDef = new b2CircleDef()//new b2CircleShape(30 / ratio)
            ballShape.radius=(30 / ratio)
            ballShape.density=3
            var ballBodyDef:b2BodyDef = new b2BodyDef()
            ballBodyDef.position.Set(posx / ratio, posy / ratio)
            var ball:b2Body = world.CreateBody(ballBodyDef)
            ball.CreateShape(ballShape)
            ball.SetMassFromShapes()
        }
        private function putStaticBox(posx:int, posy:int):void {
            var dominoShapeDef:b2PolygonDef = new b2PolygonDef()
            dominoShapeDef.SetAsBox(80 / ratio, 10 / ratio)
            var dominoBodyDef:b2BodyDef = new b2BodyDef()
            dominoBodyDef.position.Set(posx / ratio, posy / ratio)
            var _domino:b2Body = world.CreateBody(dominoBodyDef)
            _domino.CreateShape(dominoShapeDef)
            _domino.SetMassFromShapes()
        }
        private function putDomino(posx:int,posy:int):void
        {
            var dominoShapeDef:b2PolygonDef = new b2PolygonDef()
            dominoShapeDef.SetAsBox(4 / ratio, 30 / ratio)
            dominoShapeDef.density=10
            var dominoBodyDef:b2BodyDef = new b2BodyDef()
            dominoBodyDef.position.Set(posx / ratio, posy / ratio)
            var _domino:b2Body = world.CreateBody(dominoBodyDef)
            _domino.CreateShape(dominoShapeDef)
            _domino.SetMassFromShapes()
            
        }
        private function putLongDomino(posx:int,posy:int):void
        {
            var dominoShapeDef:b2PolygonDef = new b2PolygonDef()
            dominoShapeDef.SetAsBox(20 / ratio, 100 / ratio)
            dominoShapeDef.density=.2
            var dominoBodyDef:b2BodyDef = new b2BodyDef()
            dominoBodyDef.position.Set(posx / ratio, posy / ratio)
            var _domino:b2Body = world.CreateBody(dominoBodyDef)
            _domino.CreateShape(dominoShapeDef)
            _domino.SetMassFromShapes()
            
        }
        private function createGround():void
        {
            var triangleShape:b2PolygonDef = new b2PolygonDef()
            triangleShape.vertexCount = 3
            triangleShape.vertices[0].Set(0, 0)
            triangleShape.vertices[1].Set(0, -50/ratio)
            triangleShape.vertices[2].Set(100 / ratio, 0)
            var triangleBodyDef:b2BodyDef = new b2BodyDef()
            triangleBodyDef.position.Set(0/ratio,400/ratio)
            var triangle:b2Body = world.CreateBody(triangleBodyDef)
            triangle.CreateShape(triangleShape)
            triangle.SetMassFromShapes()
            
            
            var groundShapeDef:b2PolygonDef = new b2PolygonDef()
            groundShapeDef.SetAsBox(1000/ratio,5/ratio)
            var groundBodyDef:b2BodyDef = new b2BodyDef()
            groundBodyDef.position.Set(775/ ratio, 400 / ratio)
            var groundBody:b2Body = world.CreateBody(groundBodyDef)
            groundBody.CreateShape(groundShapeDef)
            groundBody.SetMassFromShapes()
        }
        
        private function render(e:Event):void 
        {
            if (mouseX > 550 * .8) {
                screen.x-=10
            }else if (mouseX < 550 * .2) {
                screen.x+=10
            }
            world.Step(1/24,10)
            //world.ClearForces()
        }
        
        private function setupDebugDraw():void
        {
            screen = new Sprite()
            var debug:b2DebugDraw = new b2DebugDraw()
            debug.m_sprite=screen
            debug.SetFlags(b2DebugDraw.e_shapeBit)
            debug.m_drawScale=ratio
            addChild(screen)
            world.SetDebugDraw(debug)
        }
        private function setupWorld():void
        {
            var myBB:b2AABB = new b2AABB()
            myBB.lowerBound.Set( -1000 / ratio, -1000 / ratio)
            myBB.upperBound.Set(2000/ratio,1000/ratio)
            world=new b2World(myBB,new b2Vec2(0,9.8),true)
        }
        
    }

}