/**
 * Copyright wh0 ( http://wonderfl.net/user/wh0 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/85Uk
 */

// I'm going to try to make something like brick wave.
// from scratch.
package {
	import net.hires.debug.Stats;
	
	import flash.display.Sprite;
	import flash.display.Shape;
	import flash.display.Graphics;
	import flash.display.BitmapData;
	import flash.display.Bitmap;
	import flash.geom.ColorTransform;
	import flash.geom.Matrix;
	import flash.display.StageQuality;
	import flash.media.Video;
	import flash.media.Camera;
	import flash.events.Event;
	[SWF(frameRate=8)]
	public class FlashTest extends Sprite {
		
		private static const EDGE:int = 10;
		private static const DEPTH:int = 64;
		
		private const ROWS:int = Math.ceil(stage.stageHeight / EDGE);
		private const COLS:int = Math.ceil(stage.stageWidth / EDGE);
		private const brick:BitmapData = prepare_brick();
		private const grid:BitmapData = new BitmapData(EDGE * COLS, EDGE * ROWS, false);
		private const ref:BitmapData = new BitmapData(COLS, ROWS, false);
		private const vid:Video = new Video(COLS, ROWS);
		private const mat:Matrix = new Matrix();
		private const ctf:ColorTransform = new ColorTransform();
		
		private function prepare_brick():BitmapData {
			stage.quality = StageQuality.LOW;
			var s:Shape = new Shape;
			var g:Graphics = s.graphics;
			g.beginFill(0xffffff);
			g.moveTo(0, 0);
			g.lineTo(EDGE, 0);
			g.lineTo(EDGE, EDGE);
			g.lineTo(0, EDGE);
			g.endFill();
			g.beginFill(0xe0e0e0);
			g.moveTo(EDGE, EDGE);
			g.lineTo(DEPTH + EDGE, DEPTH + EDGE);
			g.lineTo(DEPTH + EDGE, DEPTH);
			g.lineTo(EDGE, 0);
			g.endFill();
			g.beginFill(0xc0c0c0);
			g.moveTo(EDGE, EDGE);
			g.lineTo(DEPTH + EDGE, DEPTH + EDGE);
			g.lineTo(DEPTH, DEPTH + EDGE);
			g.lineTo(0, EDGE);
			g.endFill();
			var d:BitmapData = new BitmapData(DEPTH + EDGE, DEPTH + EDGE, true, 0);
			d.draw(s);
			return d;
		}
		
		public function FlashTest() {
			Wonderfl.disable_capture();
			var cam:Camera = Camera.getCamera();
			if (cam == null)
				return;
			cam.setMode(240, 240, 8);
			vid.attachCamera(cam);
			addChild(new Bitmap(grid));
			addChild(new Stats());
			addEventListener(Event.ENTER_FRAME, frame);
		}
		
		private function frame(e:Event):void {
			ref.draw(vid);
			for (var y:int = 0; y < ROWS; y++) {
				for (var x:int = 0; x < COLS; x++) {
					var c:int = ref.getPixel(x, y);
					var r:int = c >> 16;
					var g:int = c >> 8 & 0xff;
					var b:int = c & 0xff;
					var v:int = (r + g + b) / 3;
					mat.tx = x * EDGE - (v >> 2);
					mat.ty = y * EDGE - (v >> 2);
					ctf.redMultiplier = r / 256.;
					ctf.greenMultiplier = g / 256.;
					ctf.blueMultiplier = b / 256.;
					grid.draw(brick, mat, ctf);
				}
			}
		}
		
	}
}