/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/85K5
 */

package {
    import flash.geom.Rectangle;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
        
          myObj = new xObj();
          var a:xPart;
          a = new xPart();       a.cx = 200; a.cy = 100;
          myObj.vecPart.push(a);
          a = new xPart();       a.cx = 220; a.cy = 100;
          myObj.vecPart.push(a);
          a = new xPart();       a.cx = 250; a.cy = 150;
          myObj.vecPart.push(a);

          a = new xPart();       a.cx = 250; a.cy = 150;
          myObj.vecPart.push(a);
          
          connPart(myObj, 0, 1, 30);          connPart(myObj, 1, 2, 30);
          connPart(myObj, 2, 0, 40);          connPart(myObj, 1, 3, 40);
          connPart(myObj, 2, 3, 30);          connPart(myObj, 0, 3, 30);
          
          pic = new BitmapData(465, 465, false, 0xFFffFF);
          //pic.fillRect(new Rectangle(0,200, 465, 64), 0x808080);
          //pic.noise(2);
         
          drawRect(pic, 0,0, 32, 465, 0x808080);
          drawRect(pic, 465-32,0, 32, 465, 0x808080);
          drawRect(pic, 0,0, 465, 32, 0x808080);
          drawRect(pic, 0,465-32, 465, 32, 0x808080);
        
          var i:int;
          for (i =0; i < 64; i++)
          {
            drawRect(pic,i*16, 365+Math.sin(i*0.4)*50,16,400, 0x808080);   
          }
         
         
          stage.addEventListener(Event.ENTER_FRAME, onEnter);    
        }//ctor
        
        public var myObj:xObj;

        public var pic:BitmapData;
        
        public function connPart(o:xObj, ia:int, ib:int, r:Number):xSpring
        {
          var w:xSpring;  w = new xSpring();
          w.pa = o.vecPart[ia];; w.pb = o.vecPart[ib];
          w.rest = r;    o.vecSpring.push(w);
          return w;           
        }//connp
        
        public var temp:Rectangle = new Rectangle();
        public function drawRect(to:BitmapData, ax:Number, ay:Number, aw:Number, ah:Number, c:uint):void
        { temp.x= ax;temp.y=ay;temp.width=aw;temp.height=ah;to.fillRect(temp, c); }

        public var gt:int = 0;
        
        public function onEnter(e:Event):void
        {
            graphics.clear();
            graphics.lineStyle(2, 0);
            graphics.beginBitmapFill(pic, null, false, false);
             graphics.drawRect(0,0, 465, 465);
            graphics.endFill();

            myObj.wall = pic;            
            var i:int;
            for (i = 0; i < 10; i+=1)
            {   myObj.update(0.1, 0, 0.5); }
            myObj.draw(graphics);          
            
            if (gt % 60 == 0)
            { myObj.shoot((Math.random()<0.5 ? 12 : -12 ), (Math.random()*-8)-8 ); }       
            
            
            gt +=1;  
        }//onenter
        
    }//classend
}
import flash.display.BitmapData;
import flash.display.Graphics;

internal class xObj
{
  public var vecPart:Vector.<xPart> = new Vector.<xPart>(0,false);
  public var vecSpring:Vector.<xSpring> = new Vector.<xSpring>(0,false);    

  public var wall:BitmapData = null;
  
  public function shoot(vx:Number, vy:Number):void
  {
      var i:int; var num:int; var a:xPart;
      num = vecPart.length;
      for (i =0; i <num;i+=1)
      {
        a = vecPart[i];
        a.vx = vx; a.vy = vy;
      }      
  }///shoot

  public function draw(g:Graphics):void
  {
      var i:int; var num:int; 
      var a:xPart; var b:xPart;
       var w:xSpring;
      num = vecPart.length;
      for (i =0; i <num;i+=1)
      {  a = vecPart[i];  g.drawCircle(a.cx,a.cy, 4);  }

      num = vecSpring.length;
      for (i = 0; i < num; i+=1)
      {
        w = vecSpring[i];
        a = w.pa; b = w.pb;
        g.moveTo(a.cx, a.cy);
        g.lineTo(b.cx, b.cy);
      }//nexti
      
  }//draw

  public function isWall(ax:Number, ay:Number):Boolean
  { return wall.getPixel(ax, ay) < 0xFFffFF; }    

  public function update(dt:Number, gx:Number=0, gy:Number=0):void
  {
      var i:int; var num:int; var a:xPart;
      num = vecPart.length;
      for (i =0; i <num;i+=1)
      {
        a = vecPart[i];
        a.vx *= 0.995;  a.vy *= 0.995;
        a.vx += gx*dt; a.vy += gy*dt;
        a.invma = 1 / a.mass;
        
        if (a.vy > 0 && a.cy > 465)
        { a.cy =465; a.vy *= -0.5; }
        
        if (wall == null) { continue; }
          
        if (a.vx > 0 && isWall(a.cx+a.rad+a.vx, a.cy)) { a.vx *=-0.5; }  
        if (a.vx < 0 && isWall(a.cx-a.rad+a.vx, a.cy)) { a.vx *=-0.5; }  
        if (a.vy > 0 && isWall(a.cx, a.cy+a.rad+a.vy)) { if (a.vy<0.5){a.vy=0;} a.vy *=-0.5; }  
        if (a.vy < 0 && isWall(a.cx, a.cy-a.rad+a.vy)) { a.vy *=-0.5; }  

        a.cx += a.vx * dt; a.cy += a.vy * dt;   
               
      }//nexti

      var w:xSpring;     
      num = vecSpring.length;
      for (i = 0; i < num; i+=1)
      {
        w = vecSpring[i];
        w.update(dt);  
      }//nexti      
      
  }//update    
    
}//xobj

internal class xPart
{
  public var cx:Number = 0;
  public var cy:Number = 0;
  public var vx:Number = 0;
  public var vy:Number = 0;  
  public var mass:Number = 1;
  public var invma:Number = 1; 
  public var rad:Number = 4;    
}//xpart


internal class xSpring
{
  public var pa:xPart = null;
  public var pb:xPart = null;
  public var rest:Number = 10;
  
  public function update(dt:Number):void
  {
    var dx:Number;   var dy:Number;
    var nx:Number;   var ny:Number;
    var ax:Number;   var ay:Number;
    var mag:Number;  var imp:Number;

     dx = pa.cx - pb.cx;  dy = pa.cy - pb.cy;
     mag = Math.sqrt(dx*dx + dy*dy);
     if (mag == 0) { mag = 0.00000001; }

     nx = dx / mag;    ny = dy / mag;            
     ax = pa.vx - pb.vx;     ay = pa.vy - pb.vy;

     imp = (((ax*nx+ay*ny) + ((mag - rest)/dt)) / (pa.invma+pb.invma)) * 0.5;
    
     pa.vx += imp * (nx*-0.5) * pa.invma;
     pa.vy += imp * (ny*-0.5) * pa.invma;
     pb.vx += imp * (nx*0.5) * pb.invma;
     pb.vy += imp * (ny*0.5) * pb.invma;
      
  }//update
    
}//spr




