/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/84vN
 */

// forked from bradsedito's [FF] HunyaBall





package{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.BlendMode;
    import flash.filters.BlurFilter;
    
    [SWF(width=465, height=465, frameRate=90)] 
    public class HunyaBall extends Sprite{
        private var ballList:Vector.<Ball> = new Vector.<Ball>;
        private var N:int = 2;
        
        public function HunyaBall(){
        
        var BLUR:Array = [new BlurFilter(6, 6, 4)]; 
        var b:int = this.numChildren - 0; 
        while(b > 0){ 
        b--; 
        this.getChildAt(b).filters = BLUR;     
}     
            
            var mouseAvg:Number;
            mouseAvg = (mouseX+mouseY)/2;
            for(var i:int = 0; i < N; i++){ 
 //             var ball:Ball = new Ball(10*Math.random()+10, 150, 0xFFFFFF, 1, -1); 
                var ball:Ball = new Ball(10*Math.random()+30,100, 0xFF0000, 0, 0, 0, 0); 
//              var ball:Ball = new Ball(30, Math.random()*20+40, Math.random()*0xFFFFFF, Math.random()*10-5, Math.random()*10-5);
                ball.x = ((Math.random()*100)+stage.stageWidth)  /2;
                ball.y = ((Math.random()*100)+stage.stageHeight) /2;
//              ball.x = Math.random()*465;
//              ball.y = Math.random()*465;
                ball.blendMode = BlendMode.ADD;
//              ball.blendMode = BlendMode.INVERT; 
//              ball.rotationZ = rotationZ++; 
                addChild(ball);
                ballList.push(ball);
            } 
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
            
        }
        
        private function onEnterFrame(event:Event):void{
            for(var i:int = 0; i < N; i++){
                var ball:Ball = ballList[i];
                ball.update();
                if(ball.x > 465+70) ball.x = -70;
                else if(ball.x < -70) ball.x = 465+70;
                if(ball.y > 465+70) ball.y = -70;
                else if(ball.y < -70) ball.y = 465+70;
            }
        } 
    }
}

import flash.display.Sprite;
import flash.filters.DropShadowFilter;
import flash.geom.Point;

class Ball extends Sprite{
    private var vertexList:Vector.<Vertex> = new Vector.<Vertex>;
    private var pointList:Vector.<Point> = new Vector.<Point>;
    private var vertex:int, radius: Number, color:uint;
    private var preMouseX:Number, preMouseY:Number;
    private var vx:Number, vy:Number;
    private var absX:Number, absY:Number;
    private const D:Number = 200;
    
    public function Ball(vertexNum:int, radius:Number, color:uint, vx:Number, vy:Number, absX:Number, absY:Number){
        this.vertex = vertexNum; this.radius = radius;     this.color = color;    this.vx = vx; this.vy = vy; this.absX = D/2, this.absY = D/2;  
        
        for(var i:Number = 0; i < vertex; ++i){
            pointList.push(new Point(0, 0));
            vertexList.push(new Vertex(0, 0));
        }
        filters = [new DropShadowFilter(0, 0, 0x000000, 0.8, 60, 60, 4, 3, false)];
        shape();
    }
    
    private function shape():void{
        for(var i:Number = 0; i < pointList.length; ++i){
            var k:Number = pointList.length/vertex;
            var num:Number = Math.abs(k/2 - i % k);
            var h:Number = radius*Math.cos(Math.PI*2/vertex/2);
            var r: Number = h/Math.cos((Math.PI*2/vertex/2)*(num/(k/2)));
            pointList[i].x = r*Math.sin(i/pointList.length*Math.PI*2);
            pointList[i].y = -r*Math.cos(i/pointList.length*Math.PI*2);
        }
    }
    
    private function draw(v:Vector.<Vertex>, c: uint):void{
        graphics.clear();
        if(v.length >= 3){
            graphics.moveTo((v[v.length-1].x+v[0].x)/2, (v[v.length-1].y+v[0].y)/2);
            graphics.beginFill(c);
            for(var i:Number = 0; i < v.length; ++i)
                graphics.curveTo(v[i % v.length].x, v[i % v.length].y, (v[i % v.length].x+v[(i+1) % v.length].x)/2, (v[i % v.length].y+v[(i+1) % v.length].y)/2);
            graphics.endFill();
        }  
    }
    
    public function update():void{
        for(var i:Number = 0; i < vertexList.length; ++i){
            vertexList[i].update();
            vertexList[i].setAccel((pointList[i].x - vertexList[i].x)*10, (pointList[i].y - vertexList[i].y)*10);
            var dist:Number = Point.distance(new Point(mouseX, mouseY), vertexList[i]);
            if(dist < D){
                var par:Number = (D-dist)/D;
                vertexList[i].setAccel((mouseX - preMouseX)*par*50, (mouseY - preMouseY)*par*50);
            }
        }
        preMouseX = mouseX;
        preMouseY = mouseY;
        draw(vertexList, color);
        
        x += vx;
        y += vy;
    }
}

class Vertex extends Point{
    private var vx:Number, vy:Number, ax:Number, ay:Number;
    private const friction:Number = 0.95;
    private var preTime:Number;
    
    public function Vertex(xx: Number=0, yy: Number=0){
        x = xx; y = yy;
        vx = vy = ax = ay = 0;
        preTime = new Date().getTime();
    }
    
    public function update():void{
        var nowTime:Number = new Date().getTime();
        var t:Number = (nowTime - preTime)/1000;
        x += vx*t + 0.5*ax*t*t;
        y += vy*t + 0.5*ay*t*t;
        vx += ax*t;
        vy += ay*t;
        vx *= friction;
        vy *= friction;
        ax = ay = 0;
        preTime = nowTime;
    }
    
    public function setAccel(aax:Number=0, aay:Number=0):void{
        ax += aax;
        ay += aay;
    }
}
